/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.properties;

import dk.kvl.gui.components.OkCancelPanel;
import dk.kvl.gui.event.UpdateEvent;
import dk.kvl.gui.event.UpdateListener;
import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PropertyFrame
extends JFrame
implements ActionListener {
    private JTabbedPane content = new JTabbedPane();
    private JPanel tableAppearance = new JPanel(new BorderLayout());
    private AlignmentProperties properties = null;
    private JButton aColorButton = null;
    private JButton uColorButton = null;
    private JButton cColorButton = null;
    private JButton gColorButton = null;
    private Vector updateListeners = new Vector();

    public PropertyFrame(AlignmentProperties startProperties) {
        super("Properties");
        this.properties = startProperties;
        this.setLocation(300, 300);
        this.tableAppearanceSettings();
        this.setDefaultCloseOperation(2);
        this.setSize(400, 400);
        this.content.addTab("Appearance", this.tableAppearance);
        this.getContentPane().add(this.content);
        this.setVisible(true);
    }

    public void tableAppearanceSettings() {
        JLabel title = new JLabel("Appearance of Tables");
        JPanel titleHolder = new JPanel();
        titleHolder.add(title);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.aColorButton = new JButton("Change color for base: A");
        this.aColorButton.setForeground(this.properties.getAColor());
        this.aColorButton.addActionListener(this);
        buttonPanel.add(this.aColorButton);
        this.uColorButton = new JButton("Change color for base: U");
        this.uColorButton.setForeground(this.properties.getUColor());
        this.uColorButton.addActionListener(this);
        buttonPanel.add(this.uColorButton);
        this.cColorButton = new JButton("Change color for base: C");
        this.cColorButton.setForeground(this.properties.getCColor());
        this.cColorButton.addActionListener(this);
        buttonPanel.add(this.cColorButton);
        this.gColorButton = new JButton("Change color for base: G");
        this.gColorButton.setForeground(this.properties.getGColor());
        this.gColorButton.addActionListener(this);
        buttonPanel.add(this.gColorButton);
        final JCheckBox enableBox = new JCheckBox("Enable basecoloring", this.properties.isBaseColoringEnabled());
        enableBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PropertyFrame.this.properties.setBaseColoring(enableBox.isSelected());
            }
        });
        buttonPanel.add(enableBox);
        this.tableAppearance.add("South", new OkCancelPanel(this));
        this.tableAppearance.add("West", buttonPanel);
        this.tableAppearance.add("North", titleHolder);
    }

    public void actionPerformed(ActionEvent ae) {
        String event = ae.getActionCommand();
        if (event.equals("OK")) {
            this.fireUpdateEvent();
            this.dispose();
        } else if (event.equals("Cancel")) {
            this.dispose();
        } else {
            Component comp = (Component)ae.getSource();
            Color color = JColorChooser.showDialog(this, "Choose new color", comp.getForeground());
            if (color != null && !color.equals(comp.getForeground())) {
                if (event.equals("Change color for base: A")) {
                    this.properties.setAColor(color);
                    this.aColorButton.setForeground(color);
                } else if (event.equals("Change color for base: U")) {
                    this.properties.setUColor(color);
                    this.uColorButton.setForeground(color);
                } else if (event.equals("Change color for base: C")) {
                    this.properties.setCColor(color);
                    this.cColorButton.setForeground(color);
                } else if (event.equals("Change color for base: G")) {
                    this.properties.setGColor(color);
                    this.gColorButton.setForeground(color);
                }
            }
        }
    }

    public void addUpdateListener(UpdateListener ul) {
        this.updateListeners.add(ul);
    }

    public void fireUpdateEvent() {
        UpdateEvent ue = new UpdateEvent(this, 1, "updated");
        for (int i = 0; i < this.updateListeners.size(); ++i) {
            ((UpdateListener)this.updateListeners.get(i)).updatePerformed(ue);
        }
    }
}

