/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.sequencetools;

import dk.kvl.sequencetools.SequenceAlphabet;
import java.io.Serializable;

public class RNAAlphabet
implements SequenceAlphabet,
Serializable {
    private static char[] alphabet = new char[]{'A', 'a', 'U', 'u', 'C', 'c', 'G', 'g', '-', 'B', 'D', 'K', 'M', 'N', 'R', 'S', 'T', 'V', 'W', 'X', 'Y'};
    private final String label = "RNA";
    private final int alphabetType = 1;

    public char[] getAlphabet() {
        return alphabet;
    }

    public boolean isValidSequence(String sequence) {
        boolean result = true;
        boolean tmp = false;
        for (int i = 0; i < sequence.length(); ++i) {
            tmp = false;
            for (int j = 0; j < alphabet.length; ++j) {
                if (sequence.charAt(i) != alphabet[j]) continue;
                tmp = true;
                break;
            }
            if (tmp) continue;
            result = false;
            break;
        }
        return result;
    }

    public String getLabel() {
        return "RNA";
    }

    public int getAlphabetType() {
        return 1;
    }

    public boolean isValidSymbol(char aChar) {
        boolean result = false;
        for (int j = 0; j < alphabet.length; ++j) {
            if (aChar != alphabet[j]) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isPairing(char symbol1, char symbol2) {
        if (!(symbol1 != 'c' && symbol1 != 'C' || symbol2 != 'g' && symbol2 != 'G')) {
            return true;
        }
        if (!(symbol1 != 'g' && symbol1 != 'G' || symbol2 != 'c' && symbol2 != 'u' && symbol2 != 'C' && symbol2 != 'U')) {
            return true;
        }
        if (!(symbol1 != 'u' && symbol1 != 'U' || symbol2 != 'A' && symbol2 != 'a' && symbol2 != 'G' && symbol2 != 'g')) {
            return true;
        }
        return !(symbol1 != 'a' && symbol1 != 'A' || symbol2 != 'u' && symbol2 != 'U');
    }
}

