/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.sequencetools;

import dk.kvl.sequencetools.ArbitraryAlphabet;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.PairingmaskAlphabet;
import dk.kvl.sequencetools.RNAAlphabet;
import dk.kvl.sequencetools.SequenceAlphabet;
import dk.kvl.tools.IntArray;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sequence
implements Serializable,
Comparable {
    private boolean valid = true;
    private int number = -1;
    private SequenceAlphabet alphabet;
    private String label = null;
    private char[] sequence = null;
    protected int[] pairings = null;
    protected Vector columnLabels = new Vector();
    protected Vector sequenceColumns = new Vector();
    private StringBuffer tmpSequence;
    private IntArray tmpPairings = null;
    private StringBuffer information = new StringBuffer();
    private boolean background = false;
    private boolean foreground = false;
    private Color[] foregroundColors;
    private Color[] backgroundColors;
    int align_bpPosition = -1;
    int numberOfColumns = -1;
    int residue = -1;
    int color_b = -1;
    int color_r = -1;
    int color_g = -1;
    int color2_b = -1;
    int color2_r = -1;
    int color2_g = -1;

    public Sequence() {
        this(1);
    }

    public Sequence(int alpha) {
        this.alphabet = Sequence.getAlphabet(alpha);
        this.tmpSequence = new StringBuffer();
    }

    public Sequence(String label, String sequence, int alph, boolean checkSequence) {
        this.alphabet = Sequence.getAlphabet(alph);
        if (checkSequence && !this.alphabet.isValidSequence(sequence)) {
            this.valid = false;
        }
        this.label = label;
        this.sequence = sequence.toCharArray();
    }

    public static SequenceAlphabet getAlphabet(int alph) {
        SequenceAlphabet sa = null;
        sa = alph == 1 ? new RNAAlphabet() : (alph == 2 ? new PairingmaskAlphabet() : new ArbitraryAlphabet());
        return sa;
    }

    public SequenceAlphabet getAlphabet() {
        return this.alphabet;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSequence() {
        return new String(this.sequence);
    }

    public char[] getSequenceArray() {
        return this.sequence;
    }

    public int getType() {
        return this.alphabet.getAlphabetType();
    }

    public void setAlphabet(int newType) {
        this.alphabet = Sequence.getAlphabet(newType);
    }

    public int getLength() {
        return this.sequence.length;
    }

    public Sequence getSubsequence(int begin, int end) {
        Sequence seq = null;
        if (end < this.getLength() && begin < end && begin >= 0) {
            try {
                seq = new Sequence(this.getLabel(), this.getSequence().substring(begin, end + 1), this.getType(), false);
                seq.setBackground(this.background);
                seq.setForeground(this.foreground);
                Color[] bColors = new Color[end + 1 - begin];
                System.arraycopy(this.backgroundColors, begin, bColors, 0, end + 1 - begin);
                seq.setBackgroundColors(bColors);
                Color[] fColors = new Color[end + 1 - begin];
                System.arraycopy(this.foregroundColors, begin, fColors, 0, end + 1 - begin);
                seq.setForegroundColors(fColors);
                Vector cLabels = new Vector();
                Vector sColumns = new Vector();
                for (int i = begin; i < end + 1; ++i) {
                    cLabels.add(this.columnLabels.get(i));
                    sColumns.add(this.sequenceColumns.get(i));
                }
                seq.setColumnLabels(cLabels);
                seq.setSequenceColumns(sColumns);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return seq;
    }

    public char getSymbolAt(int index) {
        if (index >= 0 && index < this.getLength()) {
            return this.sequence[index];
        }
        return ' ';
    }

    public void setSymbolAt(int index, char symbol) {
        this.sequence[index] = symbol;
    }

    public boolean swapSymbols(int indexA, int indexB) {
        boolean result = true;
        if (indexA < 0 || indexB < 0) {
            result = false;
        } else if (indexA >= this.sequence.length || indexB >= this.sequence.length) {
            result = false;
        } else {
            Color tmpCol;
            char tmp = this.sequence[indexA];
            this.sequence[indexA] = this.sequence[indexB];
            this.sequence[indexB] = tmp;
            if (this.background) {
                tmpCol = this.backgroundColors[indexA];
                this.backgroundColors[indexA] = this.backgroundColors[indexB];
                this.backgroundColors[indexB] = tmpCol;
            }
            if (this.foreground) {
                tmpCol = this.foregroundColors[indexA];
                this.foregroundColors[indexA] = this.foregroundColors[indexB];
                this.backgroundColors[indexB] = tmpCol;
            }
            if (this.pairings != null && this.pairings.length == this.sequence.length) {
                if (this.pairings[indexA] >= 0 && this.pairings[this.pairings[indexA]] == indexA) {
                    this.pairings[this.pairings[indexA]] = indexB;
                }
                if (this.pairings[indexB] >= 0 && this.pairings[this.pairings[indexB]] == indexB) {
                    this.pairings[this.pairings[indexB]] = indexA;
                }
                int tmpP = this.pairings[indexA];
                this.pairings[indexA] = this.pairings[indexB];
                this.pairings[indexB] = tmpP;
                String[] max = (String[])this.sequenceColumns.remove(Math.max(indexA, indexB));
                String[] min = (String[])this.sequenceColumns.remove(Math.min(indexA, indexB));
                this.sequenceColumns.add(Math.min(indexA, indexB), max);
                this.sequenceColumns.add(Math.max(indexA, indexB), min);
            }
            result = true;
        }
        return result;
    }

    public char[] changeSymbol(char newChar, int[] index) {
        char[] oldSymbols = new char[index.length];
        for (int i = 0; i < index.length; ++i) {
            oldSymbols[i] = 33;
            if (index[i] < 0 || index[i] >= this.sequence.length || !this.alphabet.isValidSymbol(newChar)) continue;
            oldSymbols[i] = this.sequence[index[i]];
            this.sequence[index[i]] = newChar;
        }
        return oldSymbols;
    }

    public char changeSymbol(char newChar, int index) {
        char oldSymbol = '!';
        if (index >= 0 && index < this.sequence.length && this.alphabet.isValidSymbol(newChar)) {
            oldSymbol = this.sequence[index];
            this.sequence[index] = newChar;
        }
        return oldSymbol;
    }

    public boolean toUpperCase(int index) {
        boolean result = false;
        if (index >= 0 && index < this.sequence.length && Character.isLowerCase(this.sequence[index])) {
            char newChar;
            this.sequence[index] = newChar = Character.toUpperCase(this.sequence[index]);
            result = true;
        }
        return result;
    }

    public int[] toUpperCase(int[] index) {
        int[] changed = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            changed[i] = -1;
            if (!this.toUpperCase(index[i])) continue;
            changed[i] = index[i];
        }
        return changed;
    }

    public boolean toLowerCase(int index) {
        boolean result = false;
        if (index >= 0 && index < this.sequence.length && Character.isUpperCase(this.sequence[index])) {
            char newChar;
            this.sequence[index] = newChar = Character.toLowerCase(this.sequence[index]);
            result = true;
        }
        return result;
    }

    public void toLowerCase() {
        for (int i = 0; i < this.getLength(); ++i) {
            this.sequence[i] = Character.toLowerCase(this.sequence[i]);
        }
    }

    public int[] toLowerCase(int[] index) {
        int[] changed = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            changed[i] = -1;
            if (!this.toLowerCase(index[i])) continue;
            changed[i] = index[i];
        }
        return changed;
    }

    public String toString() {
        return this.getLabel() + ":\t" + this.getSequence();
    }

    public void setLabel(String name) {
        this.label = name;
    }

    public void addColumnLabel(String label, int column) {
        this.columnLabels.add(label);
        if (label.equals("align_bp")) {
            this.align_bpPosition = this.columnLabels.size() - 1;
        }
    }

    public void prepareForColumns() {
        this.numberOfColumns = this.columnLabels.size();
        for (int i = 0; i < this.columnLabels.size(); ++i) {
            char end;
            String colLabel = (String)this.columnLabels.get(i);
            if (colLabel.equals("residue")) {
                this.residue = i;
                continue;
            }
            if (colLabel.startsWith("color2")) {
                this.foreground = true;
                end = colLabel.charAt(colLabel.length() - 1);
                if (end == 'r') {
                    this.color2_r = i;
                    continue;
                }
                if (end == 'b') {
                    this.color2_b = i;
                    continue;
                }
                if (end != 'g') continue;
                this.color2_g = i;
                continue;
            }
            if (colLabel.startsWith("color")) {
                this.background = true;
                end = colLabel.charAt(colLabel.length() - 1);
                if (end == 'r') {
                    this.color_r = i;
                    continue;
                }
                if (end == 'b') {
                    this.color_b = i;
                    continue;
                }
                if (end != 'g') continue;
                this.color_g = i;
                continue;
            }
            if (!colLabel.equals("align_bp")) continue;
            this.align_bpPosition = i;
        }
    }

    public void addColumns(String line) throws Exception {
        Matcher wordMatcher = Pattern.compile("\\S+").matcher(line);
        String[] columns = new String[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (wordMatcher.find()) {
                String word;
                columns[i] = word = line.substring(wordMatcher.start(), wordMatcher.end());
                if (i != this.residue) continue;
                this.tmpSequence.append(word);
                continue;
            }
            throw new Exception("Invalid columnfile: to few columns");
        }
        if (wordMatcher.find()) {
            throw new Exception("Invalid columnfile: to many columns");
        }
        this.sequenceColumns.add(columns);
        if (this.align_bpPosition != -1) {
            String col = columns[this.align_bpPosition];
            if (col.equals(".")) {
                this.getTmpPairings().add(-1);
            } else {
                try {
                    this.getTmpPairings().add(Integer.parseInt(col) - 1);
                }
                catch (Exception e) {
                    this.getTmpPairings().add(-1);
                }
            }
        }
    }

    public int[] finalProcessing() {
        try {
            this.sequence = this.tmpSequence.toString().toCharArray();
            if (this.foreground || this.background) {
                this.foregroundColors = new Color[this.getLength()];
                this.backgroundColors = new Color[this.getLength()];
                for (int i = 0; i < this.sequenceColumns.size(); ++i) {
                    String[] columns = (String[])this.sequenceColumns.get(i);
                    if (this.foreground) {
                        this.foregroundColors[i] = new Color(Float.parseFloat(columns[this.color2_r]), Float.parseFloat(columns[this.color2_g]), Float.parseFloat(columns[this.color2_b]));
                    }
                    if (!this.background) continue;
                    this.backgroundColors[i] = new Color(Float.parseFloat(columns[this.color_r]), Float.parseFloat(columns[this.color_g]), Float.parseFloat(columns[this.color_b]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.foreground = false;
            this.background = false;
        }
        String[] remColumns = new String[]{"label", "residue", "seqpos", "alignpos", "align_bp", "color_r", "color_g", "color_b", "color2_r", "color2_g", "color2_b"};
        IntArray colNumbers = new IntArray();
        Vector newLabels = new Vector();
        for (int i = this.columnLabels.size() - 1; i >= 0; --i) {
            boolean b = true;
            for (int j = 0; j < remColumns.length; ++j) {
                if (!((String)this.columnLabels.get(i)).equals(remColumns[j])) continue;
                b = false;
                break;
            }
            if (!b) continue;
            colNumbers.add(i);
            newLabels.add(this.columnLabels.get(i));
        }
        Vector<String[]> newSequenceColumns = new Vector<String[]>();
        for (int i = 0; i < this.getLength(); ++i) {
            String[] colInfo = new String[colNumbers.getLength()];
            String[] oldColInfo = this.getColumnInfo(i);
            for (int j = 0; j < colNumbers.getLength(); ++j) {
                colInfo[j] = oldColInfo[colNumbers.get(j)];
            }
            newSequenceColumns.add(colInfo);
        }
        this.columnLabels = newLabels;
        this.sequenceColumns = newSequenceColumns;
        if (this.align_bpPosition != -1) {
            this.pairings = this.tmpPairings.toArray();
        }
        return this.pairings;
    }

    public boolean pairBases(int col1, int col2) {
        this.sequence[col1] = Character.toUpperCase(this.sequence[col1]);
        this.sequence[col2] = Character.toUpperCase(this.sequence[col2]);
        this.pairings[col1] = col2;
        this.pairings[col2] = col1;
        return true;
    }

    public IntArray getTmpPairings() {
        if (this.tmpPairings == null) {
            this.tmpPairings = new IntArray(100);
        }
        return this.tmpPairings;
    }

    public Color getBackgroundColor(int index) {
        if (this.background) {
            return this.backgroundColors[index];
        }
        return Color.WHITE;
    }

    public Color getForegroundColor(int index) {
        if (this.foreground) {
            return this.foregroundColors[index];
        }
        return Color.BLACK;
    }

    public void setSequenceColumns(Vector seqColumns) {
        this.sequenceColumns = seqColumns;
    }

    public void setColumnLabels(Vector labels) {
        this.columnLabels = labels;
    }

    public void setForeground(boolean f) {
        this.foreground = f;
    }

    public void setBackground(boolean f) {
        this.background = f;
    }

    public void setBackgroundColors(Color[] colors) {
        this.backgroundColors = colors;
    }

    public void setForegroundColors(Color[] colors) {
        this.foregroundColors = colors;
    }

    public void addInformation(String info) {
        this.information.append(info);
        if (!info.endsWith("\n")) {
            this.information.append("\n");
        }
    }

    public String getInformation() {
        return this.information.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rotateLeft(int start, int end) {
        if (start >= end) return false;
        int gaps = 0;
        while (this.getSymbolAt(end - gaps) == '-' && end - gaps >= start) {
            ++gaps;
        }
        if (gaps <= 0) return false;
        for (int i = end - 1; i >= start; --i) {
            this.swapSymbols(i, i + 1);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rotateRight(int start, int end) {
        if (start >= end) return false;
        int gaps = 0;
        while (this.getSymbolAt(start + gaps) == '-' && start + gaps <= end) {
            ++gaps;
        }
        if (gaps <= 0) return false;
        for (int i = start + 1; i <= end; ++i) {
            this.swapSymbols(i - 1, i);
        }
        return true;
    }

    public String[] getColumnInfo(int index) {
        if (index >= 0 && index < this.sequenceColumns.size()) {
            return (String[])this.sequenceColumns.get(index);
        }
        return null;
    }

    public String[] getColumnLabels() {
        return this.columnLabels.toArray(new String[this.columnLabels.size()]);
    }

    public void emptyInfo() {
    }

    public boolean isBackgroundColred() {
        return this.background;
    }

    public boolean isForegroundColred() {
        return this.foreground;
    }

    public void setInformation(String info) {
        this.information = new StringBuffer(info);
    }

    public void setNumber(int newNumber) {
        this.number = newNumber;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean setPairingmask(char[] pairingmask) {
        if (this.sequence.length == pairingmask.length) {
            char[] tmpPair = new char[pairingmask.length];
            for (int i = 0; i < this.sequence.length; ++i) {
                tmpPair[i] = Character.isUpperCase(this.sequence[i]) && pairingmask[i] != '-' && pairingmask[i] != '.' ? pairingmask[i] : 45;
            }
            int[] tmpPairings = PairingMask.updatePairings(tmpPair);
            if (this.pairings != null) {
                for (int i = 0; i < this.pairings.length; ++i) {
                    if (tmpPairings[i] != PairingMask.NO_PAIRING || this.pairings[i] == PairingMask.NO_PAIRING) continue;
                    tmpPairings[i] = this.pairings[i];
                }
            }
            this.pairings = tmpPairings;
            return true;
        }
        return false;
    }

    public int[] getPairings() {
        return this.pairings;
    }

    public int getPairing(int index) {
        if (this.pairings == null) {
            return PairingMask.NO_PAIRINGMASK;
        }
        if (index >= 0 && index < this.pairings.length) {
            return this.pairings[index];
        }
        return PairingMask.OUT_OF_SEQUENCE;
    }

    public char removeColumn(int index) {
        int i;
        char removed = this.getSymbolAt(index);
        char[] newSequence = new char[this.sequence.length - 1];
        for (i = 0; i < index; ++i) {
            newSequence[i] = this.sequence[i];
        }
        for (i = index + 1; i < this.sequence.length; ++i) {
            newSequence[i - 1] = this.sequence[i];
        }
        this.sequence = newSequence;
        return removed;
    }

    public void addColumn(int index, char symbol) {
        char[] newSequence = new char[this.sequence.length + 1];
        if (index == 0) {
            newSequence[0] = symbol;
            for (int i = 0; i < this.sequence.length; ++i) {
                newSequence[i + 1] = this.sequence[i];
            }
        } else if (index >= this.sequence.length) {
            for (int i = 0; i < this.sequence.length; ++i) {
                newSequence[i] = this.sequence[i];
            }
            newSequence[newSequence.length - 1] = symbol;
        } else {
            int i;
            for (i = 0; i < index; ++i) {
                newSequence[i] = this.sequence[i];
            }
            newSequence[index] = symbol;
            for (i = index; i < this.sequence.length; ++i) {
                newSequence[i + 1] = this.sequence[i];
            }
        }
        this.updateColumns(index);
        if (this.foreground) {
            this.insertForeground(index);
        }
        if (this.background) {
            this.insertBackground(index);
        }
        this.sequence = newSequence;
    }

    public void setCases() {
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.getPairing(i) > -1) {
                this.setSymbolAt(i, Character.toUpperCase(this.getSymbolAt(i)));
                continue;
            }
            this.setSymbolAt(i, Character.toLowerCase(this.getSymbolAt(i)));
        }
    }

    public void removeColors() {
        this.background = false;
        this.foreground = false;
        this.backgroundColors = null;
        this.foregroundColors = null;
    }

    public int[][] unpair(int[] cols) {
        int[][] pairs = new int[cols.length][2];
        for (int i = 0; i < cols.length; ++i) {
            if (this.getPairing(cols[i]) >= 0) {
                pairs[i][0] = cols[i];
                pairs[i][1] = this.getPairing(cols[i]);
                this.toLowerCase(this.getPairing(cols[i]));
                this.pairings[this.getPairing((int)cols[i])] = -1;
                this.toLowerCase(cols[i]);
                this.pairings[cols[i]] = -1;
                continue;
            }
            pairs[i][0] = -1;
            pairs[i][1] = -1;
        }
        return pairs;
    }

    public int compareTo(Object o) {
        int before = -1;
        boolean equal = false;
        boolean after = true;
        Sequence s = (Sequence)o;
        if (s.getNumber() > this.getNumber()) {
            return -1;
        }
        if (s.getNumber() < this.getNumber()) {
            return 1;
        }
        return 0;
    }

    private void updateColumns(int index) {
        int i;
        int[] newPairs = new int[this.pairings.length + 1];
        if (index == 0) {
            newPairs[0] = PairingMask.NO_PAIRING;
            for (i = 0; i < this.pairings.length; ++i) {
                newPairs[i + 1] = this.pairings[i] + 1;
            }
        } else if (index >= this.pairings.length) {
            for (i = 0; i < this.pairings.length; ++i) {
                newPairs[i] = this.pairings[i];
            }
            newPairs[newPairs.length - 1] = PairingMask.NO_PAIRING;
        } else {
            for (i = 0; i < index; ++i) {
                newPairs[i] = this.pairings[i];
                if (newPairs[i] < index) continue;
                int n = i;
                newPairs[n] = newPairs[n] + 1;
            }
            newPairs[index] = PairingMask.NO_PAIRING;
            for (i = index; i < this.pairings.length; ++i) {
                newPairs[i + 1] = this.pairings[i];
                if (newPairs[i + 1] < index) continue;
                int n = i + 1;
                newPairs[n] = newPairs[n] + 1;
            }
        }
        this.pairings = newPairs;
        if (this.columnLabels != null && this.columnLabels.size() > 0) {
            String[] cs = new String[this.columnLabels.size()];
            for (int i2 = 0; i2 < cs.length; ++i2) {
                cs[i2] = "0";
            }
            if (index < this.sequenceColumns.size()) {
                this.sequenceColumns.add(index, cs);
            } else {
                this.sequenceColumns.add(cs);
            }
        }
    }

    private void insertBackground(int index) {
        this.backgroundColors = this.insertColor(this.backgroundColors, index, Color.WHITE);
    }

    private void insertForeground(int index) {
        this.foregroundColors = this.insertColor(this.foregroundColors, index, Color.BLACK);
    }

    private Color[] insertColor(Color[] colors, int index, Color col) {
        Color[] newColors = new Color[colors.length + 1];
        if (index == 0) {
            newColors[0] = col;
            for (int i = 0; i < colors.length; ++i) {
                newColors[i + 1] = colors[i];
            }
        } else if (index >= colors.length) {
            for (int i = 0; i < colors.length; ++i) {
                newColors[i] = colors[i];
            }
            newColors[newColors.length - 1] = col;
        } else {
            int i;
            for (i = 0; i < index; ++i) {
                newColors[i] = colors[i];
            }
            newColors[index] = col;
            for (i = index; i < colors.length; ++i) {
                newColors[i + 1] = colors[i];
            }
        }
        return newColors;
    }

    public void setPairings(int[] pairings) {
        this.pairings = pairings;
    }

    public void deletePairing(int index) {
        this.pairings[index] = PairingMask.NO_PAIRING;
    }
}

