/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment;

import dk.kvl.gui.properties.AlignmentProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AlignmentControlPanel
extends JPanel
implements ActionListener {
    private JButton changeButton;
    private JButton splitButton = null;
    private JButton unsplitButton = null;
    private JButton pairButton;
    private JButton unpairButton;
    private JButton pairColButton;
    private JButton singleSelectButton;
    private JButton doubleSelectButton;
    private final AlignmentProperties properties;

    public AlignmentControlPanel(AlignmentProperties prop, String[] columnNames) {
        this.setLayout(new BoxLayout(this, 1));
        this.properties = prop;
        AlignmentControlPanel alignmentControlPanel = this;
        ImageIcon pairbasesIcon = new ImageIcon(alignmentControlPanel.properties.getIconDir() + "/pairbases.jpg");
        this.pairButton = new JButton(pairbasesIcon);
        this.pairButton.getAccessibleContext().setAccessibleName("Pair bases");
        this.pairButton.setToolTipText("Pair selected bases in the selected columns, and make uppercase - Ctrl-B");
        this.pairButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(this.pairButton);
        AlignmentControlPanel alignmentControlPanel2 = this;
        ImageIcon unpairbasesIcon = new ImageIcon(alignmentControlPanel2.properties.getIconDir() + "/unpairbases.jpg");
        this.unpairButton = new JButton(unpairbasesIcon);
        this.unpairButton.getAccessibleContext().setAccessibleName("unpair bases");
        this.unpairButton.setToolTipText("Umpair selected bases in the selected columns, and make lowercase ");
        this.unpairButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(this.unpairButton);
        AlignmentControlPanel alignmentControlPanel3 = this;
        ImageIcon paircolIcon = new ImageIcon(alignmentControlPanel3.properties.getIconDir() + "/paircolumns.jpg");
        this.pairColButton = new JButton(paircolIcon);
        this.pairColButton.getAccessibleContext().setAccessibleName("Pair columns");
        this.pairColButton.setToolTipText("Pair all matching bases in the selected columns - Ctrl-K");
        this.pairColButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(this.pairColButton);
        AlignmentControlPanel alignmentControlPanel4 = this;
        ImageIcon changeIcon = new ImageIcon(alignmentControlPanel4.properties.getIconDir() + "/change.jpg");
        this.changeButton = new JButton(changeIcon);
        this.changeButton.getAccessibleContext().setAccessibleName("change");
        this.changeButton.setToolTipText("Change the symbol to any symbol in the alphabet - Alt-T");
        this.changeButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.changeButton.addActionListener(this);
        this.add(this.changeButton);
        AlignmentControlPanel alignmentControlPanel5 = this;
        ImageIcon splitIcon = new ImageIcon(alignmentControlPanel5.properties.getIconDir() + "/split.jpg");
        this.splitButton = new JButton(splitIcon);
        this.splitButton.getAccessibleContext().setAccessibleName("split");
        this.splitButton.setToolTipText("Splits the view - Ctrl-I");
        this.splitButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.splitButton.addActionListener(this);
        this.add(this.splitButton);
        AlignmentControlPanel alignmentControlPanel6 = this;
        ImageIcon unsplitIcon = new ImageIcon(alignmentControlPanel6.properties.getIconDir() + "/unsplit.jpg");
        this.unsplitButton = new JButton(unsplitIcon);
        this.unsplitButton.getAccessibleContext().setAccessibleName("unsplit");
        this.unsplitButton.setToolTipText("Unsplits the view - Ctrl+Shift-I");
        this.unsplitButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.unsplitButton.addActionListener(this);
        this.unsplitButton.setEnabled(false);
        this.add(this.unsplitButton);
        AlignmentControlPanel alignmentControlPanel7 = this;
        ImageIcon singleIcon = new ImageIcon(alignmentControlPanel7.properties.getIconDir() + "/singleselect.jpg");
        this.singleSelectButton = new JButton(singleIcon);
        this.singleSelectButton.getAccessibleContext().setAccessibleName("single");
        this.singleSelectButton.setToolTipText("Activates Single Select Mode");
        this.singleSelectButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.singleSelectButton.addActionListener(this);
        this.singleSelectButton.setEnabled(true);
        this.add(this.singleSelectButton);
        AlignmentControlPanel alignmentControlPanel8 = this;
        ImageIcon doubleIcon = new ImageIcon(alignmentControlPanel8.properties.getIconDir() + "/doubleselect.jpg");
        this.doubleSelectButton = new JButton(doubleIcon);
        this.doubleSelectButton.getAccessibleContext().setAccessibleName("double");
        this.doubleSelectButton.setToolTipText("Activates Double Select Mode");
        this.doubleSelectButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.doubleSelectButton.addActionListener(this);
        this.doubleSelectButton.setEnabled(false);
        this.add(this.doubleSelectButton);
    }

    public void addActionListener(ActionListener listener) {
        this.splitButton.addActionListener(listener);
        this.unsplitButton.addActionListener(listener);
        this.changeButton.addActionListener(listener);
        this.pairButton.addActionListener(listener);
        this.unpairButton.addActionListener(listener);
        this.pairColButton.addActionListener(listener);
        this.singleSelectButton.addActionListener(listener);
        this.doubleSelectButton.addActionListener(listener);
    }

    public void actionPerformed(ActionEvent ae) {
        if (((JButton)ae.getSource()).getAccessibleContext().getAccessibleName().equals("split")) {
            this.unsplitButton.setEnabled(true);
            this.splitButton.setEnabled(false);
        } else if (((JButton)ae.getSource()).getAccessibleContext().getAccessibleName().equals("unsplit")) {
            this.unsplitButton.setEnabled(false);
            this.splitButton.setEnabled(true);
        }
        if (((JButton)ae.getSource()).getAccessibleContext().getAccessibleName().equals("single")) {
            this.doubleSelectButton.setEnabled(true);
            this.singleSelectButton.setEnabled(false);
        } else if (((JButton)ae.getSource()).getAccessibleContext().getAccessibleName().equals("double")) {
            this.doubleSelectButton.setEnabled(false);
            this.singleSelectButton.setEnabled(true);
        }
    }

    public void enableSplitButtons(boolean split) {
        if (split) {
            this.splitButton.setEnabled(false);
            this.unsplitButton.setEnabled(true);
        } else {
            this.unsplitButton.setEnabled(false);
            this.splitButton.setEnabled(true);
        }
    }
}

