/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment;

import dk.kvl.controller.ProjectController;
import dk.kvl.gui.alignment.AlignmentContainer;
import dk.kvl.gui.alignment.AlignmentPanel;
import dk.kvl.gui.components.DependingTextFields;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.gui.properties.ProjectProperties;
import dk.kvl.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlignmentFrame
extends JFrame
implements ActionListener,
ClipboardOwner,
ComponentListener {
    public static final ThreadGroup sarseThreads = new ThreadGroup("Sarse Threads");
    private String releaseDate = "12. oct. 2007";
    private String version = "1.37";
    private JFileChooser fileChooser = null;
    private String visibleComponent;
    private Hashtable projects = new Hashtable();
    private static String SARSE_HOME;
    private JMenu fileMenu;
    private ProjectController projectController;
    private JFrame historyWindow;
    private JFrame overviewWindow;
    private JPanel overviewCards;
    private JPanel historyCards;
    private File newProjectFile = null;
    private DependingTextFields newProjectInputFields = null;
    private JFrame newProjectInputFrame = null;
    private Hashtable propertyFiles;
    private boolean analyzing = false;
    private final JPanel basePanel = new JPanel();
    private JCheckBoxMenuItem history;
    private JCheckBoxMenuItem overview;
    private JCheckBoxMenuItem grid;
    private static String openFile;
    private static String configurationName;
    private static String openProject;
    private boolean selectionMode;
    private boolean splitMode;
    private boolean splitAlign;
    private int operationMode;
    private Point p1;
    private Point p2;
    private Point p3;
    private int divider;
    private JRadioButtonMenuItem primaryOp;
    private JRadioButtonMenuItem bothSel;
    private AlignmentProperties properties;
    private JMenuItem wDir;
    private static AlignmentFrame thisFrame;
    private JTabbedPane tabs = new JTabbedPane();
    private String cwd;

    public AlignmentFrame(String title, String[] args) throws Exception {
        super(title);
        this.windowListener();
        this.loadProperties();
        if (this.properties.getLastPath() == null) {
            this.properties.setLastPath(AlignmentProperties.getProjectDir());
        }
        this.projectController = new ProjectController();
        this.getContentPane().setLayout(new BorderLayout());
        this.cwd = System.getProperty("user.dir");
        this.getContentPane().add(this.tabs);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index = AlignmentFrame.this.tabs.getSelectedIndex();
                if (index > -1) {
                    AlignmentFrame.this.showHistory(AlignmentFrame.this.currentProject());
                    AlignmentFrame.this.showOverview(AlignmentFrame.this.currentProject());
                    AlignmentFrame.this.setWdir(AlignmentFrame.this.currentProject());
                }
            }
        });
        this.createMenuBar();
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        this.setLocation(50, 50);
        this.setSize(800, 600);
        this.setVisible(true);
        this.createOverviewWindow();
        this.createHistoryWindow();
        if (openFile != null) {
            this.newProject(openFile);
        }
        thisFrame = this;
        if (args.length > 0) {
            this.doArgs(args);
        }
    }

    private void doArgs(String[] args) {
        String file = null;
        String project = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--file=")) {
                file = args[i].substring(7);
                continue;
            }
            if (!args[i].startsWith("--project=")) continue;
            project = args[i].substring(10);
        }
        if (file == null) {
            if (project != null) {
                this.openProject(project);
            }
        } else if (project == null) {
            this.newProject(file);
        } else {
            this.newProjectFile = new File(file);
            if (this.projectExists(project)) {
                int confirm = JOptionPane.showConfirmDialog(null, "The project already exists. Continue anyway?");
                if (confirm == 0) {
                    this.createProject(project, System.getProperty("user.dir") + "/" + project);
                } else {
                    this.projectname();
                }
            } else {
                this.createProject(project, System.getProperty("user.dir") + "/" + project);
            }
        }
    }

    private void showHistory(String name) {
        ((CardLayout)this.historyCards.getLayout()).show(this.historyCards, name);
        this.historyCards.validate();
        this.historyCards.repaint();
    }

    private void showOverview(String name) {
        ((CardLayout)this.overviewCards.getLayout()).show(this.overviewCards, name);
        this.overviewCards.validate();
        this.overviewCards.repaint();
    }

    public void loadProperties() {
        try {
            File f = new File(AlignmentProperties.getProjectDir() + "properties.obj");
            if (f.exists()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    this.properties = (AlignmentProperties)ois.readObject();
                    ois.close();
                    this.properties.setFontName(this.properties.getTableFont().getName());
                    this.properties.setFontSize(this.properties.getFontSize());
                    this.validate();
                    this.repaint();
                }
                catch (Exception e) {
                    this.properties = new AlignmentProperties();
                }
            } else {
                this.properties = new AlignmentProperties();
            }
            this.properties.loadProgramController();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.getFileMenu());
        menuBar.add(this.getEditMenu());
        menuBar.add(this.getViewMenu());
        menuBar.add(this.getToolsMenu());
        menuBar.add(this.getInfoMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(this.getHelpMenu());
        menuBar.add(Box.createHorizontalStrut(5));
        this.setJMenuBar(menuBar);
    }

    public JMenu getEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        JMenuItem undoItem = new JMenuItem("Undo");
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        undoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().getAlignmentController().undo();
                }
            }
        });
        editMenu.add(undoItem);
        JMenuItem redoItem = new JMenuItem("Redo");
        redoItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        redoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().getAlignmentController().redo();
                }
            }
        });
        editMenu.add(redoItem);
        JMenuItem moveLeftItem = new JMenuItem("Move left");
        moveLeftItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        moveLeftItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().rotateRight();
                }
            }
        });
        editMenu.add(moveLeftItem);
        JMenuItem moveRightItem = new JMenuItem("Move right");
        moveRightItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        moveRightItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().rotateLeft();
                }
            }
        });
        editMenu.add(moveRightItem);
        JMenuItem changeItem = new JMenuItem("Change symbol");
        changeItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        changeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().change();
                }
            }
        });
        editMenu.add(changeItem);
        JMenuItem pairItem = new JMenuItem("Pair bases");
        pairItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        pairItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().pairBases();
                }
            }
        });
        editMenu.add(pairItem);
        JMenuItem columnItem = new JMenuItem("Pair columns");
        columnItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        columnItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().pairColumns();
                }
            }
        });
        editMenu.add(columnItem);
        JMenuItem gotoItem = new JMenuItem("Go to ..");
        gotoItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        gotoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().jump();
                }
            }
        });
        editMenu.add(gotoItem);
        this.history = new JCheckBoxMenuItem("History", false);
        this.history.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.historyWindow.setVisible(AlignmentFrame.this.history.isSelected());
            }
        });
        editMenu.add(this.history);
        return editMenu;
    }

    public void deleteProject() {
        Object[] projectFiles = this.projectController.getProjectNames();
        boolean exists = false;
        if (projectFiles.length > 0) {
            String project = (String)JOptionPane.showInputDialog(null, "Select a project", "Select", 3, null, projectFiles, projectFiles[0]);
            if (project != null) {
                Enumeration e = this.projects.keys();
                while (e.hasMoreElements()) {
                    if (!project.equals((String)e.nextElement())) continue;
                    exists = true;
                }
                if (exists) {
                    JOptionPane.showMessageDialog(this, "You cannot delete an open project");
                } else {
                    this.deleteProject(project);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "No projects");
        }
    }

    public void deleteProject(String name) {
        boolean fileDeleted = false;
        boolean dirDeleted = false;
        if (JOptionPane.showConfirmDialog(this, "Delete project " + name + "?") == 0) {
            ProjectProperties prop = this.projectController.getProjectProperties(name);
            File file = new File(AlignmentProperties.getProjectDir() + "/" + name + ".prj");
            fileDeleted = file.delete();
            file = new File(prop.getPath() + "/" + this.history);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                }
                dirDeleted = file.delete();
            }
        }
        if (fileDeleted && dirDeleted) {
            JOptionPane.showMessageDialog(this, "Project " + name + " deleted");
        }
    }

    public void saveProject() {
        if (this.getActiveProjectContainer() != null) {
            this.setCursor(new Cursor(3));
            this.getActiveProjectContainer().save();
            this.setCursor(new Cursor(0));
        }
    }

    public JMenu getViewMenu() {
        JMenu view = new JMenu("View");
        view.add(this.getColorMenu());
        JMenu selectionMode = new JMenu("Selection mode");
        ButtonGroup selModes = new ButtonGroup();
        JRadioButtonMenuItem primarySel = new JRadioButtonMenuItem("Primary selection");
        primarySel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentFrame.this.setSelectionMode(true);
                AlignmentFrame.this.selectionMode(true);
                AlignmentFrame.this.setOperationMode(1);
                AlignmentFrame.this.operationMode(1);
                AlignmentFrame.this.primaryOp.setSelected(true);
            }
        });
        selectionMode.add(primarySel);
        selModes.add(primarySel);
        this.bothSel = new JRadioButtonMenuItem("Both");
        this.bothSel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentFrame.this.setSelectionMode(false);
                AlignmentFrame.this.selectionMode(false);
            }
        });
        this.bothSel.setSelected(true);
        selectionMode.add(this.bothSel);
        selModes.add(this.bothSel);
        ButtonGroup opModes = new ButtonGroup();
        this.primaryOp = new JRadioButtonMenuItem("Primary selection");
        this.primaryOp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentFrame.this.setOperationMode(1);
                AlignmentFrame.this.operationMode(1);
            }
        });
        opModes.add(this.primaryOp);
        JRadioButtonMenuItem bothOp = new JRadioButtonMenuItem("Both");
        bothOp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentFrame.this.setOperationMode(0);
                AlignmentFrame.this.operationMode(0);
                AlignmentFrame.this.setSelectionMode(false);
                AlignmentFrame.this.selectionMode(false);
                AlignmentFrame.this.bothSel.setSelected(true);
            }
        });
        bothOp.setSelected(true);
        opModes.add(bothOp);
        JRadioButtonMenuItem secondaryOp = new JRadioButtonMenuItem("Secondary selection");
        secondaryOp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignmentFrame.this.setOperationMode(2);
                AlignmentFrame.this.operationMode(2);
                AlignmentFrame.this.setSelectionMode(false);
                AlignmentFrame.this.selectionMode(false);
                AlignmentFrame.this.bothSel.setSelected(true);
            }
        });
        opModes.add(secondaryOp);
        JMenu splitModes = new JMenu("Split mode");
        ButtonGroup modes = new ButtonGroup();
        JRadioButtonMenuItem horizontalMode = new JRadioButtonMenuItem("Horizontal split");
        horizontalMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.splitMode(true);
            }
        });
        splitModes.add(horizontalMode);
        modes.add(horizontalMode);
        JRadioButtonMenuItem verticalMode = new JRadioButtonMenuItem("Vertical split");
        verticalMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.splitMode(false);
            }
        });
        splitModes.add(verticalMode);
        modes.add(verticalMode);
        verticalMode.setSelected(true);
        this.splitAlign = false;
        view.add(splitModes);
        JMenuItem split = new JMenuItem("Split screen");
        split.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        split.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().getControlPanel().enableSplitButtons(true);
                    AlignmentFrame.this.getActiveProjectContainer().split();
                }
            }
        });
        view.add(split);
        JMenuItem unsplit = new JMenuItem("Unsplit screen");
        unsplit.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        unsplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().getControlPanel().enableSplitButtons(false);
                    AlignmentFrame.this.getActiveProjectContainer().unsplit();
                }
            }
        });
        view.add(unsplit);
        view.add(this.getFontMenu());
        view.add(this.getFontSizeMenu());
        JMenuItem sub = new JMenuItem("New view");
        sub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().subalignment();
                }
            }
        });
        JMenuItem clear = new JMenuItem("Clear selection(s)");
        clear.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().clear();
                }
            }
        });
        view.add(clear);
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem("Fixed scrolling", true);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.setTraceEnabled(((JCheckBoxMenuItem)ae.getSource()).isSelected());
            }
        });
        view.add(cb);
        JCheckBoxMenuItem bcItem = new JCheckBoxMenuItem("Base coloring", false);
        bcItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.setBasecoloringEnabled(((JCheckBoxMenuItem)ae.getSource()).isSelected());
                AlignmentFrame.this.repaint();
            }
        });
        view.add(bcItem);
        this.overview = new JCheckBoxMenuItem("Overview", false);
        this.overview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.setOverviewVisible(AlignmentFrame.this.overview.isSelected());
            }
        });
        view.add(this.overview);
        return view;
    }

    public void setOperationMode(int mode) {
        this.operationMode = mode;
    }

    public void setSelectionMode(boolean mode) {
        this.selectionMode = mode;
    }

    public JMenu getToolsMenu() {
        JMenu tools = new JMenu("Tools");
        JMenuItem runItem = new JMenuItem("Programs");
        runItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        runItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    Runnable r = new Runnable(){

                        public void run() {
                            AlignmentFrame.this.analyze();
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
            }
        });
        tools.add(runItem);
        JMenuItem addSeqs = new JMenuItem("Add sequences");
        addSeqs.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        addSeqs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().addSequences();
                }
            }
        });
        tools.add(addSeqs);
        JMenuItem delSeqs = new JMenuItem("Delete sequences");
        delSeqs.setAccelerator(KeyStroke.getKeyStroke(68, 3));
        delSeqs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().removeSequences();
                }
            }
        });
        tools.add(delSeqs);
        JMenuItem addCol = new JMenuItem("Add column");
        addCol.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        addCol.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().addColumn();
                }
            }
        });
        tools.add(addCol);
        JMenuItem removeCol = new JMenuItem("Remove column");
        removeCol.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        removeCol.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().removeColumn();
                }
            }
        });
        tools.add(removeCol);
        JMenuItem removeColors = new JMenuItem("Remove coloring");
        removeColors.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        removeColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().removeColors();
                }
            }
        });
        tools.add(removeColors);
        JMenuItem removeItem = new JMenuItem("Remove gaps");
        removeItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().removeGaps();
                }
            }
        });
        tools.add(removeItem);
        JMenuItem emptyPair = new JMenuItem("Empty pairingmask");
        emptyPair.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (JOptionPane.showConfirmDialog(AlignmentFrame.this.getActiveProjectContainer(), "Do you want to empty the pairingmask?", "Please confirm", 0) == 0) {
                    AlignmentFrame.this.getActiveProjectContainer().emptyPairingmask();
                }
            }
        });
        tools.add(emptyPair);
        JMenuItem ulItem = new JMenuItem("Fit alignment to pairingmask");
        ulItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.getActiveProjectContainer().fitCases();
            }
        });
        tools.add(ulItem);
        return tools;
    }

    public JMenu getHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        JMenuItem docItem = new JMenuItem("Documentation");
        docItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        docItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.showDocumentation();
            }
        });
        helpMenu.add(docItem);
        return helpMenu;
    }

    public void showDocumentation() {
        JFrame helpWindow = new JFrame("Documentation");
        JEditorPane text = new JEditorPane();
        text.setEditable(false);
        try {
            text.read(new BufferedReader(new FileReader(AlignmentProperties.getHomeDir() + "/README")), null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(helpWindow, "An error occurred reading the documentation");
        }
        JScrollPane docScroll = new JScrollPane(text, 20, 30);
        helpWindow.getContentPane().add(docScroll);
        helpWindow.setSize(600, 500);
        helpWindow.setVisible(true);
    }

    public void showTutorial() {
        JFrame helpWindow = new JFrame("Tutorial");
        JEditorPane text = new JEditorPane();
        text.setEditable(false);
        try {
            text.read(new BufferedReader(new FileReader(AlignmentProperties.getHomeDir() + "/documentaion/tutorial.txt")), null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(helpWindow, "An error occurred reading the tutorial");
        }
        JScrollPane docScroll = new JScrollPane(text, 20, 30);
        helpWindow.getContentPane().add(docScroll);
        helpWindow.setSize(600, 500);
        helpWindow.setVisible(true);
    }

    public JMenu getFileMenu() {
        this.fileMenu = new JMenu("File");
        JMenuItem newItem = new JMenuItem("New");
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Runnable r = new Runnable(){

                    public void run() {
                        AlignmentFrame.this.newProject();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        });
        this.fileMenu.add(newItem);
        JMenuItem openItem = new JMenuItem("Open project");
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Runnable r = new Runnable(){

                    public void run() {
                        AlignmentFrame.this.openProject();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        });
        this.fileMenu.add(openItem);
        JMenuItem saveItem = new JMenuItem("Save project");
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.saveProject();
                }
            }
        });
        this.fileMenu.add(saveItem);
        JMenuItem export = new JMenuItem("Export file");
        export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().export();
                }
            }
        });
        this.fileMenu.add(export);
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().save();
                    AlignmentFrame.this.close();
                }
            }
        });
        this.fileMenu.add(closeItem);
        JMenuItem deleteItem = new JMenuItem("Delete project");
        deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        deleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.deleteProject();
            }
        });
        this.fileMenu.add(deleteItem);
        this.fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AlignmentFrame.this.exit();
            }
        });
        this.fileMenu.add(exitItem);
        return this.fileMenu;
    }

    public JMenu getInfoMenu() {
        JMenu infoMenu = new JMenu("Info");
        JMenu dirMenu = new JMenu("Working directory");
        this.wDir = new JMenuItem(System.getProperty("user.dir"));
        this.wDir.setToolTipText("Click to copy path to clipboard");
        dirMenu.add(this.wDir);
        this.wDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Clipboard clipboard = AlignmentFrame.this.getToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(AlignmentFrame.this.wDir.getText()), thisFrame);
            }
        });
        infoMenu.add(dirMenu);
        JMenuItem release = new JMenuItem("Version: " + this.version);
        infoMenu.add(release);
        JMenuItem date = new JMenuItem(this.releaseDate);
        infoMenu.add("Released:");
        infoMenu.add(date);
        return infoMenu;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected String getAlignmentName() {
        return JOptionPane.showInputDialog("Write a name for the alignment");
    }

    public void exit() {
        boolean analyzing = false;
        while (this.visibleComponent != null) {
            this.close();
        }
        if (sarseThreads.activeCount() > 0) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public void removeProjectName() {
        MenuElement[] popupElement = this.fileMenu.getSubElements();
        for (int i = 0; i < popupElement.length; ++i) {
            MenuElement[] menuItemElements = popupElement[i].getSubElements();
            for (int j = 0; j < menuItemElements.length; ++j) {
                if (!(menuItemElements[j] instanceof JMenuItem) || !((JMenuItem)menuItemElements[j]).getText().equals(this.visibleComponent)) continue;
                this.fileMenu.remove((JMenuItem)menuItemElements[j]);
            }
        }
    }

    public void close() {
        if (this.getActiveProjectContainer().isAnalyzing()) {
            this.analyzing = true;
        }
        this.historyWindow.remove(this.tabs.getComponentAt(this.tabs.getSelectedIndex()));
        this.overviewWindow.remove(this.tabs.getComponentAt(this.tabs.getSelectedIndex()));
        this.saveSplitMode();
        this.getActiveProjectContainer().cleanup();
        this.tabs.remove(this.getActiveProjectContainer());
        this.getContentPane().remove(this.getProjectContainer(this.visibleComponent));
        this.removeProjectName();
        this.projects.remove(this.visibleComponent);
        Enumeration e = this.projects.keys();
        if (e.hasMoreElements()) {
            String newProject;
            this.visibleComponent = newProject = (String)e.nextElement();
            this.wDir.setText(this.projectController.getProjectProperties(newProject).getPath());
        } else {
            this.visibleComponent = null;
            this.wDir.setText("No working directory");
        }
        System.gc();
        if (this.currentProject() != null) {
            this.showHistory(this.currentProject());
            this.showOverview(this.currentProject());
        } else {
            this.showHistory("default");
            this.showOverview("default");
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public AlignmentContainer getProjectContainer(String name) {
        return (AlignmentContainer)this.projects.get(name);
    }

    public AlignmentContainer getActiveProjectContainer() {
        if (this.visibleComponent != null && this.tabs.getSelectedIndex() > -1) {
            AlignmentContainer ac = (AlignmentContainer)this.tabs.getComponentAt(this.tabs.getSelectedIndex());
            if (ac == null) {
                JOptionPane.showMessageDialog(null, "You must start a project first!");
            }
            return ac;
        }
        return null;
    }

    public static void main(String[] args) {
        SARSE_HOME = System.getProperty("SARSE_HOME");
        if (SARSE_HOME == null) {
            System.out.println("You must set the $SARSE_HOME variable before running the application!");
            System.exit(1);
        }
        AlignmentProperties.setHomeDir(SARSE_HOME);
        AlignmentProperties.setProjectDir(System.getProperty("user.home") + "/.sarse/");
        try {
            new AlignmentFrame("SARSE - Semi-Automated RNA Sequence Editor", args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addProject(AlignmentContainer container, String name) {
        this.tabs.add((Component)container, name);
        this.projects.put(name, container);
        this.visibleComponent = name;
        this.historyCards.add((Component)container.getHistoryPanel(), name);
        this.overviewCards.add((Component)container.getOverviewPanel(this.overviewWindow), name);
        this.showHistory(this.currentProject());
        this.showOverview(this.currentProject());
    }

    public void properties() {
    }

    public void analyze() {
        AlignmentContainer ac = this.getActiveProjectContainer();
        ac.save();
        ac.analyze();
    }

    public void setTraceEnabled(boolean trace) {
        this.getActiveProjectContainer().setTraceEnabled(trace);
    }

    public void openProject() {
        Object[] names = this.projectController.getProjectNames();
        if (names.length > 0) {
            String project = (String)JOptionPane.showInputDialog(null, "Select a project", "Select", 3, null, names, names[0]);
            if (project != null) {
                this.openProject(project);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No projects");
        }
    }

    public void saveSplitMode() {
        AlignmentPanel ap = this.getActiveProjectContainer().getSelectedProject();
        this.splitMode = ap.isSplit();
        if (this.splitMode) {
            this.divider = ap.getSplitPane().getDividerLocation();
            this.p2 = ap.getTableView2().getViewport().getViewPosition();
            this.p3 = ap.getTableView3().getViewport().getViewPosition();
            this.splitAlign = ap.horizontalSplit();
        } else {
            this.p1 = ap.getTableView().getViewport().getViewPosition();
        }
    }

    public void openProject(String name) {
        Cursor orig = this.getCursor();
        if (this.projects.get(name) != null) {
            JOptionPane.showMessageDialog(null, "\nProject already open!");
            return;
        }
        try {
            this.setCursor(new Cursor(3));
            ProjectProperties prop = this.projectController.getProjectProperties(name);
            String file = prop.getPath() + "/" + prop.getFile();
            AlignmentContainer newPrj = new AlignmentContainer(this, new File(file), name, this.selectionMode, this.operationMode, this.splitMode, this.splitAlign, this.p1, this.p2, this.p3, this.divider, prop.getPath(), this.properties);
            this.addProject(newPrj, name);
            newPrj.setHistoryEnabled(this.history.getState());
            newPrj.setOverviewEnabled(this.overview.getState());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + "\nOpen Project failed!");
            if (this.projects.get(name) != null) {
                this.projects.remove(name);
            }
            if (this.tabs.indexOfTab(name) != -1) {
                this.tabs.remove(this.tabs.indexOfTab(name));
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + "\nOpen Project failed!");
            if (this.projects.get(name) != null) {
                this.projects.remove(name);
            }
            if (this.tabs.indexOfTab(name) != -1) {
                this.tabs.remove(this.tabs.indexOfTab(name));
            }
            e.printStackTrace();
        }
        this.setCursor(orig);
    }

    public boolean isHistoryEnabled() {
        return this.history.getState();
    }

    public boolean isOverviewEnabled() {
        return this.overview.getState();
    }

    public void newProject() {
        int chooserStatus = this.fileChooser.showOpenDialog(null);
        if (chooserStatus == 0) {
            this.newProjectFile = this.fileChooser.getSelectedFile();
            this.projectname();
        }
    }

    private void projectname() {
        this.newProjectInputFrame = new JFrame("Projectname");
        Calendar rightNow = Calendar.getInstance();
        String date = rightNow.get(1) + "-" + (rightNow.get(2) + 1) + "-" + rightNow.get(5);
        this.newProjectInputFields = new DependingTextFields("Write a name for your project", "Project name: ", "Working Directory: ", this.newProjectFile.getName().substring(0, this.newProjectFile.getName().lastIndexOf(".")), this.cwd + "/" + this.newProjectFile.getName().substring(0, this.newProjectFile.getName().lastIndexOf(".")), this);
        this.newProjectInputFields.getField1().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AlignmentFrame.this.checkInput();
                }
            }
        });
        this.newProjectInputFrame.getContentPane().add(this.newProjectInputFields);
        this.newProjectInputFrame.pack();
        this.newProjectInputFrame.setVisible(true);
    }

    public void checkInput() {
        this.checkInput(this.newProjectInputFields.getValue1());
    }

    public void checkInput(String newName) {
        if (newName != null && !newName.equals("")) {
            boolean projectExists = this.projectExists(newName);
            if (!projectExists) {
                this.createNewProject();
            } else {
                int confirm = JOptionPane.showConfirmDialog(null, "The project already exists. Continue anyway?");
                if (confirm == 0) {
                    this.deleteProject(newName);
                    this.createNewProject();
                } else {
                    this.newProjectInputFrame.setTitle("Please specify new name");
                    this.newProjectInputFields.getField1().requestFocus();
                }
            }
        } else {
            this.newProjectInputFrame.setTitle("You need to specify a project name");
            this.newProjectInputFields.getField1().requestFocus();
        }
    }

    protected boolean projectExists(String newName) {
        String[] projectNames = this.projectController.getProjectNames();
        boolean projectExists = false;
        for (int i = 0; i < projectNames.length; ++i) {
            if (!projectNames[i].equals(newName)) continue;
            projectExists = true;
        }
        return projectExists;
    }

    public void newProject(String filePath) {
        this.newProjectFile = new File(filePath);
        this.newProjectInputFrame = new JFrame("Projectname");
        int start = Math.max(0, filePath.lastIndexOf(47) + 1);
        this.newProjectInputFields = new DependingTextFields("Change the projectname and the working directory if you are not satisfied.", "Project name: ", "Working Directory: ", filePath.substring(start, filePath.lastIndexOf(".")), this.cwd + "/" + filePath.substring(start, filePath.lastIndexOf(".")), this);
        this.newProjectInputFields.getField1().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AlignmentFrame.this.createNewProject();
                }
            }
        });
        this.newProjectInputFrame.getContentPane().add(this.newProjectInputFields);
        this.newProjectInputFrame.pack();
        this.newProjectInputFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("OK")) {
            this.checkInput();
        } else if (ae.getActionCommand().equals("Browse")) {
            this.changeDirectory();
        } else {
            this.newProjectInputFields.removeActionListener(this);
            this.newProjectInputFrame.dispose();
        }
    }

    public void changeDirectory() {
        JFileChooser jfc = new JFileChooser(AlignmentProperties.getProjectDir() + this.newProjectInputFields.getValue1());
        jfc.setFileSelectionMode(1);
        int chosen = jfc.showDialog(null, "Select");
        if (chosen == 0) {
            this.newProjectInputFields.setDir(jfc.getSelectedFile().getAbsolutePath() + "/" + this.newProjectInputFields.getValue1());
        }
    }

    public void createNewProject() {
        String projectName = this.newProjectInputFields.getValue1();
        String projectDirectory = this.newProjectInputFields.getValue2();
        this.createProject(projectName, projectDirectory);
    }

    private void createProject(String projectName, String projectDirectory) {
        String lastPath = projectDirectory;
        this.properties.setLastPath(lastPath);
        File pDir = new File(projectDirectory);
        try {
            if (!pDir.exists()) {
                pDir.mkdirs();
            }
            if (this.newProjectFile.exists()) {
                File projectFile = new File(projectDirectory + "/" + this.newProjectFile.getName() + "/");
                StringTools.copyFile(this.newProjectFile.getAbsolutePath(), projectFile.getAbsolutePath(), false);
                if (this.newProjectInputFrame != null) {
                    this.newProjectInputFields.removeActionListener(this);
                    this.newProjectInputFrame.dispose();
                }
                try {
                    AlignmentContainer ac = new AlignmentContainer(this, projectFile, projectName, this.selectionMode, this.operationMode, false, true, null, null, null, 0, pDir.getAbsolutePath(), this.properties);
                    ac.setProjectDir(projectDirectory);
                    this.addProject(ac, projectName);
                    this.projectController.addProject(projectName, projectFile.getName(), projectDirectory);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getMessage() + "\nAlignmentFrame.createNewProject()");
                }
            } else {
                if (this.newProjectInputFrame != null) {
                    this.newProjectInputFields.removeActionListener(this);
                    this.newProjectInputFrame.dispose();
                }
                JOptionPane.showMessageDialog(null, "The file containing your alignment doesn't exist.");
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
            JOptionPane.showMessageDialog(null, "Couldn't create project: Sourcefile not readable");
        }
        this.wDir.setText(projectDirectory);
    }

    public void windowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                AlignmentFrame.this.exit();
            }
        });
    }

    public void setBasecoloringEnabled(boolean enabled) {
        this.getActiveProjectContainer().setBasecoloringEnabled(enabled);
    }

    public void splitMode(boolean mode) {
        this.getActiveProjectContainer().splitMode(mode);
    }

    public void selectionMode(boolean mode) {
        Collection c = this.projects.values();
        AlignmentContainer[] containers = c.toArray(new AlignmentContainer[c.size()]);
        for (int i = 0; i < containers.length; ++i) {
            containers[i].selectionMode(mode);
        }
    }

    public void operationMode(int mode) {
        Collection c = this.projects.values();
        AlignmentContainer[] containers = c.toArray(new AlignmentContainer[c.size()]);
        for (int i = 0; i < containers.length; ++i) {
            containers[i].operationMode(mode);
        }
    }

    public JMenuItem getFontMenu() {
        JMenuItem fontMenu = new JMenuItem("Fonttype");
        fontMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    Font[] fonts = new Font[3];
                    Object[] fontNames = new String[3];
                    try {
                        StringBuffer stringBuffer = new StringBuffer();
                        AlignmentFrame.this.getActiveProjectContainer().getProperties();
                        fonts[0] = Font.createFont(0, new FileInputStream(new File(stringBuffer.append(AlignmentProperties.getHomeDir()).append("/fonts/georgia.ttf").toString())));
                        StringBuffer stringBuffer2 = new StringBuffer();
                        AlignmentFrame.this.getActiveProjectContainer().getProperties();
                        fonts[1] = Font.createFont(0, new FileInputStream(new File(stringBuffer2.append(AlignmentProperties.getHomeDir()).append("/fonts/arial.ttf").toString())));
                        StringBuffer stringBuffer3 = new StringBuffer();
                        AlignmentFrame.this.getActiveProjectContainer().getProperties();
                        fonts[2] = Font.createFont(0, new FileInputStream(new File(stringBuffer3.append(AlignmentProperties.getHomeDir()).append("/fonts/verdana.ttf").toString())));
                    }
                    catch (Exception e) {
                        System.out.println("error creating font: " + e);
                        e.printStackTrace();
                    }
                    for (int i = 0; i < fonts.length; ++i) {
                        fontNames[i] = fonts[i].getName();
                    }
                    String newFont = (String)JOptionPane.showInputDialog(null, "Select font:", "Font", -1, null, fontNames, AlignmentFrame.this.getActiveProjectContainer().getProperties().getTableFont().getName());
                    if (newFont != null) {
                        AlignmentFrame.this.getActiveProjectContainer().getProperties().setFontName(newFont);
                        AlignmentFrame.this.getActiveProjectContainer().updateCellSize();
                        AlignmentFrame.this.validate();
                        AlignmentFrame.this.repaint();
                    }
                }
            }
        });
        return fontMenu;
    }

    public JMenuItem getFontSizeMenu() {
        JMenuItem fontSizeMenu = new JMenuItem("Fontsize");
        fontSizeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Object[] sizes;
                String newSize;
                if (AlignmentFrame.this.getActiveProjectContainer() != null && (newSize = (String)JOptionPane.showInputDialog(null, "Select fontsize:", "Size", -1, null, sizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16"}, AlignmentFrame.this.getActiveProjectContainer().getProperties().getTableFont().getSize() + "")) != null) {
                    AlignmentFrame.this.getActiveProjectContainer().getProperties().setFontSize(Integer.parseInt(newSize));
                    AlignmentFrame.this.getActiveProjectContainer().updateCellSize();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        return fontSizeMenu;
    }

    public JMenu getColorMenu() {
        JMenu colors = new JMenu("Colors");
        JMenuItem bg = new JMenuItem("Background color");
        bg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setBackground();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(bg);
        JMenuItem sColor = new JMenuItem("Sequence name color");
        sColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setSequenceColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(sColor);
        JMenuItem txt = new JMenuItem("Text color");
        txt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setTextColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(txt);
        JMenuItem primary = new JMenuItem("Primary selection color");
        primary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setPrimarySelectionColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(primary);
        JMenuItem secondary = new JMenuItem("Secondary selection color");
        secondary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setSecondarySelectionColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(secondary);
        JMenuItem c = new JMenuItem("C color");
        c.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setCColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(c);
        JMenuItem g = new JMenuItem("G color");
        g.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setGColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(g);
        JMenuItem a = new JMenuItem("A color");
        a.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setAColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(a);
        JMenuItem u = new JMenuItem("U color");
        u.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AlignmentFrame.this.getActiveProjectContainer() != null) {
                    AlignmentFrame.this.getActiveProjectContainer().setUColor();
                    AlignmentFrame.this.validate();
                    AlignmentFrame.this.repaint();
                }
            }
        });
        colors.add(u);
        return colors;
    }

    public void componentHidden(ComponentEvent ce) {
        this.history.setSelected(false);
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
    }

    public void setWdir(String path) {
        if (this.currentProject() != null) {
            try {
                this.wDir.setText(this.projectController.getProjectProperties(this.currentProject()).getPath());
                System.setProperty("user.dir", this.projectController.getProjectProperties(this.currentProject()).getPath());
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String currentProject() {
        if (this.tabs.getSelectedIndex() > -1) {
            return this.tabs.getTitleAt(this.tabs.getSelectedIndex());
        }
        return null;
    }

    protected void createHistoryWindow() {
        this.historyWindow = new JFrame("History");
        this.historyWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AlignmentFrame.this.history.setSelected(false);
            }
        });
        this.historyWindow.setLocation(50, 50);
        this.historyWindow.getContentPane().setLayout(new BorderLayout());
        this.historyCards = new JPanel(new CardLayout());
        this.historyWindow.add(this.historyCards);
        this.historyCards.add((Component)new JPanel(), "default");
        this.historyWindow.setSize(300, 200);
        this.historyWindow.setDefaultCloseOperation(1);
    }

    private void createOverviewWindow() {
        this.overviewWindow = new JFrame("Overview");
        this.overviewWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AlignmentFrame.this.overview.setSelected(false);
            }
        });
        this.overviewWindow.setLocation(0, 0);
        this.overviewWindow.getContentPane().setLayout(new BorderLayout());
        this.overviewCards = new JPanel(new CardLayout());
        this.overviewWindow.add(this.overviewCards);
        this.overviewCards.add((Component)new JPanel(), "default");
        this.overviewWindow.setSize(300, 200);
        this.overviewWindow.setDefaultCloseOperation(1);
    }

    public void setHistoryVisible(boolean visible) {
        this.historyWindow.setVisible(visible);
        if (visible) {
            this.showHistory(this.currentProject());
        }
    }

    public void setOverviewVisible(boolean visible) {
        this.overviewWindow.setVisible(visible);
        if (visible) {
            this.showOverview(this.currentProject());
        }
    }
}

