/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import org.biojava.bio.program.sax.blastxml.StAXFeatureHandler;
import org.biojava.bio.program.sax.blastxml.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class HspHandler
extends StAXFeatureHandler {
    public static final StAXHandlerFactory HSP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new HspHandler(staxenv);
        }
    };
    private static final String bitScore = "bitScore";
    private static final String score = "score";
    private static final String expectValue = "expectValue";
    private static final String numberOfIdentities = "numberOfIdentities";
    private static final String numberOfPositives = "numberOfPositives";
    private static final String alignmentSize = "alignmentSize";
    private static final String queryFrame = "queryFrame";
    private static final String hitFrame = "hitFrame";
    private static final String queryStrand = "queryStrand";
    private static final String hitStrand = "hitStrand";
    private static final String percentageIdentity = "percentageIdentity";
    AttributesImpl hspAttrs;
    AttributesImpl alignAttrs;
    int iNumberOfIdentities = Integer.MIN_VALUE;
    int iAlignmentSize = Integer.MIN_VALUE;
    String sHsp_qseq = null;
    String sHsp_hseq = null;
    String sHsp_midline = null;
    String sHsp_hit_from = null;
    String sHsp_hit_to = null;
    String sHsp_query_from = null;
    String sHsp_query_to = null;

    public HspHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_bit-score"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.bitScore, HspHandler.bitScore, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_score"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.score, HspHandler.score, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_evalue"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.expectValue, HspHandler.expectValue, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-from"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_query_from = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-to"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_query_to = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-from"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_hit_from = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-to"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_hit_to = s.trim();
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-frame"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) throws SAXException {
                        int frameNo = Integer.parseInt(s.trim());
                        if (StAXFeatureHandler.hitSequenceType.equals("protein")) {
                            (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.queryFrame, HspHandler.queryFrame, "CDATA", HspHandler.this.stringifyFrame(frameNo));
                        } else if (StAXFeatureHandler.hitSequenceType.equals("dna")) {
                            (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.hitStrand, HspHandler.hitStrand, "CDATA", HspHandler.this.stringifyStrand(frameNo));
                        } else {
                            throw new SAXException("illegal sequence type");
                        }
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-frame"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) throws SAXException {
                        int frameNo = Integer.parseInt(s.trim());
                        if (StAXFeatureHandler.hitSequenceType.equals("protein")) {
                            (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.hitFrame, HspHandler.hitFrame, "CDATA", HspHandler.this.stringifyFrame(frameNo));
                        } else if (StAXFeatureHandler.hitSequenceType.equals("dna")) {
                            (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.queryStrand, HspHandler.queryStrand, "CDATA", HspHandler.this.stringifyStrand(frameNo));
                        } else {
                            throw new SAXException("illegal sequence type");
                        }
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_identity"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.iNumberOfIdentities = Integer.parseInt(s.trim());
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.numberOfIdentities, HspHandler.numberOfIdentities, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_positive"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.numberOfPositives, HspHandler.numberOfPositives, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_align-len"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.iAlignmentSize = Integer.parseInt(s.trim());
                        (this).HspHandler.this.hspAttrs.addAttribute("http://www.biojava.org", HspHandler.alignmentSize, HspHandler.alignmentSize, "CDATA", s);
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_qseq"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_qseq = s;
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hseq"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_hseq = s;
                    }
                };
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_midline"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(){

                    public void setStringValue(String s) {
                        (this).HspHandler.this.sHsp_midline = s;
                    }
                };
            }
        });
    }

    private String stringifyFrame(int frame) throws SAXException {
        switch (frame) {
            case -3: {
                return "minus3";
            }
            case -2: {
                return "minus2";
            }
            case -1: {
                return "minus1";
            }
            case 1: {
                return "plus1";
            }
            case 2: {
                return "plus2";
            }
            case 3: {
                return "plus3";
            }
        }
        throw new SAXException("illegal frame number encountered.");
    }

    private String stringifyStrand(int strand) throws SAXException {
        if (strand > 0) {
            return "plus";
        }
        if (strand < 0) {
            return "minus";
        }
        throw new SAXException("illegal strand number encountered.");
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.hspAttrs = new AttributesImpl();
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (this.iNumberOfIdentities == Integer.MIN_VALUE || this.iAlignmentSize == Integer.MIN_VALUE || this.sHsp_qseq == null || this.sHsp_hseq == null || this.sHsp_midline == null || this.sHsp_hit_from == null || this.sHsp_hit_to == null || this.sHsp_query_from == null || this.sHsp_query_to == null) {
            throw new SAXException("<Hsp> is non-compliant.");
        }
        this.hspAttrs.addAttribute("http://www.biojava.org", percentageIdentity, percentageIdentity, "CDATA", Float.toString((float)(100 * this.iNumberOfIdentities) / (float)this.iAlignmentSize));
        this.staxenv.listener.startElement("http://www.biojava.org", "HSP", "http://www.biojava.org:HSP", new AttributesImpl());
        this.staxenv.listener.startElement("http://www.biojava.org", "HSPSummary", "http://www.biojava.org:HSPSummary", this.hspAttrs);
        this.staxenv.listener.endElement("http://www.biojava.org", "HSPSummary", "http://www.biojava.org:HSPSummary");
        this.staxenv.listener.startElement("http://www.biojava.org", "BlastLikeAlignment", "http://www.biojava.org:BlastLikeAlignment", new AttributesImpl());
        AttributesImpl queryAttrs = new AttributesImpl();
        queryAttrs.addAttribute("http://www.biojava.org", "startPosition", "startPosition", "CDATA", this.sHsp_query_from);
        queryAttrs.addAttribute("http://www.biojava.org", "stopPosition", "stopPosition", "CDATA", this.sHsp_query_to);
        this.staxenv.listener.startElement("http://www.biojava.org", "QuerySequence", "http://www.biojava.org:QuerySequence", queryAttrs);
        this.staxenv.listener.characters(this.sHsp_qseq.toCharArray(), 0, this.sHsp_qseq.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "QuerySequence", "http://www.biojava.org:QuerySequence");
        AttributesImpl matchAttrs = new AttributesImpl();
        matchAttrs.addAttribute("xml", "space", "xml:space", "CDATA", "preserve");
        this.staxenv.listener.startElement("http://www.biojava.org", "MatchConsensus", "http://www.biojava.org:MatchConsensus", matchAttrs);
        this.staxenv.listener.characters(this.sHsp_midline.toCharArray(), 0, this.sHsp_midline.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "MatchConsensus", "http://www.biojava.org:MatchConsensus");
        AttributesImpl hitAttrs = new AttributesImpl();
        hitAttrs.addAttribute("http://www.biojava.org", "startPosition", "startPosition", "CDATA", this.sHsp_hit_from);
        hitAttrs.addAttribute("http://www.biojava.org", "stopPosition", "stopPosition", "CDATA", this.sHsp_hit_to);
        this.staxenv.listener.startElement("http://www.biojava.org", "HitSequence", "HitSequence", hitAttrs);
        this.staxenv.listener.characters(this.sHsp_hseq.toCharArray(), 0, this.sHsp_hseq.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "HitSequence", "http://www.biojava.org:HitSequence");
        this.staxenv.listener.endElement("http://www.biojava.org", "BlastLikeAlignment", "http://www.biojava.org:BlastLikeAlignment");
        this.staxenv.listener.endElement("http://www.biojava.org", "HSP", "http://www.biojava.org:HSP");
    }
}

