/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.controller;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.ColReader;
import dk.kvl.alignmenttools.io.ColWriter;
import dk.kvl.alignmenttools.io.FastaReader;
import dk.kvl.alignmenttools.io.FastaWriter;
import dk.kvl.alignmenttools.io.WideFileReader;
import dk.kvl.alignmenttools.io.WideFileWriter;
import dk.kvl.gui.properties.ProjectProperties;
import dk.kvl.tools.FileHistory;
import dk.kvl.tools.io.ColFilter;
import dk.kvl.tools.io.FastaFilter;
import dk.kvl.tools.io.TxtFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class AlignmentIOController {
    private static boolean error;

    public static void saveAlignment(Alignment alignment, File outFile, int outFormat) throws IOException {
        if (outFormat == 0) {
            new ColWriter(outFile, alignment);
        } else if (outFormat == 1) {
            new WideFileWriter(alignment, outFile);
        } else if (outFormat == 2) {
            new FastaWriter(alignment, outFile);
        } else {
            throw new IOException("Unknown file format!");
        }
    }

    public static Alignment loadAlignment(File inFile, int inFormat) throws IOException {
        BufferedReader ar = null;
        if (inFormat == 0) {
            ar = new ColReader(inFile);
        } else if (inFormat == 1) {
            ar = new WideFileReader(WideFileReader.getFileReader(inFile));
        } else if (inFormat == 2) {
            ar = new FastaReader(inFile);
        } else {
            throw new IOException("Unknown file format!");
        }
        if (ar != null) {
            return ar.getAlignment();
        }
        return null;
    }

    public static void export(Alignment alignment, ProjectProperties prop) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new TxtFilter());
        chooser.addChoosableFileFilter(new ColFilter());
        chooser.addChoosableFileFilter(new FastaFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        int choice = chooser.showSaveDialog(null);
        if (choice == 0) {
            FileFilter ff = chooser.getFileFilter();
            File f = chooser.getSelectedFile();
            if (ff instanceof TxtFilter) {
                if (f.getName().indexOf(46) == -1) {
                    f = new File(f.getAbsolutePath() + ".txt");
                }
                AlignmentIOController.saveTxt(alignment, f);
            } else if (ff instanceof ColFilter) {
                if (f.getName().indexOf(46) == -1) {
                    f = new File(f.getAbsolutePath() + ".col");
                }
                AlignmentIOController.saveCol(alignment, f);
            } else if (ff instanceof FastaFilter) {
                if (f.getName().indexOf(46) == -1) {
                    f = new File(f.getAbsolutePath() + ".fasta");
                }
                AlignmentIOController.saveFasta(alignment, f);
            }
        }
    }

    protected static void saveFasta(Alignment alignment, File f) {
        try {
            if (f.exists()) {
                f.delete();
            }
            new FastaWriter(alignment, f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void setError(boolean hasError) {
        error = hasError;
    }

    public static void saveTxt(Alignment alignment, File file) {
        try {
            new WideFileWriter(alignment, file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void saveCol(Alignment alignment, File file) {
        try {
            new ColWriter(file, alignment);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void saveHistory(FileHistory history, String projectDir) throws IOException {
        File historyFile;
        File hDir = new File(projectDir + "/history");
        if (!hDir.exists()) {
            hDir.mkdirs();
        }
        if (!(historyFile = new File(hDir + "/filehistory")).exists()) {
            historyFile.createNewFile();
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(historyFile));
        oos.writeObject(history);
        oos.close();
    }

    public static FileHistory loadHistory(String projectDir) throws IOException, ClassNotFoundException {
        File historyFile = new File(projectDir + "/history/filehistory");
        if (historyFile.exists()) {
            ObjectInputStream oos = new ObjectInputStream(new FileInputStream(historyFile));
            FileHistory hist = (FileHistory)oos.readObject();
            oos.close();
            return hist;
        }
        return null;
    }
}

