/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment.table;

import dk.kvl.controller.AlignmentController;
import dk.kvl.gui.alignment.table.TitleTable;
import java.awt.Color;
import javax.swing.table.AbstractTableModel;

public class AlignmentDataModel
extends AbstractTableModel {
    private AlignmentController alignmentController = null;
    private String name;
    private TitleTable sequenceNames;

    public AlignmentDataModel(AlignmentController align, String name, TitleTable names) {
        this.sequenceNames = names;
        this.alignmentController = align;
        this.name = name;
    }

    public String getColumnName(int col) {
        return "" + (col + 1);
    }

    public int getRowCount() {
        if (this.alignmentController.getPairingmask() != null) {
            return this.alignmentController.getTotalNumberOfSequences(this.name);
        }
        return this.alignmentController.getNumberOfSequences();
    }

    public int getColumnCount() {
        return this.alignmentController.getAlignmentLength();
    }

    public Object getValueAt(int row, int col) {
        String sequenceName = this.sequenceNames.getSequenceName(row);
        return "" + this.alignmentController.getCharAt(sequenceName, col);
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        String[] names = new String[]{this.getSequenceName(row)};
        char val = ((String)value).charAt(0);
        this.alignmentController.changeSymbols(names, new int[]{col}, val);
    }

    public String getSequenceName(int row) {
        return this.sequenceNames.getSequenceName(row);
    }

    public Color getBackground(int row, int column) {
        return this.alignmentController.getBackground(this.getSequenceName(row), column);
    }

    public Color getForeground(int row, int column) {
        return this.alignmentController.getForeground(this.getSequenceName(row), column);
    }
}

