/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.controller.AlignmentController;
import dk.kvl.gui.alignment.AlignmentContainer;
import dk.kvl.gui.components.HistoryTreeRenderer;
import dk.kvl.gui.event.UpdateEvent;
import dk.kvl.gui.event.UpdateListener;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.FileHistory;
import dk.kvl.tools.History;
import dk.kvl.tools.ReloadListener;
import dk.kvl.tools.history.FileHistoryItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HistoryPanel
extends JPanel
implements TreeSelectionListener,
UpdateListener,
MouseListener {
    private final AlignmentController controller;
    private JTree fileTree;
    private FileHistory history;
    private ReloadListener listener;
    private DefaultMutableTreeNode root;
    private AlignmentContainer container;
    private AlignmentProperties properties;

    public HistoryPanel(AlignmentController controller, AlignmentContainer container, AlignmentProperties properties) {
        super(new BorderLayout());
        this.controller = controller;
        this.container = container;
        this.properties = properties;
        this.createFileTree();
        JScrollPane jsp = new JScrollPane(this.fileTree, 20, 31);
        this.add((Component)jsp, "Center");
    }

    public void createFileTree() {
        this.history = this.controller.getFileHistory();
        this.root = new DefaultMutableTreeNode("Files in project");
        for (int i = 0; i < this.history.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(((FileHistoryItem)this.history.get(i)).getLabel());
            History subHistory = ((FileHistoryItem)this.history.get(i)).getHistory();
            if (subHistory != null) {
                subHistory.addUpdateListener(this);
                for (int j = 0; j < subHistory.size(); ++j) {
                    ArrayList list = (ArrayList)subHistory.get(j);
                    node.add(new DefaultMutableTreeNode((String)list.get(list.size() - 1)));
                }
            }
            this.root.add(node);
        }
        this.fileTree = new JTree(new DefaultTreeModel(this.root));
        this.fileTree.setCellRenderer(new HistoryTreeRenderer(this.controller.getFileName(), this.controller.getHistory(), this.root, this.properties));
        this.fileTree.addTreeSelectionListener(this);
        this.fileTree.addMouseListener(this);
    }

    public void updatePerformed(UpdateEvent e) {
        Enumeration<TreeNode> enumeration = this.root.children();
        int index = -1;
        DefaultMutableTreeNode node = null;
        if (e.getID() == 0) {
            while (enumeration.hasMoreElements()) {
                node = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!node.getUserObject().equals(this.controller.getFileName())) continue;
                ArrayList list = (ArrayList)e.getSource();
                node.add(new DefaultMutableTreeNode((String)list.get(list.size() - 1)));
                break;
            }
            this.fileTree.expandPath(new TreePath(node.getPath()));
            int[] indices = new int[]{node.getIndex(node.getLastChild())};
            ((DefaultTreeModel)this.fileTree.getModel()).nodesWereInserted(node, indices);
        } else if (e.getID() == 1) {
            int[] items = (int[])e.getSource();
            Object[] nodes = new DefaultMutableTreeNode[1];
            while (enumeration.hasMoreElements()) {
                node = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!node.getUserObject().equals(this.controller.getFileName())) continue;
                nodes[0] = (DefaultMutableTreeNode)node.getChildAt(items[0]);
                node.remove(items[0]);
                break;
            }
            this.fileTree.expandPath(new TreePath(node.getPath()));
            ((DefaultTreeModel)this.fileTree.getModel()).nodesWereRemoved(node, items, nodes);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fileTree.getLastSelectedPathComponent();
        if (node != null && node.getLevel() == 1) {
            for (int i = 0; i < this.history.size(); ++i) {
                FileHistoryItem item = (FileHistoryItem)this.history.get(i);
                if (!item.getLabel().equals(node.getUserObject())) continue;
                try {
                    this.container.save();
                    this.controller.changeMainAlignment(item.getFilePath() + "/" + item.getLabel());
                    this.controller.setFileName(item.getLabel());
                    this.controller.setHistory(item.getHistory());
                    this.controller.getHistory().setAlignment(this.controller.getMainAlignment());
                    ((HistoryTreeRenderer)this.fileTree.getCellRenderer()).setFileName(item.getLabel());
                    ((HistoryTreeRenderer)this.fileTree.getCellRenderer()).setHistory(item.getHistory());
                    this.listener.reload();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Could not change file");
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    public void addReloadListener(ReloadListener listener) {
        this.listener = listener;
    }

    public void mouseClicked(MouseEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fileTree.getLastSelectedPathComponent();
        if (node != null && node.getLevel() == 2 && ((DefaultMutableTreeNode)node.getParent()).getUserObject().equals(this.controller.getFileName())) {
            History subHistory = this.controller.getFileHistory().get(this.controller.getFileName()).getHistory();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int newIndex = parent.getIndex(node);
            int oldIndex = subHistory.getPreviousIndex();
            subHistory.setPreviousIndex(newIndex);
            if (newIndex < oldIndex || oldIndex == -1) {
                this.controller.undo(newIndex);
                subHistory.setUndone(true);
            } else if (newIndex > oldIndex) {
                this.controller.redo(newIndex);
                subHistory.setUndone(false);
            } else if (subHistory.getUndone()) {
                this.controller.redo(newIndex);
                subHistory.setUndone(false);
            } else {
                this.controller.undo(newIndex);
                subHistory.setUndone(true);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

