/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.controller.AlignmentController;
import dk.kvl.gui.alignment.AlignmentContainer;
import dk.kvl.sequencetools.PairingMask;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InformationPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private AlignmentController controller = null;
    private JTextArea infoArea = new JTextArea();
    private JTextArea pairingInfo = new JTextArea();
    private JTextArea positionInfo = new JTextArea();
    private JTextArea alignInfo;
    private AlignmentContainer parent;
    private JLabel seqLabel = new JLabel("");

    public InformationPanel(AlignmentContainer parent, AlignmentController aController) {
        super(new BorderLayout());
        this.parent = parent;
        JTabbedPane tp = new JTabbedPane();
        this.controller = aController;
        JPanel selSeq = new JPanel(new BorderLayout());
        this.infoArea.setLineWrap(true);
        this.infoArea.setWrapStyleWord(true);
        selSeq.add("Center", this.infoArea);
        selSeq.add("North", this.seqLabel);
        tp.add(selSeq, "Sequence", 0);
        this.alignInfo = new JTextArea(this.controller.getAlignmentInfo());
        this.alignInfo.setLineWrap(true);
        this.alignInfo.setWrapStyleWord(true);
        tp.add(new JScrollPane(this.alignInfo), "Alignment", 1);
        this.pairingInfo.setEditable(false);
        this.pairingInfo.setLineWrap(true);
        this.pairingInfo.setWrapStyleWord(true);
        tp.add(new JScrollPane(this.pairingInfo), "Pairing", 2);
        this.positionInfo.setEditable(false);
        this.positionInfo.setLineWrap(true);
        this.positionInfo.setWrapStyleWord(true);
        tp.add(new JScrollPane(this.positionInfo), "Position", 3);
        tp.setSelectedIndex(1);
        this.add("Center", tp);
        this.createSavePanel();
    }

    public void actionPerformed(ActionEvent ae) {
        this.infoArea.setText(this.controller.getSequenceInfo(ae.getActionCommand()));
        this.setSelectedSequence(ae.getActionCommand());
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            int min;
            int max;
            if (((DefaultListSelectionModel)lse.getSource()).getMaxSelectionIndex() > ((DefaultListSelectionModel)lse.getSource()).getMinSelectionIndex()) {
                max = ((DefaultListSelectionModel)lse.getSource()).getMaxSelectionIndex();
                min = ((DefaultListSelectionModel)lse.getSource()).getMinSelectionIndex();
            } else {
                max = ((DefaultListSelectionModel)lse.getSource()).getMinSelectionIndex();
                min = ((DefaultListSelectionModel)lse.getSource()).getMaxSelectionIndex();
            }
            StringBuffer info = new StringBuffer();
            if (this.parent.getSelectedSequence() != null) {
                this.setSelectedSequence(this.parent.getSelectedSequence());
                info.append(this.parent.getSelectedSequence() + "\n");
                this.infoArea.setText(this.controller.getSequenceInfo(this.getSelectedSequence()));
                for (int i = min; i <= max; ++i) {
                    int pairing = this.parent.getPairing(i);
                    if (pairing == PairingMask.NO_PAIRINGMASK) {
                        info.append("No pairingmask");
                        continue;
                    }
                    if (pairing == PairingMask.NO_PAIRING) continue;
                    info.append(i + 1 + "->" + ++pairing + "\n");
                }
                this.pairingInfo.setText(info.toString());
            }
            this.positionInfo.setText(this.parent.getSelectedSequence() + ", pos: " + (min + 1) + "\n");
            String[] labels = this.controller.getColumnLabels();
            String[] values = this.controller.getColumnInfo(this.parent.getSelectedSequence(), min);
            if (values != null) {
                for (int i = 0; i < labels.length; ++i) {
                    this.positionInfo.append(labels[i] + ": " + values[i] + "\n");
                }
            }
        }
    }

    public void createSavePanel() {
        JPanel savePanel = new JPanel();
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InformationPanel.this.save();
            }
        });
        savePanel.add(saveButton);
        this.add("South", savePanel);
    }

    public void save() {
        this.controller.setAlignmentInfo(this.alignInfo.getText());
        if (this.seqLabel.getText() != null && !this.seqLabel.getText().equals("")) {
            this.controller.setSequenceInfo(this.seqLabel.getText(), this.infoArea.getText());
        }
    }

    public void setSelectedSequence(String name) {
        this.seqLabel.setText(name);
    }

    public String getSelectedSequence() {
        return this.seqLabel.getText();
    }
}

