/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.components;

import dk.kvl.controller.ProgramController;
import dk.kvl.gui.components.ProgramCheckBox;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.Parameter;
import dk.kvl.tools.Program;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class ProgramPanel
extends JPanel
implements TreeSelectionListener,
ItemListener {
    private ProgramController programs = null;
    private JPanel programPanel = new JPanel(new CardLayout());
    private JTree programTree;
    private Hashtable checkBoxes = new Hashtable();
    private List rnadbtool = new ArrayList();
    private List pfold = new ArrayList();
    private List cluster = new ArrayList();
    private List allSorted = new ArrayList();
    private Hashtable packageNodes = new Hashtable();
    private Hashtable packagePanels = new Hashtable();
    private Hashtable programPanels = new Hashtable();

    public ProgramPanel(AlignmentProperties props, ProgramController programs) {
        super(new BorderLayout());
        this.programs = programs;
        this.categorize();
        this.createProgramTree();
        this.createProgramPanels();
        this.createPackagePanels();
        this.createDefaultPanel();
        ((CardLayout)this.programPanel.getLayout()).show(this.programPanel, "default");
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.programTree), this.programPanel);
        splitPane.setDividerLocation(150);
        this.add("Center", splitPane);
    }

    public void reset() {
        Enumeration progs = this.programs.getProgramKeys();
        while (progs.hasMoreElements()) {
            String name = (String)progs.nextElement();
            if (!this.programs.isProgramSelected(name)) continue;
            this.programs.unselectProgram(name, this.checkBoxes);
        }
    }

    public void createProgramPanels() {
        for (int i = 0; i < this.allSorted.size(); ++i) {
            this.createProgramView((Program)this.allSorted.get(i));
        }
    }

    public void createProgramView(Program prog) {
        Box panel = new Box(1);
        JPanel top = new JPanel(new BorderLayout());
        top.setPreferredSize(new Dimension(500, 100));
        JPanel topTop = new JPanel(new BorderLayout());
        topTop.setPreferredSize(new Dimension(500, 50));
        JPanel topBottom = new JPanel(new BorderLayout());
        topBottom.setPreferredSize(new Dimension(500, 50));
        JLabel name = new JLabel("<html> &nbsp Program: " + prog.getName() + "</html>");
        JLabel descr = new JLabel("<html> " + prog.getDescription() + "</html>");
        descr.setFont(descr.getFont().deriveFont(0));
        JLabel input = new JLabel("<html><br>&nbsp Input format(s): " + prog.getInputTypes() + "</html>");
        topBottom.add((Component)input, "North");
        JLabel output = new JLabel("<html>&nbsp Output format(s): " + prog.getOutputTypes() + " <br></html>");
        topBottom.add((Component)output, "Center");
        top.add((Component)topBottom, "Center");
        Enumeration params = prog.getParameters();
        JPanel cBoxPanel = null;
        JPanel parameters = null;
        JPanel parametersTop = null;
        JPanel parametersBottom = null;
        Box bottom = new Box(1);
        JLabel description = null;
        ProgramCheckBox cBox = null;
        int p = 0;
        boolean selCounter = false;
        while (params.hasMoreElements()) {
            final Parameter param = (Parameter)params.nextElement();
            ++p;
            cBox = new ProgramCheckBox(prog.getName(), param.getName());
            cBoxPanel = new JPanel(new BorderLayout());
            if (prog.isParameterSelected(param.getName())) {
                cBox.setSelected(true);
            }
            cBox.addItemListener(this);
            cBoxPanel.add(cBox);
            parameters = new JPanel(new BorderLayout());
            parametersTop = new JPanel(new FlowLayout(0));
            parametersBottom = new JPanel(new FlowLayout(0));
            description = new JLabel("<html>" + param.getDescription() + "</html>");
            description.setFont(description.getFont().deriveFont(0));
            parametersTop.add(description);
            parameters.add((Component)parametersTop, "North");
            if (param.isInputRequired()) {
                JLabel pLabel = new JLabel("Parameter: ");
                pLabel.setFont(pLabel.getFont().deriveFont(0));
                parametersBottom.add(pLabel);
                final JTextField tf = new JTextField(param.getDefaultValue(), 20);
                tf.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent fe) {
                        param.setDefaultValue(tf.getText());
                    }
                });
                parametersBottom.add(tf);
                parameters.add((Component)parametersBottom, "Center");
                JPanel bottomParam = new JPanel(new BorderLayout());
                bottomParam.add((Component)cBoxPanel, "North");
                bottomParam.add((Component)parameters, "Center");
                bottom.add(bottomParam);
            } else {
                JPanel bottomParam = new JPanel(new BorderLayout());
                bottomParam.add((Component)cBoxPanel, "North");
                bottomParam.add((Component)parameters, "Center");
                bottom.add(bottomParam);
            }
            panel.add((Component)bottom, "Center");
        }
        panel.add(Box.createVerticalGlue());
        panel.setBorder(new EmptyBorder(0, 30, 0, 0));
        if (p > 0) {
            this.programPanels.put(prog.getName(), panel);
        }
    }

    public void createProgramTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Program Packages");
        this.programTree = new JTree(root);
        this.programTree.setSize(200, 500);
        this.programTree.addTreeSelectionListener(this);
        for (int i = 0; i < this.allSorted.size(); ++i) {
            DefaultMutableTreeNode packageNode;
            Program prog = (Program)this.allSorted.get(i);
            String pack = prog.getPackage();
            if (this.packageNodes.get(pack) == null) {
                packageNode = new DefaultMutableTreeNode(pack);
                this.packageNodes.put(pack, packageNode);
                root.add(packageNode);
                continue;
            }
            packageNode = (DefaultMutableTreeNode)this.packageNodes.get(pack);
        }
        this.programTree.expandRow(0);
    }

    public void categorize() {
        Enumeration e = this.programs.getProgramKeys();
        while (e.hasMoreElements()) {
            Program prog = this.programs.getProgram((String)e.nextElement());
            if (prog.getPackage().equals("rnadbtool")) {
                this.rnadbtool.add(prog);
                continue;
            }
            if (prog.getPackage().equals("pfold")) {
                this.pfold.add(prog);
                continue;
            }
            this.cluster.add(prog);
        }
        Collections.sort(this.pfold);
        Collections.sort(this.rnadbtool);
        Collections.sort(this.cluster);
        this.allSorted.addAll(this.rnadbtool);
        this.allSorted.addAll(this.pfold);
        this.allSorted.addAll(this.cluster);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.programTree.getLastSelectedPathComponent();
        if (node != null && ((String)node.getUserObject()).equals("Program Packages")) {
            ((CardLayout)this.programPanel.getLayout()).show(this.programPanel, "default");
        } else if (node != null && node.getClass().getName().equals("dk.kvl.gui.components.ProgramNode")) {
            ((CardLayout)this.programPanel.getLayout()).show(this.programPanel, (String)node.getUserObject());
        } else if (node != null) {
            ((CardLayout)this.programPanel.getLayout()).next(this.programPanel);
            ((CardLayout)this.programPanel.getLayout()).show(this.programPanel, (String)node.getUserObject());
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        JCheckBox changed = (JCheckBox)ie.getItem();
        if (ie.getItem() instanceof ProgramCheckBox) {
            String selected = ((ProgramCheckBox)changed).getProgram();
            Program prog = this.programs.getProgram(selected);
            if (!prog.isSelected()) {
                changed.setSelected(true);
                this.programs.selectProgram(changed.getText(), this.checkBoxes);
            }
            if (changed.isSelected()) {
                prog.selectParameter(changed.getText());
            } else {
                prog.unselectParameter(changed.getText());
            }
        } else {
            String selected = changed.getText();
            Program prog = this.programs.getProgram(selected);
            if (changed.isSelected()) {
                this.programs.selectProgram(changed.getText(), this.checkBoxes);
            } else {
                this.programs.unselectProgram(changed.getText(), this.checkBoxes);
            }
        }
    }

    public void createSelectProgramPanel() {
        JPanel descPanel;
        JLabel space;
        Font f;
        int i;
        JPanel selectPrograms = new JPanel(new BorderLayout());
        JLabel clust = new JLabel("<html>&nbsp CLUSTER.TCSH </html>");
        JLabel rnadb = new JLabel("<html>&nbsp RNADBTOOL <br> &nbsp Select one or more programs to run.</html>");
        Box programSelectPanel = new Box(1);
        Enumeration e = this.programs.getProgramKeys();
        JLabel description = null;
        JCheckBox cBox = null;
        Program prog = null;
        JPanel cBoxPanel = new JPanel(new BorderLayout());
        cBoxPanel.add("West", rnadb);
        programSelectPanel.add(cBoxPanel);
        for (int i2 = 0; i2 < this.rnadbtool.size(); ++i2) {
            prog = (Program)this.rnadbtool.get(i2);
            if (prog == null || !prog.getType().equals("analyzer")) continue;
            cBox = new JCheckBox(prog.getName());
            this.checkBoxes.put(prog.getName(), cBox);
            cBox.addItemListener(this);
            if (this.programs.isProgramSelected(prog.getName())) {
                cBox.setSelected(true);
            }
            description = new JLabel("<html> " + prog.getDescription() + "</html>");
            Font f2 = description.getFont();
            description.setFont(f2.deriveFont(0));
            cBoxPanel = new JPanel(new BorderLayout());
            JLabel space2 = new JLabel();
            space2.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
            JPanel descPanel2 = new JPanel(new BorderLayout());
            descPanel2.add((Component)space2, "West");
            descPanel2.add((Component)description, "Center");
            cBoxPanel.add("North", cBox);
            cBoxPanel.add("Center", descPanel2);
            programSelectPanel.add(cBoxPanel);
        }
        JLabel pfoldLabel = new JLabel("<html><br> &nbsp PFOLD <br> &nbsp Always select findphyl and scfg, then add on further programs to run. </html>");
        cBoxPanel = new JPanel(new BorderLayout());
        cBoxPanel.add("West", pfoldLabel);
        programSelectPanel.add(cBoxPanel);
        for (i = 0; i < this.pfold.size(); ++i) {
            prog = (Program)this.pfold.get(i);
            if (prog == null || !prog.getType().equals("analyzer")) continue;
            cBox = new JCheckBox(prog.getName());
            this.checkBoxes.put(prog.getName(), cBox);
            cBox.addItemListener(this);
            if (this.programs.isProgramSelected(prog.getName())) {
                cBox.setSelected(true);
            }
            description = new JLabel("<html> " + prog.getDescription() + "</html>");
            f = description.getFont();
            description.setFont(f.deriveFont(0));
            cBoxPanel = new JPanel(new BorderLayout());
            space = new JLabel();
            space.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
            descPanel = new JPanel(new BorderLayout());
            descPanel.add((Component)space, "West");
            descPanel.add((Component)description, "Center");
            cBoxPanel.add("North", cBox);
            cBoxPanel.add("Center", descPanel);
            programSelectPanel.add(cBoxPanel);
        }
        cBoxPanel = new JPanel(new BorderLayout());
        cBoxPanel.add("West", clust);
        programSelectPanel.add(cBoxPanel);
        for (i = 0; i < this.cluster.size(); ++i) {
            prog = (Program)this.cluster.get(i);
            if (prog == null || !prog.getType().equals("analyzer")) continue;
            cBox = new JCheckBox(prog.getName());
            this.checkBoxes.put(prog.getName(), cBox);
            cBox.addItemListener(this);
            if (this.programs.isProgramSelected(prog.getName())) {
                cBox.setSelected(true);
            }
            description = new JLabel("<html> " + prog.getDescription() + "</html>");
            f = description.getFont();
            description.setFont(f.deriveFont(0));
            space = new JLabel();
            space.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
            descPanel = new JPanel(new BorderLayout());
            descPanel.add((Component)space, "West");
            descPanel.add((Component)description, "Center");
            cBoxPanel = new JPanel(new BorderLayout());
            cBoxPanel.add("North", cBox);
            cBoxPanel.add("Center", descPanel);
            programSelectPanel.add(cBoxPanel);
        }
        selectPrograms.add("Center", programSelectPanel);
        this.programPanel.add("programs", selectPrograms);
    }

    public void createPackagePanels() {
        CardLayout cards = (CardLayout)this.programPanel.getLayout();
        JCheckBox cBox = null;
        for (int i = 0; i < this.allSorted.size(); ++i) {
            Box programSelectPanel;
            Program prog = (Program)this.allSorted.get(i);
            if (prog == null || !prog.getType().equals("analyzer")) continue;
            if (this.packagePanels.get(prog.getPackage()) == null) {
                JPanel packagePanel = new JPanel(new BorderLayout());
                JLabel title = new JLabel("<html><h2>&nbsp " + prog.getPackage() + " </h2>Select the programs you want to run, then click OK to run them. </html>");
                packagePanel.add("North", title);
                programSelectPanel = new Box(1);
                JScrollPane progPane = new JScrollPane(programSelectPanel);
                progPane.setHorizontalScrollBarPolicy(31);
                packagePanel.add("Center", progPane);
                this.programPanel.add(prog.getPackage(), packagePanel);
                this.packagePanels.put(prog.getPackage(), programSelectPanel);
            } else {
                programSelectPanel = (Box)this.packagePanels.get(prog.getPackage());
            }
            cBox = new JCheckBox(prog.getName());
            this.checkBoxes.put(prog.getName(), cBox);
            cBox.addItemListener(this);
            if (this.programs.isProgramSelected(prog.getName())) {
                cBox.setSelected(true);
            }
            JTextArea description = new JTextArea(prog.getDescription());
            description.setEditable(false);
            description.setLineWrap(true);
            description.setBackground(cBox.getBackground());
            description.setWrapStyleWord(true);
            Font f = description.getFont();
            description.setFont(f.deriveFont(0));
            JPanel cBoxPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 23;
            constraints.fill = 2;
            cBoxPanel.add((Component)cBox, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.weightx = 0.7;
            cBoxPanel.add((Component)description, constraints);
            constraints.gridwidth = 1;
            constraints.gridy = 0;
            constraints.gridx = 1;
            cBoxPanel.add((Component)this.optionPanel(prog.getName(), cBoxPanel), constraints);
            cBoxPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.anchor = 23;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.gridy = programSelectPanel.getComponentCount();
            programSelectPanel.add(cBoxPanel);
        }
    }

    public void createDefaultPanel() {
        JPanel defaultPanel = new JPanel(new BorderLayout());
        String text = "<html>Select a Package on the left to se its content<br><p>Expand the package-folder to be able to select parameters for individual programs.</p> </html>";
        JLabel textLabel = new JLabel(text);
        defaultPanel.add("North", textLabel);
        this.programPanel.add((Component)defaultPanel, "default");
    }

    protected Box optionPanel(String programname, JPanel panel) {
        final String name = programname;
        final JPanel p = panel;
        Box optionPanel = new Box(1);
        optionPanel.setBorder(new EmptyBorder(2, 0, 15, 0));
        if (this.programPanels.get(name) != null) {
            final JButton optionButton = new JButton("Options");
            optionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("Options")) {
                        optionButton.setText("Hide options");
                        GridBagConstraints c = new GridBagConstraints();
                        c.gridx = 0;
                        c.gridy = 2;
                        c.anchor = 21;
                        c.gridwidth = 2;
                        p.add((Component)((Box)ProgramPanel.this.programPanels.get(name)), c);
                        ProgramPanel.this.validate();
                    } else {
                        optionButton.setText("Options");
                        p.remove((Box)ProgramPanel.this.programPanels.get(name));
                    }
                }
            });
            optionButton.setBorder(new LineBorder(Color.BLACK, 1, true));
            optionPanel.add(optionButton);
        }
        JPanel options = new JPanel(new BorderLayout());
        return optionPanel;
    }
}

