/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parameter
implements Comparable {
    private String name;
    private String description;
    private boolean inputRequired;
    private String inputDescription;
    private int numberOfInputs = 0;
    private String defaultValue;
    private String value;
    private char delimiter;
    private int number = 0;
    private boolean defaultSelected = false;
    private boolean selected = false;
    private boolean spaced;

    public Parameter(String name, String description, boolean inputRequired) {
        this.name = name;
        this.description = description;
        this.inputRequired = inputRequired;
    }

    public Parameter(Node paramNode) {
        this.extractValues(paramNode);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void extractValues(Node paramNode) {
        NamedNodeMap nnm = paramNode.getAttributes();
        if (nnm.getNamedItem("selected").getNodeValue().equals("true")) {
            this.selected = true;
            this.defaultSelected = true;
        }
        if (nnm.getNamedItem("input").getNodeValue().equals("true")) {
            this.inputRequired = true;
        }
        if (nnm.getNamedItem("spaced").getNodeValue().equals("true")) {
            this.spaced = true;
        }
        if (nnm.getNamedItem("number") != null) {
            String s = nnm.getNamedItem("number").getNodeValue();
            try {
                this.number = Integer.parseInt(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        NodeList nl = paramNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String name = nl.item(i).getNodeName();
            if (name.equals("name")) {
                if (nl.item(i).getFirstChild().getNodeValue() != null) {
                    this.name = nl.item(i).getFirstChild().getNodeValue();
                    continue;
                }
                this.name = "";
                continue;
            }
            if (name.equals("paramdescription")) {
                this.description = nl.item(i).getFirstChild().getNodeValue();
                continue;
            }
            if (!name.equals("input")) continue;
            this.extractInput(nl.item(i));
        }
    }

    public void extractInput(Node inputNode) {
        NamedNodeMap nnm = inputNode.getAttributes();
        this.inputDescription = nnm.getNamedItem("description").getNodeValue();
        String number = nnm.getNamedItem("number").getNodeValue();
        try {
            this.numberOfInputs = Integer.parseInt(number);
        }
        catch (Exception e) {
            this.numberOfInputs = 1;
        }
        String delim = nnm.getNamedItem("delimiter").getNodeValue();
        if (delim.length() == 0) {
            if (this.numberOfInputs > 1) {
                this.delimiter = (char)44;
            }
        } else {
            this.delimiter = delim.charAt(0);
        }
        this.value = this.defaultValue = inputNode.getFirstChild().getNodeValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public String toString() {
        String base = this.name;
        if (this.inputRequired) {
            if (this.spaced) {
                return this.name + " " + this.defaultValue.trim();
            }
            return this.name + this.defaultValue.trim();
        }
        return this.name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public int compareTo(Object parameterObject) {
        Parameter p = (Parameter)parameterObject;
        return this.getName().compareTo(p.getName());
    }

    public int getNumber() {
        return this.number;
    }

    public void reset() {
        if (this.defaultValue != null) {
            this.value = this.defaultValue;
        }
        this.selected = this.defaultSelected;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }
}

