/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.hmmer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.State;
import org.biojava.bio.program.hmmer.FullHmmerProfileHMM;
import org.biojava.bio.program.hmmer.HmmerProfileHMM;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

public class HmmerProfileParser {
    protected Alphabet alph = ProteinTools.getAlphabet();
    protected String domain1;
    protected HmmerModel hmm;
    private static final double sumCheckThreshold = 0.001;

    public static HmmerProfileHMM parse(File inputfile) {
        HmmerProfileParser hmmP = new HmmerProfileParser(inputfile.toString());
        hmmP.parseModel(inputfile);
        hmmP.setProfileHMM();
        return hmmP.getModel();
    }

    public static FullHmmerProfileHMM parseFull(File inputfile) {
        HmmerProfileParser hmmP = new HmmerProfileParser(inputfile.toString());
        hmmP.parseModel(inputfile);
        hmmP.setProfileHMM();
        hmmP.initialiseFullProfileHMM();
        hmmP.setFullProfileHMM();
        return hmmP.getFullModel();
    }

    protected HmmerProfileParser(String domain) {
        this.domain1 = domain;
    }

    protected HmmerProfileHMM initialiseProfileHMM(int len) {
        try {
            DistributionFactory matchFactory = DistributionFactory.DEFAULT;
            DistributionFactory insertFactory = DistributionFactory.DEFAULT;
            return new HmmerProfileHMM(this.alph, len, matchFactory, insertFactory, this.domain1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public HmmerProfileHMM getModel() {
        return this.hmm.hmm;
    }

    FullHmmerProfileHMM getFullModel() {
        return this.hmm.hmm_full;
    }

    void initialiseFullProfileHMM() {
        this.hmm.initialiseFullProfileHMM();
    }

    public void setProfileHMM() {
        this.hmm.setProfileHMM();
    }

    void setFullProfileHMM() {
        this.hmm.setFullProfileHMM();
    }

    public void parseModel(File inputFile) {
        System.out.println("Parsing model " + inputFile);
        try {
            BufferedReader in = new BufferedReader(new FileReader(inputFile));
            boolean inModel = false;
            int seq_pos = 1;
            int rel_pos = 0;
            String s = new String();
            while ((s = in.readLine()) != null && !s.startsWith("//")) {
                if (!inModel) {
                    if (s.startsWith("LENG")) {
                        int[] a = HmmerProfileParser.parseString(s.substring(5), 1);
                        this.hmm = new HmmerModel(a[0]);
                        continue;
                    }
                    if (s.startsWith("NULE")) {
                        this.hmm.setNullEmissions(s.substring(5));
                        continue;
                    }
                    if (s.startsWith("NULT")) {
                        this.hmm.setNullTransitions(s.substring(5));
                        continue;
                    }
                    if (s.startsWith("XT")) {
                        this.hmm.setSpecialTransitions(s.substring(5));
                        continue;
                    }
                    if (!s.startsWith("HMM ")) continue;
                    inModel = true;
                    this.hmm.setAlphList(s.substring(7));
                    in.readLine();
                    this.hmm.setBeginTransition(in.readLine());
                    continue;
                }
                if (rel_pos == 0) {
                    this.hmm.setEmissions(s.substring(7), seq_pos);
                } else if (rel_pos == 1 && seq_pos == 1) {
                    this.hmm.setInsertEmissions(s.substring(7));
                } else if (rel_pos == 2) {
                    this.hmm.setTransitions(s.substring(7), seq_pos);
                }
                if (++rel_pos != 3) continue;
                rel_pos = 0;
                ++seq_pos;
            }
            in.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static int[] parseString(String s, int len) {
        String[] s1 = HmmerProfileParser.parseStringA(s, len);
        int[] s2 = new int[len];
        for (int i = 0; i < s1.length; ++i) {
            s2[i] = s1[i].indexOf("*") != -1 ? Integer.MIN_VALUE : Integer.parseInt(s1[i]);
        }
        return s2;
    }

    static String[] parseStringA(String s, int len) {
        String[] s2 = new String[len];
        StringTokenizer st = new StringTokenizer(s);
        for (int i = 0; st.hasMoreTokens() && i < len; ++i) {
            s2[i] = st.nextToken();
        }
        return s2;
    }

    class HmmerModel {
        int[] nullEmissions;
        int[] nullTransitions;
        int[][] emissions;
        int[] insertEmissions;
        int[][] transitions;
        int[] beginTransition;
        int[] specialTransitions;
        Symbol[] alphList;
        HmmerProfileHMM hmm;
        FullHmmerProfileHMM hmm_full;

        HmmerModel(int length) {
            System.out.println("Constructing base model");
            this.nullEmissions = new int[20];
            this.nullTransitions = new int[2];
            this.emissions = new int[length][20];
            this.insertEmissions = new int[20];
            this.specialTransitions = new int[8];
            this.transitions = new int[length + 1][9];
            this.alphList = new Symbol[21];
            this.hmm = HmmerProfileParser.this.initialiseProfileHMM(this.emissions.length);
        }

        void setAlphList(String s) {
            try {
                String[] list = HmmerProfileParser.parseStringA(s, 20);
                SymbolTokenization tokenizer = HmmerProfileParser.this.alph.getTokenization("token");
                for (int i = 0; i < list.length; ++i) {
                    this.alphList[i] = tokenizer.parseToken(list[i]);
                }
                this.alphList[list.length] = tokenizer.parseToken("U");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        void setEmissions(String s, int pos) {
            this.emissions[pos - 1] = HmmerProfileParser.parseString(s, 20);
        }

        void setNullEmissions(String s) {
            this.nullEmissions = HmmerProfileParser.parseString(s, 20);
        }

        void setInsertEmissions(String s) {
            this.insertEmissions = HmmerProfileParser.parseString(s, 20);
        }

        void setNullTransitions(String s) {
            this.nullTransitions = HmmerProfileParser.parseString(s, 2);
        }

        void setTransitions(String s, int pos) {
            this.transitions[pos] = HmmerProfileParser.parseString(s, 9);
        }

        void setBeginTransition(String s) {
            this.transitions[0] = HmmerProfileParser.parseString(s, 3);
        }

        void setSpecialTransitions(String s) {
            this.specialTransitions = HmmerProfileParser.parseString(s, 8);
        }

        void initialiseFullProfileHMM() {
            try {
                this.hmm_full = new FullHmmerProfileHMM(this.hmm);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void validateDistributionSum(Distribution dist) throws Exception {
            Iterator iter = ((FiniteAlphabet)dist.getAlphabet()).iterator();
            double sum = 0.0;
            while (iter.hasNext()) {
                Symbol to = (Symbol)iter.next();
                sum += dist.getWeight(to);
            }
            this.validateSum(sum);
        }

        private void addProbability(Distribution dist, State state, double prob) throws Exception {
            if (Double.isNaN(dist.getWeight(state))) {
                dist.setWeight(state, 0.0);
            }
            Iterator iter = ((FiniteAlphabet)dist.getAlphabet()).iterator();
            while (iter.hasNext()) {
                Symbol to = (Symbol)iter.next();
                double currentP = dist.getWeight(to);
                dist.setWeight(to, currentP * (1.0 - prob));
            }
            dist.setWeight(state, dist.getWeight(state) + prob);
            this.validateDistributionSum(dist);
        }

        private void checkTransitionSum() throws Exception {
            for (int i = 0; i <= this.hmm.columns(); ++i) {
                this.validateDistributionSum(this.hmm.getWeights(this.hmm.getMatch(i)));
                if (i <= 0 || i >= this.hmm.columns()) continue;
                this.validateDistributionSum(this.hmm.getWeights(this.hmm.getInsert(i)));
                this.validateDistributionSum(this.hmm.getWeights(this.hmm.getDelete(i)));
            }
        }

        private void validateSum(double sum) throws Exception {
            if (Math.abs(sum - 1.0) > 0.001) {
                throw new Exception("Distribution does not sum to 1.  Sums to " + sum);
            }
        }

        void addProfileHMMTransitions() throws Exception {
            for (int i = 1; i <= this.hmm.columns(); ++i) {
                if (i > 1) {
                    this.hmm.createTransition(this.hmm.magicalState(), this.hmm.getMatch(i));
                }
                if (i >= this.hmm.columns()) continue;
                this.hmm.createTransition(this.hmm.getMatch(i), this.hmm.magicalState());
            }
        }

        void modifyProbabilities() throws Exception {
            for (int i = 1; i <= this.hmm.columns(); ++i) {
                if (i > 1) {
                    this.addProbability(this.hmm.getWeights(this.hmm.magicalState()), this.hmm.getMatch(i), 0.5);
                }
                if (i >= this.hmm.columns()) continue;
                this.addProbability(this.hmm.getWeights(this.hmm.getMatch(i)), this.hmm.magicalState(), 0.5);
            }
        }

        void setBeginEnd() throws Exception {
            Distribution dist = this.hmm.getWeights(this.hmm.magicalState());
            for (int i = 1; i <= this.hmm.columns(); ++i) {
                EmissionState match = this.hmm.getMatch(i);
                Distribution match_dist = this.hmm.getWeights(match);
                dist.setWeight(match, this.convertToProb(this.transitions[i][7]));
                match_dist.setWeight(this.hmm.magicalState(), this.convertToProb(this.transitions[i][8]));
            }
        }

        void setFullProfileHMM() {
            try {
                Distribution dist = this.hmm_full.getWeights(this.hmm_full.magicalState());
                dist.setWeight(this.hmm_full.nState(), 1.0);
                dist = this.hmm_full.getWeights(this.hmm_full.nState());
                dist.setWeight(this.hmm_full.hmm(), this.convertToProb(this.specialTransitions[0]));
                dist.setWeight(this.hmm_full.nState(), this.convertToProb(this.specialTransitions[1]));
                dist = this.hmm_full.getWeights(this.hmm_full.hmm());
                dist.setWeight(this.hmm_full.cState(), this.convertToProb(this.specialTransitions[2]));
                dist.setWeight(this.hmm_full.jState(), this.convertToProb(this.specialTransitions[3]));
                dist = this.hmm_full.getWeights(this.hmm_full.cState());
                dist.setWeight(this.hmm_full.magicalState(), this.convertToProb(this.specialTransitions[4]));
                dist.setWeight(this.hmm_full.cState(), this.convertToProb(this.specialTransitions[5]));
                dist = this.hmm_full.getWeights(this.hmm_full.jState());
                dist.setWeight(this.hmm_full.hmm(), this.convertToProb(this.specialTransitions[6]));
                dist.setWeight(this.hmm_full.jState(), this.convertToProb(this.specialTransitions[7]));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        void setProfileHMM() {
            try {
                Distribution dist;
                int i;
                for (i = 0; i <= this.hmm.columns(); ++i) {
                    EmissionState match = this.hmm.getMatch(i);
                    dist = this.hmm.getWeights(match);
                    if (i < this.hmm.columns()) {
                        dist.setWeight(this.hmm.getMatch(i + 1), this.convertToProb(this.transitions[i][0]));
                        if (i >= 1) {
                            dist.setWeight(this.hmm.getInsert(i), this.convertToProb(this.transitions[i][1]));
                        }
                        dist.setWeight(this.hmm.getDelete(i + 1), this.convertToProb(this.transitions[i][2]));
                        continue;
                    }
                    dist.setWeight(this.hmm.magicalState(), 1.0);
                }
                for (i = 1; i < this.hmm.columns(); ++i) {
                    EmissionState insert = this.hmm.getInsert(i);
                    dist = this.hmm.getWeights(insert);
                    dist.setWeight(this.hmm.getMatch(i + 1), this.convertToProb(this.transitions[i][3]));
                    dist.setWeight(insert, this.convertToProb(this.transitions[i][4]));
                }
                for (i = 1; i < this.hmm.columns(); ++i) {
                    DotState delete = this.hmm.getDelete(i);
                    dist = this.hmm.getWeights(delete);
                    dist.setWeight(this.hmm.getMatch(i + 1), this.convertToProb(this.transitions[i][5]));
                    dist.setWeight(this.hmm.getDelete(i + 1), this.convertToProb(this.transitions[i][6]));
                }
                this.setBeginEnd();
                this.checkTransitionSum();
                Distribution insertEmission = this.hmm.getInsert(1).getDistribution();
                Distribution nullModel = DistributionFactory.DEFAULT.createDistribution(HmmerProfileParser.this.alph);
                for (int j = 0; j < this.alphList.length; ++j) {
                    double prob;
                    double null_prob;
                    if (j < this.alphList.length - 1) {
                        null_prob = this.convertToProb(this.nullEmissions[j], 0.05);
                        prob = this.convertToProb(this.insertEmissions[j], null_prob);
                    } else {
                        prob = 0.0;
                        null_prob = 0.0;
                    }
                    insertEmission.setWeight(this.alphList[j], prob);
                    nullModel.setWeight(this.alphList[j], null_prob);
                }
                insertEmission.setNullModel(nullModel);
                this.validateDistributionSum(insertEmission);
                this.validateDistributionSum(nullModel);
                for (int i2 = 1; i2 <= this.hmm.columns(); ++i2) {
                    Distribution matchEmission = this.hmm.getMatch(i2).getDistribution();
                    if (i2 > 1 && i2 < this.hmm.columns()) {
                        this.hmm.getInsert(i2).setDistribution(insertEmission);
                    }
                    for (int j = 0; j < this.alphList.length; ++j) {
                        double prob;
                        if (j < this.alphList.length - 1) {
                            double null_prob = this.convertToProb(this.nullEmissions[j], 0.05);
                            prob = this.convertToProb(this.emissions[i2 - 1][j], null_prob);
                        } else {
                            prob = 0.0;
                        }
                        matchEmission.setWeight(this.alphList[j], prob);
                    }
                    this.validateDistributionSum(matchEmission);
                    matchEmission.setNullModel(nullModel);
                    this.validateDistributionSum(matchEmission.getNullModel());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private double convertToProb(int score) {
            double result = 0.0;
            if (score != Integer.MIN_VALUE) {
                result = 1.0 * Math.pow(2.0, (double)score / 1000.0);
            }
            return result;
        }

        private double convertToProb(int score, double nullprob) {
            double result = 0.0;
            if (score != Integer.MIN_VALUE) {
                result = nullprob * Math.pow(2.0, (double)score / 1000.0);
            }
            return result;
        }
    }
}

