/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.io.StructureIO;
import org.biojava.utils.JDBCPooledDataSource;

public class PDBMSDReader
implements StructureIO {
    protected DataSource dataSource = null;

    public void setDBConnection(String dbDriver, String dbUrl, String dbUsername, String dbPassword) throws SQLException {
        try {
            this.dataSource = JDBCPooledDataSource.getDataSource(dbDriver, dbUrl, dbUsername, dbPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("could not get DataSource from JDBCPooledDataSource");
        }
    }

    public Structure getStructureById(String pdbId) throws IOException {
        Connection conn;
        StructureImpl structure = new StructureImpl();
        try {
            conn = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException("could not open database connection");
        }
        try {
            PreparedStatement ps = conn.prepareStatement("select residue_serial, serial, residue_id,code_3_letter, CHEM_ATOM_NAME_PDB_LS, chem_atom_name,        element_symbol,alt_code,  CHAIN_CODE_1_LETTER, chain_code, chain_pdb_code,  OCCUPANCY, PDB_CHARGE,PDB_Group, x,y,z, CHEM_COMP_CODE, CHEM_ATOM_ID,U_ISO_OR_EQUIV,  RESIDUE_PDB_SEQ, RESIDUE_PDB_INSERT_CODE from Atom_Data where accession_code = ? order by serial");
            ps.setString(1, pdbId);
            System.out.println(ps);
            ResultSet row = ps.executeQuery();
            int prev_serial = -9999;
            String prevChain = "";
            String prevType = "";
            HetatomImpl g = null;
            ChainImpl current_chain = new ChainImpl();
            while (row.next()) {
                String fname;
                int residue_serial = row.getInt(1);
                int serial = row.getInt(2);
                String residue_id = row.getString(3);
                String code_3_letter = row.getString(4);
                String CHEM_ATOM_NAME_LS = row.getString(5);
                String chem_atom_name = row.getString(6);
                String element_symbol = row.getString(7);
                String alt_code = row.getString(8);
                String chain_Code_1_Letter = row.getString(9);
                String chain_code = row.getString(10);
                String chain_pdb_code = row.getString(11);
                double OCCUPANCY = row.getDouble(12);
                String PDB_CHARGE = row.getString(13);
                String pdb_Group = row.getString(14);
                double x = row.getDouble(15);
                double y = row.getDouble(16);
                double z = row.getDouble(17);
                String ligand_code = row.getString(18);
                String chem_atom_id = row.getString(19);
                double U_ISO_OR_EQUIV = row.getDouble(20);
                int residue_pdb_seq = row.getInt(21);
                String insertionCode = row.getString(22);
                String str = "";
                if (prev_serial != residue_pdb_seq || !prevType.equals(pdb_Group)) {
                    if (prev_serial != -9999) {
                        current_chain.addGroup(g);
                    }
                    g = pdb_Group.equals("A") ? new AminoAcidImpl() : new HetatomImpl();
                }
                if (insertionCode == null) {
                    insertionCode = "";
                }
                if (chain_pdb_code == null) {
                    chain_pdb_code = " ";
                }
                if (!prevChain.equals(chain_pdb_code) && prevChain != "") {
                    structure.addChain(current_chain);
                    current_chain = new ChainImpl();
                }
                if (CHEM_ATOM_NAME_LS == null) {
                    CHEM_ATOM_NAME_LS = "";
                }
                AtomImpl a = new AtomImpl();
                a.setX(x);
                a.setY(y);
                a.setZ(z);
                a.setName(chem_atom_name);
                a.setPDBserial(serial);
                a.setOccupancy(OCCUPANCY);
                String fullname = fname = CHEM_ATOM_NAME_LS + chem_atom_name;
                for (int i = 0; i < 4 - fname.length(); ++i) {
                    fullname = fullname + " ";
                }
                a.setFullName(fullname);
                g.addAtom(a);
                g.setPDBFlag(true);
                g.setPDBName(code_3_letter);
                g.setPDBCode(residue_pdb_seq + insertionCode);
                current_chain.setName(chain_pdb_code);
                prev_serial = residue_pdb_seq;
                prevChain = chain_pdb_code;
                prevType = pdb_Group;
            }
            if (g == null) {
                return null;
            }
            current_chain.addGroup(g);
            structure.addChain(current_chain);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                conn.close();
            }
            catch (SQLException es) {
                es.printStackTrace();
            }
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException es) {
            es.printStackTrace();
        }
        return structure;
    }
}

