/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.alignmenttools.io.AlignmentWriter;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;

public class FastaWriter
extends BufferedWriter
implements AlignmentWriter {
    private Alignment alignment;

    public FastaWriter(Alignment alignment, File outFile) throws IOException {
        super(new FileWriter(outFile));
        this.alignment = alignment;
        this.writePairingmasks();
        this.flush();
        this.writeSequences();
        this.flush();
        this.close();
    }

    protected void writePairingmasks() throws IOException {
        Enumeration e = this.alignment.getPairingMaskKeys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            PairingMask pm = this.alignment.getPairingMask(name);
            this.write(">" + pm.getLabel(), 0, pm.getLabel().length() + 1);
            this.newLine();
            this.write(pm.getSequence(), 0, pm.getSequence().length());
            this.newLine();
        }
    }

    protected void writeSequences() throws IOException {
        String[] names = this.alignment.getSortedNames();
        for (int i = 0; i < names.length; ++i) {
            Sequence sequence = this.alignment.getSequence(names[i]);
            this.write(">" + sequence.getLabel(), 0, sequence.getLabel().length() + 1);
            this.newLine();
            this.write(sequence.getSequence(), 0, sequence.getSequence().length());
            this.newLine();
        }
    }
}

