/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.controller;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.controller.AlignmentIOController;
import dk.kvl.gui.event.UpdateEvent;
import dk.kvl.gui.event.UpdateListener;
import dk.kvl.sequencetools.PairingMask;
import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.FileHistory;
import dk.kvl.tools.History;
import dk.kvl.tools.IntArray;
import dk.kvl.tools.ReloadListener;
import dk.kvl.tools.history.AddColumn;
import dk.kvl.tools.history.AddPairing;
import dk.kvl.tools.history.AddSequences;
import dk.kvl.tools.history.ChangeSymbols;
import dk.kvl.tools.history.DeleteSequences;
import dk.kvl.tools.history.FileHistoryItem;
import dk.kvl.tools.history.HistoryElement;
import dk.kvl.tools.history.HistoryItem;
import dk.kvl.tools.history.PairBases;
import dk.kvl.tools.history.PairColumns;
import dk.kvl.tools.history.RemoveColumn;
import dk.kvl.tools.history.RemoveGaps;
import dk.kvl.tools.history.RemovePairing;
import dk.kvl.tools.history.RotateLeft;
import dk.kvl.tools.history.RotateRight;
import dk.kvl.tools.history.ToLowerCase;
import dk.kvl.tools.history.ToUpperCase;
import dk.kvl.tools.history.UnpairBases;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AlignmentController {
    private Alignment mainAlignment = null;
    private Vector updateListeners = new Vector();
    private Vector reloadListeners = new Vector();
    private boolean changed;
    private boolean error;
    private String label;
    private String fileName;
    private String projectDir;
    private History history;
    private FileHistory fileHistory;

    public AlignmentController(File file, String name, String projectDir) throws IOException {
        this.label = name;
        this.projectDir = projectDir;
        this.setMainAlignmentFromFile(file);
    }

    public AlignmentController(String fileName, String name, String projectDir) throws IOException {
        this(new File(fileName), name, projectDir);
    }

    public void setMainAlignmentFromFile(String fileName) throws FileNotFoundException, IOException {
        this.setMainAlignmentFromFile(new File(fileName));
    }

    protected void setMainAlignmentFromFile(File file) throws FileNotFoundException, IOException {
        String fName = file.getName();
        if (fName.endsWith(".col")) {
            this.mainAlignment = AlignmentIOController.loadAlignment(file, 0);
            this.setActivePairingmask();
            this.mainAlignment.emptyInfo();
            this.fireReloadEvent();
        } else if (fName.endsWith(".fasta") || fName.endsWith(".fa")) {
            this.mainAlignment = AlignmentIOController.loadAlignment(file, 2);
            this.setActivePairingmask();
            this.mainAlignment.emptyInfo();
            this.fireReloadEvent();
        } else if (fName.endsWith(".txt") || fName.endsWith(".widetxt")) {
            this.mainAlignment = AlignmentIOController.loadAlignment(file, 1);
            this.setActivePairingmask();
            this.mainAlignment.emptyInfo();
        } else {
            JOptionPane.showMessageDialog(null, "Unknown file format");
        }
        this.mainAlignment.setLabel(this.label);
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setMainAlignment(Alignment a) {
        this.mainAlignment = a;
    }

    protected void setActivePairingmask() {
        String value = null;
        if (this.mainAlignment.getNumberOfPairingMasks() > 1) {
            Enumeration e = this.mainAlignment.getPairingMaskKeys();
            Object[] names = new String[this.mainAlignment.getNumberOfPairingMasks()];
            int count = 0;
            while (e.hasMoreElements()) {
                names[count] = (String)e.nextElement();
                ++count;
            }
            value = (String)JOptionPane.showInputDialog(null, "There is more than one pairingmask.\nWhich one should be used ?", "Select pairingmask", 3, null, names, names[0]);
        } else {
            Enumeration e = this.mainAlignment.getPairingMaskKeys();
            if (e.hasMoreElements()) {
                value = (String)e.nextElement();
            }
        }
        this.mainAlignment.setActivePairingmask(value);
    }

    public String getPairingmaskName() {
        return this.mainAlignment.getPairingmaskName();
    }

    public int getAlignmentLength() {
        return this.mainAlignment.getLength();
    }

    public Enumeration getSequenceKeys() {
        return this.mainAlignment.getSequenceKeys();
    }

    public String getLabel() {
        return "RNA";
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getNumberOfSequences() {
        return this.mainAlignment.getNumberOfSequences();
    }

    public boolean isPairingMask(String seqKey) {
        return this.mainAlignment.getPairingMask(seqKey) != null;
    }

    public int getNumberOfPairingMasks() {
        return this.mainAlignment.getNumberOfPairingMasks();
    }

    public int getTotalNumberOfSequences(String aKey) {
        int numPair = 0;
        if (this.mainAlignment.getNumberOfPairingMasks() > 0) {
            numPair = 1;
        }
        return this.mainAlignment.getNumberOfSequences() + numPair;
    }

    public Sequence getSequence(String name) {
        Sequence seq = null;
        if (name != null && (seq = this.mainAlignment.getSequence(name)) == null) {
            seq = this.mainAlignment.getPairingMask(name);
        }
        return seq;
    }

    public Alignment getMainAlignment() {
        return this.mainAlignment;
    }

    public char getCharAt(String sequenceKey, int col) {
        Sequence seq = this.getSequence(sequenceKey);
        if (seq != null) {
            return seq.getSymbolAt(col);
        }
        return '#';
    }

    public HistoryItem toLowerCase(String[] names, int[] index) {
        if (this.mainAlignment != null) {
            int[][] result = this.mainAlignment.toLowerCase(names, index);
            this.updateViews();
            ToLowerCase historyItem = new ToLowerCase();
            historyItem.setSequences(names);
            historyItem.setIndex(index);
            historyItem.setResult(result);
            return historyItem;
        }
        return null;
    }

    public void toLowerCase(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.toLowerCase(element.getNames(), element.getIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("To Lower Case");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public HistoryItem toUpperCase(String[] names, int[] index) {
        if (this.mainAlignment != null) {
            int[][] result = this.mainAlignment.toUpperCase(names, index);
            this.updateViews();
            ToUpperCase historyItem = new ToUpperCase();
            historyItem.setSequences(names);
            historyItem.setIndex(index);
            historyItem.setResult(result);
            return historyItem;
        }
        return null;
    }

    public void toUpperCase(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.toUpperCase(element.getNames(), element.getIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("To Upper Case");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public void addMainPairingMask(PairingMask mask, String name) {
        this.mainAlignment.addPairingMask(mask);
    }

    public PairingMask getMainPairingmask(String key) {
        return this.mainAlignment.getPairingMask(key);
    }

    public void addPairingMask(PairingMask mask) {
        if (this.mainAlignment != null) {
            this.mainAlignment.addPairingMask(mask);
            this.mainAlignment.setActivePairingmask(mask.getLabel());
            this.fireReloadEvent();
            this.updateViews();
        }
    }

    public PairingMask getPairingmask() {
        if (this.mainAlignment != null) {
            return this.mainAlignment.getPairingMask();
        }
        return null;
    }

    public Enumeration getPairingMaskKeys() {
        if (this.mainAlignment != null) {
            return this.mainAlignment.getPairingMaskKeys();
        }
        return null;
    }

    public HistoryItem changeSymbols(String[] sequenceNames, int[] index, char newChar) {
        if (this.mainAlignment != null) {
            char[][] result = this.mainAlignment.changeSymbol(sequenceNames, index, newChar);
            this.updateViews();
            ChangeSymbols historyItem = new ChangeSymbols();
            historyItem.setSequences(sequenceNames);
            historyItem.setIndex(index);
            historyItem.setNewChar(newChar);
            historyItem.setResult(result);
            return historyItem;
        }
        return null;
    }

    public void changeSymbols(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.changeSymbols(element.getNames(), element.getIndex(), element.getNewChar());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Change Symbol");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public void addUpdateListener(UpdateListener ul) {
        this.updateListeners.add(ul);
    }

    public void updateViews() {
        UpdateEvent ue = new UpdateEvent(this, 1, "update");
        for (int i = 0; i < this.updateListeners.size(); ++i) {
            ((UpdateListener)this.updateListeners.get(i)).updatePerformed(ue);
        }
    }

    public String saveAlignment(File file) {
        try {
            if (file.getName().indexOf(46) == -1) {
                file = new File(file.getAbsolutePath() + ".col");
            }
            if (!file.getName().endsWith(".col")) {
                String oldName = file.getAbsolutePath();
                String newName = oldName.substring(0, oldName.lastIndexOf(46)) + ".col";
                file = new File(newName);
            }
            AlignmentIOController.saveAlignment(this.mainAlignment, file, 0);
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return null;
        }
        this.mainAlignment.setChanged(false);
        this.updateViews();
        return file.getAbsolutePath();
    }

    public char[] getAlphabet() {
        return this.mainAlignment.getAlphabet();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isChanged(String key) {
        if (this.mainAlignment != null) {
            return this.mainAlignment.isChanged();
        }
        return false;
    }

    public int getPairing(String seq, int index) {
        int result = -1;
        Sequence s = this.getSequence(seq);
        if (s != null) {
            result = s.getPairing(index);
        }
        return result;
    }

    public void changeMainAlignment(String fileName) throws IOException {
        this.setMainAlignmentFromFile(fileName);
    }

    public Color getForeground(String sequenceKey, int column) {
        return this.getSequence(sequenceKey).getForegroundColor(column);
    }

    public Color getBackground(String sequenceKey, int column) {
        if (this.getSequence(sequenceKey) != null) {
            return this.getSequence(sequenceKey).getBackgroundColor(column);
        }
        return Color.WHITE;
    }

    public String getSequenceInfo(String sequence) {
        return this.mainAlignment.getSequenceInfo(sequence);
    }

    public String getAlignmentInfo() {
        return this.mainAlignment.getInformation();
    }

    public HistoryItem rotateLeft(String[] sequences, int start, int end) {
        String[] result;
        if (this.mainAlignment != null && (result = this.mainAlignment.rotateLeft(sequences, start, end)) != null) {
            RotateLeft historyItem = new RotateLeft();
            historyItem.setSequences(sequences);
            historyItem.setStart(start);
            historyItem.setEnd(end);
            historyItem.setResult(result);
            this.updateViews();
            return historyItem;
        }
        return null;
    }

    public boolean rotateLeft(ArrayList elements) {
        boolean succes = true;
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.rotateLeft(element.getNames(), element.getStart(), element.getEnd());
            if (item != null) {
                historyItems.add(item);
                continue;
            }
            succes = false;
        }
        historyItems.add("Move right");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
        return succes;
    }

    public boolean rotateRight(ArrayList elements) {
        boolean succes = true;
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.rotateRight(element.getNames(), element.getStart(), element.getEnd());
            if (item != null) {
                historyItems.add(item);
                continue;
            }
            succes = false;
        }
        historyItems.add("Move left");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
        return succes;
    }

    public HistoryItem rotateRight(String[] sequences, int start, int end) {
        String[] result;
        if (this.mainAlignment != null && (result = this.mainAlignment.rotateRight(sequences, start, end)) != null) {
            RotateRight historyItem = new RotateRight();
            historyItem.setSequences(sequences);
            historyItem.setStart(start);
            historyItem.setEnd(end);
            historyItem.setResult(result);
            this.updateViews();
            return historyItem;
        }
        return null;
    }

    public String[] getColumnInfo(String name, int index) {
        Sequence seq = this.getSequence(name);
        if (seq != null && !(seq instanceof PairingMask)) {
            return seq.getColumnInfo(index);
        }
        return null;
    }

    public boolean removePairing(int base1, int base2) {
        char result;
        if (this.mainAlignment != null && this.mainAlignment.getPairingMask() != null && (result = this.mainAlignment.removePairing(base1, base2)) != '!') {
            this.changed = true;
            this.updateViews();
            RemovePairing historyItem = new RemovePairing();
            historyItem.setIndexA(base1);
            historyItem.setIndexB(base2);
            historyItem.setResult(result);
            this.history.add(historyItem);
            return true;
        }
        return false;
    }

    public boolean addPairing(int base1, int base2, char symbol) {
        boolean result = this.mainAlignment.addPairing(base1, base2, symbol);
        if (result) {
            this.changed = true;
            this.updateViews();
            AddPairing historyItem = new AddPairing();
            historyItem.setIndexA(base1);
            historyItem.setIndexB(base2);
            historyItem.setSymbol(symbol);
            this.history.add(historyItem);
        }
        return result;
    }

    public void setAlignmentInfo(String info) {
        this.mainAlignment.setInformation(info);
    }

    public void setSequenceInfo(String sequenceName, String info) {
        this.getSequence(sequenceName).setInformation(info);
    }

    public String[] getSortedNames() {
        return this.mainAlignment.getSortedNames();
    }

    public History getHistory() {
        return this.history;
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public void undo() {
        ArrayList items = this.history.undo();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (!(items.get(i) instanceof HistoryItem)) continue;
                HistoryItem hi = (HistoryItem)items.get(i);
                if (hi != null && (hi.getLabel().equals("Add column") || hi.getLabel().equals("Remove column") || hi.getLabel().equals("Remove gaps") || hi.getLabel().equals("Delete sequences") || hi.getLabel().equals("Sequences Added"))) {
                    this.fireReloadEvent();
                    this.updateViews();
                    continue;
                }
                this.updateViews();
            }
        }
    }

    public void undo(int index) {
        ArrayList lists = this.history.undo(index);
        boolean reload = false;
        if (lists != null) {
            for (int i = 0; i < lists.size(); ++i) {
                ArrayList items = (ArrayList)lists.get(i);
                for (int j = 0; j < items.size() - 1; ++j) {
                    HistoryItem hi;
                    if (!(items.get(j) instanceof HistoryItem) || (hi = (HistoryItem)items.get(j)) == null || !hi.getLabel().equals("Add column") && !hi.getLabel().equals("Remove column") && !hi.getLabel().equals("Remove gaps") && !hi.getLabel().equals("Delete sequences") && !hi.getLabel().equals("Sequences Added")) continue;
                    reload = true;
                }
            }
        }
        if (reload) {
            this.fireReloadEvent();
            this.updateViews();
        } else {
            this.updateViews();
        }
    }

    public void redo() {
        ArrayList items = this.history.redo();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (!(items.get(i) instanceof HistoryItem) || !(items.get(i) instanceof HistoryItem)) continue;
                HistoryItem hi = (HistoryItem)items.get(i);
                if (hi != null && (hi.getLabel().equals("Add column") || hi.getLabel().equals("Remove column") || hi.getLabel().equals("Remove gaps") || hi.getLabel().equals("Delete sequences") || hi.getLabel().equals("Sequences Added"))) {
                    this.fireReloadEvent();
                    this.updateViews();
                    continue;
                }
                this.updateViews();
            }
        }
    }

    public void redo(int index) {
        ArrayList lists = this.history.redo(index);
        boolean reload = false;
        if (lists != null) {
            for (int i = 0; i < lists.size(); ++i) {
                ArrayList items = (ArrayList)lists.get(i);
                for (int j = 0; j < items.size() - 1; ++j) {
                    HistoryItem hi = (HistoryItem)items.get(j);
                    if (hi == null || !hi.getLabel().equals("Add column") && !hi.getLabel().equals("Remove column") && !hi.getLabel().equals("Remove gaps") && !hi.getLabel().equals("Delete sequences") && !hi.getLabel().equals("Sequences Added")) continue;
                    reload = true;
                    this.updateViews();
                }
            }
        }
        if (reload) {
            this.fireReloadEvent();
        } else {
            this.updateViews();
        }
    }

    protected void updatePairings() {
        this.mainAlignment.updatePairings();
    }

    public HistoryItem removeColumn(int index) {
        if (this.mainAlignment != null) {
            char[] removed = this.mainAlignment.removeColumn(index);
            RemoveColumn item = new RemoveColumn(index, removed);
            this.fireReloadEvent();
            return item;
        }
        return null;
    }

    public void removeColumn(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.removeColumn(element.getColIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Remove column");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public int removeGaps() {
        IntArray ia = new IntArray();
        int removed = 0;
        for (int i = this.mainAlignment.getLength() - 1; i >= 0; --i) {
            boolean gapCheck = true;
            Enumeration e = this.getSequenceKeys();
            while (e.hasMoreElements()) {
                if (this.getSequence((String)e.nextElement()).getSymbolAt(i) == '-') continue;
                gapCheck = false;
                break;
            }
            if (!gapCheck) continue;
            ia.add(i);
            ++removed;
        }
        if (ia.getLength() > 0) {
            char[] mask = new char[ia.getLength()];
            for (int i = 0; i < ia.getLength(); ++i) {
                if (this.getPairingmask() != null) {
                    mask[i] = this.getPairingmask().getSymbolAt(ia.get(i));
                }
                this.mainAlignment.removeColumn(ia.get(i));
            }
            RemoveGaps item = new RemoveGaps(ia, mask);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(item);
            list.add(new String("Remove gaps"));
            this.history.add(list);
            this.fireReloadEvent();
            this.updatePairings();
            this.updateViews();
        }
        return removed;
    }

    public HistoryItem addColumn(int index) {
        this.mainAlignment.addColumn(index, '-');
        AddColumn item = new AddColumn(index);
        this.fireReloadEvent();
        return item;
    }

    public void addColumn(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.addColumn(element.getColIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Add column");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public void fireReloadEvent() {
        for (int i = 0; i < this.reloadListeners.size(); ++i) {
            try {
                ((ReloadListener)this.reloadListeners.get(i)).reload();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addReloadListener(ReloadListener rl) {
        this.reloadListeners.add(rl);
    }

    public void removeReloadListener(ReloadListener rl) {
        this.reloadListeners.remove(rl);
    }

    public String[] getColumnLabels() {
        Enumeration e = this.mainAlignment.getSequenceKeys();
        if (e.hasMoreElements()) {
            return this.mainAlignment.getSequence((String)e.nextElement()).getColumnLabels();
        }
        return null;
    }

    public void setHistory(History hist) {
        this.history = hist;
    }

    public void setFileHistory(FileHistory fileHist) {
        this.fileHistory = fileHist;
    }

    public void addFileHistoryItem(FileHistoryItem newItem) {
        this.fileHistory.add(newItem);
        this.updateViews();
    }

    public int addSequences(Alignment newSequences) {
        int result = 0;
        String[] seqnames = newSequences.getSortedNames();
        Sequence[] sequences = new Sequence[seqnames.length];
        for (int i = 0; i < seqnames.length; ++i) {
            Sequence seq;
            sequences[i] = seq = newSequences.getSequence(seqnames[i]);
            seq.setNumber(this.mainAlignment.getNumberOfSequences() + 1);
            if (!this.mainAlignment.addSequence(seq)) continue;
            ++result;
        }
        if (result > 0) {
            this.fireReloadEvent();
        }
        AddSequences historyItem = new AddSequences(sequences);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(historyItem);
        list.add("Sequences added");
        this.history.add(list);
        return result;
    }

    public boolean deleteSequences(String[] delSequences) {
        List<String> seqs = Arrays.asList(delSequences);
        ArrayList<Sequence> histSeqs = new ArrayList<Sequence>();
        Enumeration e = this.mainAlignment.getSequences();
        boolean deleted = false;
        for (int i = 0; i < delSequences.length; ++i) {
            if (!delSequences[i].equals(this.mainAlignment.getPairingmaskName())) continue;
            this.mainAlignment.removePairingmask(this.getPairingmaskName());
            deleted = true;
        }
        while (e.hasMoreElements()) {
            Sequence deletedSeq;
            Sequence s = (Sequence)e.nextElement();
            if (!seqs.contains(s.getLabel()) || (deletedSeq = this.mainAlignment.removeSequence(s.getLabel())) == null) continue;
            histSeqs.add(deletedSeq);
            deleted = true;
        }
        if (deleted) {
            ArrayList<Object> al = new ArrayList<Object>();
            DeleteSequences item = new DeleteSequences(histSeqs.toArray(new Sequence[histSeqs.size()]));
            al.add(item);
            al.add("Sequences deleted");
            this.history.add(al);
            this.mainAlignment.sort();
            this.fireReloadEvent();
            this.updateViews();
            return true;
        }
        return false;
    }

    public void removeColors() {
        Enumeration e = this.mainAlignment.getSequences();
        while (e.hasMoreElements()) {
            ((Sequence)e.nextElement()).removeColors();
        }
        if (this.getPairingmask() != null) {
            this.getPairingmask().removeColors();
        }
        if (this.mainAlignment.getPairingMask() != null) {
            this.mainAlignment.getPairingMask().removeColors();
        }
    }

    public HistoryItem pairColumns(int col1, int col2, char mask) {
        if (this.mainAlignment.pairColumns(col1, col2, mask)) {
            PairColumns item = new PairColumns(col1, col2, mask);
            this.updateViews();
            return item;
        }
        return null;
    }

    public void pairColumns(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.pairColumns(element.getCol1(), element.getCol2(), element.getMask());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Pair columns");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public HistoryItem unpair(String[] names, int[] cols) {
        if (cols.length % 2 == 0) {
            Hashtable histData = this.mainAlignment.unpair(names, cols);
            UnpairBases item = new UnpairBases(names, histData);
            this.updateViews();
            return item;
        }
        return null;
    }

    public void unpair(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.unpair(element.getNames(), element.getIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Unpair bases");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public HistoryItem pair(String[] names, int[] cols) {
        if (cols.length % 2 == 0) {
            this.mainAlignment.pair(names, cols);
            PairBases item = new PairBases(names, cols);
            this.updateViews();
            return item;
        }
        return null;
    }

    public void pair(ArrayList elements) {
        ArrayList<Object> historyItems = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HistoryElement element = (HistoryElement)elements.get(i);
            HistoryItem item = this.pair(element.getNames(), element.getIndex());
            if (item == null) continue;
            historyItems.add(item);
        }
        historyItems.add("Pair bases");
        if (!historyItems.isEmpty()) {
            this.history.add(historyItems);
        }
    }

    public void fitCases() {
        this.getMainAlignment().fitCases();
    }

    public void emptyPairingmask() {
        if (this.getPairingmask() != null) {
            char[] pm = this.mainAlignment.getPairingMask().empty();
            this.updateViews();
        }
    }
}

