/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.gui.alignment.table;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.gui.alignment.AlignmentPanel;
import dk.kvl.gui.alignment.table.AlignmentDataModel;
import dk.kvl.gui.alignment.table.AlignmentRenderer;
import dk.kvl.gui.alignment.table.AlignmentTableTransferHandler;
import dk.kvl.gui.alignment.table.SmallHeader;
import dk.kvl.gui.properties.AlignmentProperties;
import dk.kvl.tools.history.HistoryElement;
import dk.kvl.tools.history.RotateLeft;
import dk.kvl.tools.history.RotateRight;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;

public class AlignmentTable
extends JTable
implements MouseListener,
MouseMotionListener {
    private int posX = 0;
    private AlignmentProperties properties;
    private final char[] alphabet = new char[]{'A', 'a', 'U', 'u', 'C', 'c', 'G', 'g', '-', 'B', 'D', 'K', 'M', 'N', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int preferredCellHeight;
    private int preferredCellWidth;
    private int minCellHeight;
    private int minCellWidth;
    private AlignmentPanel ap;
    private JWindow warningWindow = new JWindow();

    public AlignmentTable(AlignmentDataModel adm, AlignmentProperties prop, Alignment align, AlignmentPanel ap) {
        super(adm);
        this.setDoubleBuffered(true);
        this.setTransferHandler(new AlignmentTableTransferHandler());
        this.setDragEnabled(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.properties = prop;
        this.ap = ap;
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new SmallHeader(align, prop));
        this.getSelectionModel().setSelectionMode(2);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (prop == null) {
                this.getColumn(this.getColumnName(i)).setCellRenderer(new AlignmentRenderer());
                continue;
            }
            this.getColumn(this.getColumnName(i)).setCellRenderer(new AlignmentRenderer(this.properties, ap));
        }
    }

    public void setPreferredCellSize() {
        FontMetrics fm = this.getAccessibleContext().getAccessibleComponent().getFontMetrics(this.properties.getTableFont());
        this.minCellHeight = fm.getHeight();
        this.minCellWidth = 0;
        for (int i = 0; i < this.alphabet.length; ++i) {
            int charWidth = fm.charWidth(this.alphabet[i]);
            if (charWidth <= this.minCellWidth) continue;
            this.minCellWidth = charWidth;
        }
        this.preferredCellWidth = this.minCellWidth + 2;
        this.preferredCellHeight = this.minCellHeight + 2;
    }

    public int getPreferredCellWidth() {
        this.setPreferredCellSize();
        return this.preferredCellWidth;
    }

    public int getPreferredCellHeight() {
        this.setPreferredCellSize();
        return this.preferredCellHeight;
    }

    public int getMinCellWidth() {
        this.setPreferredCellSize();
        return this.minCellWidth;
    }

    public int getMinCellHeight() {
        this.setPreferredCellSize();
        return this.minCellHeight;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 && this.continousCols(e)) {
            this.posX = e.getX();
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.posX = 0;
        }
        this.warningWindow.setVisible(false);
    }

    public void mouseDragged(MouseEvent e) {
        ArrayList<HistoryElement> history = new ArrayList<HistoryElement>();
        if (this.posX != 0) {
            int dx = e.getX() - this.posX;
            if (Math.abs(dx) >= this.getPreferredCellWidth()) {
                String[] sequences = this.ap.getSelectedSequenceNames();
                int[] cols = this.getSelectedColumns();
                int maxCol = Math.max(cols[0], cols[cols.length - 1]);
                int minCol = Math.min(cols[0], cols[cols.length - 1]);
                ListSelectionModel selectModel = this.getSelectionModel();
                if (dx > 0) {
                    if (this.isGaps(sequences, maxCol + 1)) {
                        RotateLeft hi = new RotateLeft();
                        hi.setSequences(sequences);
                        hi.setStart(minCol);
                        hi.setEnd(maxCol + 1);
                        if (hi != null) {
                            HistoryElement element = new HistoryElement(sequences, minCol, maxCol + 1);
                            history.add(element);
                            if (this.ap.getAlignmentController().rotateLeft(history)) {
                                this.removeColumnSelectionInterval(minCol, minCol);
                                this.addColumnSelectionInterval(maxCol + 1, maxCol + 1);
                            }
                        }
                    }
                } else if (this.isGaps(sequences, minCol - 1)) {
                    RotateRight hi = new RotateRight();
                    hi.setSequences(sequences);
                    hi.setStart(minCol);
                    hi.setEnd(maxCol + 1);
                    if (hi != null) {
                        HistoryElement element = new HistoryElement(sequences, minCol - 1, maxCol);
                        history.add(element);
                        if (this.ap.getAlignmentController().rotateRight(history)) {
                            this.addColumnSelectionInterval(minCol - 1, minCol - 1);
                            this.removeColumnSelectionInterval(maxCol, maxCol);
                        }
                    }
                }
                this.posX = e.getX();
            }
            e.consume();
        }
    }

    public boolean isGaps(String[] sequences, int column) {
        boolean isGaps = false;
        for (int i = 0; i < sequences.length; ++i) {
            if (this.ap.getAlignmentController().getCharAt(sequences[i], column) != '-' && this.ap.getAlignmentController().getCharAt(sequences[i], column) != '.') continue;
            isGaps = true;
            break;
        }
        return isGaps;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public boolean continousCols(MouseEvent e) {
        int[] cols = this.getSelectedColumns();
        if (cols.length > 1) {
            for (int i = 1; i < cols.length; ++i) {
                if (cols[i] == cols[i - 1] + 1 || cols[i] == cols[i - 1] - 1) continue;
                JLabel multiple = new JLabel("<html>Your have multiple selections and can't drag<br>Probably you have set selectionmode to 'both'<html>");
                this.warningWindow.getContentPane().add(multiple);
                this.warningWindow.setLocation((int)e.getComponent().getLocationOnScreen().getX() + e.getX(), (int)e.getComponent().getLocationOnScreen().getY() + e.getY());
                this.warningWindow.pack();
                this.warningWindow.setVisible(true);
                return false;
            }
        }
        return true;
    }
}

