/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.sequencetools;

import dk.kvl.sequencetools.Sequence;
import dk.kvl.tools.IntArray;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class PairingMask
extends Sequence {
    public static int OUT_OF_SEQUENCE = -3;
    public static int NO_PAIRINGMASK = -2;
    public static int NO_PAIRING = -1;

    public PairingMask() {
        this.setAlphabet(2);
    }

    public PairingMask(int length) {
        this();
        char[] seq = new char[length];
        for (int i = 0; i < length; ++i) {
            seq[i] = 45;
        }
        this.setPairingmask(seq);
    }

    public PairingMask(String label, String sequence, int alph, boolean checkSequence) throws Exception {
        super(label, sequence, alph, checkSequence);
        this.pairings = PairingMask.updatePairings(sequence.toCharArray());
    }

    public PairingMask(String label, int[] struc, int alph, boolean checkSequence) throws Exception {
        this(label, PairingMask.makePairingmask(struc), alph, checkSequence);
    }

    public Sequence getSubsequence(int begin, int end) {
        PairingMask seq = null;
        if (end < this.getLength() && begin < end && begin >= 0) {
            try {
                seq = new PairingMask(this.getLabel(), this.getSequence().substring(begin, end + 1), this.getType(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return seq;
    }

    public static int[] resolvePairings(char[] seq) {
        IntArray ia;
        Hashtable<String, IntArray> masks = new Hashtable<String, IntArray>();
        for (int i = 0; i < seq.length; ++i) {
            if (seq[i] == '-' || seq[i] == '.') continue;
            String symbol = "" + seq[i];
            ia = (IntArray)masks.get(symbol);
            if (ia == null) {
                ia = new IntArray();
                ia.add(i);
                masks.put(symbol, ia);
                continue;
            }
            ia.add(i);
        }
        Enumeration e = masks.elements();
        int[] result = new int[seq.length];
        PairingMask.initPairings(result);
        while (e.hasMoreElements()) {
            ia = (IntArray)e.nextElement();
            for (int i = 0; i < ia.getLength(); ++i) {
                result[ia.get((int)i)] = ia.get(ia.getLength() - i - 1);
            }
        }
        return result;
    }

    protected static int[] initPairings(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = NO_PAIRING;
        }
        return arr;
    }

    public boolean rotateLeft(int start, int end) {
        boolean b = super.rotateLeft(start, end);
        if (b) {
            this.rotatePairingsLeft(start, end);
        }
        return b;
    }

    public boolean rotateRight(int start, int end) {
        boolean b = super.rotateRight(start, end);
        if (b) {
            this.rotatePairingsRight(start, end);
        }
        return b;
    }

    public void rotatePairingsLeft(int start, int end) {
        int st = this.pairings[end];
        while (st == -1) {
            for (int i = end; i > start; --i) {
                this.pairings[i] = this.pairings[i - 1];
                if (this.pairings[i] == -1) continue;
                this.pairings[this.pairings[i]] = i;
            }
            this.pairings[start] = -1;
            st = this.pairings[end];
        }
    }

    public void rotatePairingsRight(int start, int end) {
        int st = this.pairings[start];
        while (st == -1) {
            for (int i = start; i < end; ++i) {
                this.pairings[i] = this.pairings[i + 1];
                if (this.pairings[i] == -1) continue;
                this.pairings[this.pairings[i]] = i;
            }
            this.pairings[end] = -1;
            st = this.pairings[start];
        }
    }

    public char removePairing(int base1, int base2) {
        char oldChar = this.getSymbolAt(base1);
        if (oldChar == '(') {
            oldChar = ')';
        } else if (oldChar == ')') {
            oldChar = '(';
        } else if (oldChar == '}') {
            oldChar = '{';
        } else if (oldChar == '{') {
            oldChar = '}';
        } else if (oldChar == '[') {
            oldChar = ']';
        } else if (oldChar == ']') {
            oldChar = '[';
        }
        if (oldChar == this.getSymbolAt(base2)) {
            this.pairings[base1] = -1;
            this.pairings[base2] = -1;
            this.setSymbolAt(base1, '-');
            this.setSymbolAt(base2, '-');
            return oldChar;
        }
        return '!';
    }

    public boolean addPairing(int base1, int base2, char symbol) {
        if (this.pairings[base1] != -1 || this.pairings[base2] != -1) {
            return false;
        }
        this.pairings[base1] = base2;
        this.pairings[base2] = base1;
        this.setSymbolAt(base1, symbol);
        this.setSymbolAt(base2, symbol);
        return true;
    }

    public static int[] updatePairings(char[] seq) {
        boolean parantese = false;
        for (int i = 0; i < seq.length; ++i) {
            if (seq[i] != '(' && seq[i] != '[' && seq[i] != '{' && seq[i] != '<') continue;
            parantese = true;
            break;
        }
        int[] pMask = parantese ? PairingMask.resolveParanteseStructure(seq) : PairingMask.resolvePairings(seq);
        return pMask;
    }

    public static int[] resolveParanteseStructure(char[] seq) {
        int[] pairs = new int[seq.length];
        PairingMask.initPairings(pairs);
        Stack<Integer> stack1 = new Stack<Integer>();
        Stack<Integer> stack2 = new Stack<Integer>();
        Stack<Integer> stack3 = new Stack<Integer>();
        Stack<Integer> stack4 = new Stack<Integer>();
        for (int i = 0; i < seq.length; ++i) {
            int val;
            if (seq[i] == '(') {
                stack1.push(new Integer(i));
                continue;
            }
            if (seq[i] == '[') {
                stack2.push(new Integer(i));
                continue;
            }
            if (seq[i] == '{') {
                stack3.push(new Integer(i));
                continue;
            }
            if (seq[i] == '<') {
                stack4.push(new Integer(i));
                continue;
            }
            if (seq[i] == ')') {
                if (stack1.empty()) continue;
                pairs[i] = val = ((Integer)stack1.pop()).intValue();
                pairs[val] = i;
                continue;
            }
            if (seq[i] == ']') {
                if (stack2.empty()) continue;
                pairs[i] = val = ((Integer)stack2.pop()).intValue();
                pairs[val] = i;
                continue;
            }
            if (seq[i] == '}') {
                if (stack3.empty()) continue;
                pairs[i] = val = ((Integer)stack3.pop()).intValue();
                pairs[val] = i;
                continue;
            }
            if (seq[i] != '>' || stack4.empty()) continue;
            pairs[i] = val = ((Integer)stack4.pop()).intValue();
            pairs[val] = i;
        }
        return pairs;
    }

    public static String makePairingmask(int[] pairs) {
        StringBuffer mask = new StringBuffer();
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i] == -1) {
                mask.append("-");
                continue;
            }
            if (pairs[i] > i) {
                mask.append("(");
                continue;
            }
            if (pairs[i] >= i) continue;
            mask.append(")");
        }
        return mask.toString();
    }

    public int[] finalProcessing() {
        super.finalProcessing();
        this.pairings = PairingMask.updatePairings(this.getSequenceArray());
        return this.pairings;
    }

    public boolean isParanteseStructure() {
        int symbol = 45;
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.getSequenceArray()[i] == '-' || this.getSequenceArray()[i] == '.') continue;
            symbol = this.getSequenceArray()[i];
            break;
        }
        return symbol == 123 || symbol == 91 || symbol == 40 || symbol == 60;
    }

    public boolean pairColumns(int col1, int col2, char mask) {
        if (this.pairings[col1] != -1 || this.pairings[col2] != -1) {
            return false;
        }
        if (mask == '(' || mask == ')') {
            if (col1 < col2) {
                this.changeSymbol('(', col1);
                this.changeSymbol(')', col2);
            } else {
                this.changeSymbol('(', col2);
                this.changeSymbol(')', col1);
            }
        } else if (mask == '{' || mask == '}') {
            if (col1 < col2) {
                this.changeSymbol('{', col1);
                this.changeSymbol('}', col2);
            } else {
                this.changeSymbol('{', col2);
                this.changeSymbol('}', col1);
            }
        } else if (mask == '[' || mask == ']') {
            if (col1 < col2) {
                this.changeSymbol('[', col1);
                this.changeSymbol(']', col2);
            } else {
                this.changeSymbol('[', col2);
                this.changeSymbol(']', col1);
            }
        } else if (mask == '<' || mask == '>') {
            if (col1 < col2) {
                this.changeSymbol('<', col1);
                this.changeSymbol('>', col2);
            } else {
                this.changeSymbol('<', col2);
                this.changeSymbol('>', col1);
            }
        } else {
            this.changeSymbol(mask, col1);
            this.changeSymbol(mask, col2);
        }
        this.pairings[col1] = col2;
        this.pairings[col2] = col1;
        return true;
    }

    public void setPairings(int[] pairs) {
        this.pairings = pairs;
    }

    public char[] empty() {
        char[] oldPairs = this.getSequence().toCharArray();
        int[] emptyPairs = new int[this.getSequence().length()];
        for (int i = 0; i < emptyPairs.length; ++i) {
            emptyPairs[i] = -1;
            this.changeSymbol('-', i);
        }
        this.setPairings(emptyPairs);
        return oldPairs;
    }
}

