/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.gui.event.UpdateEvent;
import dk.kvl.gui.event.UpdateListener;
import dk.kvl.tools.history.HistoryItem;
import java.util.ArrayList;
import java.util.LinkedList;

public class History
extends LinkedList {
    private int historyPosition;
    private int previousIndex = -1;
    private boolean undone;
    private transient Alignment alignment;
    private transient UpdateListener listener;

    public History(Alignment align) {
        this.alignment = align;
    }

    public History() {
    }

    public boolean add(ArrayList item) {
        if (this.size() > this.historyPosition) {
            this.removeTrailingHistory();
        }
        super.add(item);
        ++this.historyPosition;
        if (this.listener != null) {
            this.listener.updatePerformed(new UpdateEvent(item, 0, "add"));
        }
        return true;
    }

    public ArrayList get() {
        return (ArrayList)this.get(this.historyPosition - 1);
    }

    public ArrayList getNext() {
        if (this.historyPosition < this.size()) {
            return (ArrayList)this.get(this.historyPosition);
        }
        return null;
    }

    public ArrayList redo() {
        ArrayList item = this.getNext();
        if (item != null) {
            for (int i = 0; i < item.size() - 1; ++i) {
                ((HistoryItem)item.get(i)).redo(this.alignment);
            }
            ++this.historyPosition;
        }
        return item;
    }

    public ArrayList redo(int index) {
        ArrayList<ArrayList> items = new ArrayList<ArrayList>();
        if (this.historyPosition >= 0) {
            int pos;
            for (int i = pos = this.historyPosition; i <= index; ++i) {
                items.add(this.redo());
            }
        }
        return items;
    }

    public ArrayList undo() {
        ArrayList hi = null;
        if (this.historyPosition > 0) {
            hi = this.get();
            ArrayList items = this.get();
            for (int i = 0; i < items.size() - 1; ++i) {
                ((HistoryItem)items.get(i)).undo(this.alignment);
            }
            --this.historyPosition;
        }
        return hi;
    }

    public ArrayList undo(int index) {
        ArrayList<ArrayList> items = new ArrayList<ArrayList>();
        if (this.historyPosition > 0) {
            int pos = this.historyPosition - 1;
            for (int i = index; i <= pos; ++i) {
                items.add(this.undo());
            }
        }
        return items;
    }

    public int getPosition() {
        return this.historyPosition;
    }

    public void setPosition() {
        this.historyPosition = this.size() - 1;
    }

    protected void removeTrailingHistory() {
        while (this.size() > this.historyPosition) {
            int[] index = new int[]{this.indexOf(this.getLast())};
            this.removeLast();
            if (this.listener == null) continue;
            this.listener.updatePerformed(new UpdateEvent(index, 1, "remove"));
        }
    }

    public void setAlignment(Alignment align) {
        this.alignment = align;
    }

    public void addUpdateListener(UpdateListener listener) {
        this.listener = listener;
    }

    public int getIndex() {
        return this.historyPosition - 1;
    }

    public int getPreviousIndex() {
        return this.previousIndex;
    }

    public void setPreviousIndex(int previousIndex) {
        this.previousIndex = previousIndex;
    }

    public void setUndone(boolean undone) {
        this.undone = undone;
    }

    public boolean getUndone() {
        return this.undone;
    }
}

