/*
 * Decompiled with CFR 0.152.
 */
package dk.kvl.tools;

import dk.kvl.tools.Parameter;
import dk.kvl.tools.io.ErrorReaderThread;
import dk.kvl.tools.io.Log;
import dk.kvl.tools.io.StreamReaderThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Program
implements Comparable {
    private String name;
    private String type;
    private String pack;
    private String sequenceType;
    private String description;
    private boolean error;
    private Vector inputTypes = new Vector();
    private Vector outputTypes = new Vector();
    private Hashtable parameters = new Hashtable();
    private Vector selectedParams = new Vector();
    private boolean selected;
    private int priority;
    private String path;
    private boolean errorMessage = false;
    private String depends = null;
    private Vector outputFiles = new Vector();

    public Program(Node programNode) {
        this.createProgram(programNode);
    }

    public void createProgram(Node programNode) {
        NamedNodeMap nnm = programNode.getAttributes();
        this.setName(nnm.getNamedItem("name").getNodeValue());
        this.setType(nnm.getNamedItem("type").getNodeValue());
        this.setPackage(nnm.getNamedItem("package").getNodeValue());
        if (nnm.getNamedItem("depends").getNodeValue() != null) {
            this.depends = nnm.getNamedItem("depends").getNodeValue();
        }
        this.setPriority(Integer.parseInt(nnm.getNamedItem("priority").getNodeValue()));
        this.setSequenceType(nnm.getNamedItem("sequencetype").getNodeValue());
        this.setSelected(Boolean.getBoolean(nnm.getNamedItem("selected").getNodeValue()));
        NodeList nl = programNode.getChildNodes();
        Node node = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            node = nl.item(i);
            if (node.getNodeName().equals("programdescription")) {
                this.setDescription(node.getFirstChild().getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("parameters")) {
                this.extractParamters(node);
                continue;
            }
            if (node.getNodeName().equals("inputformats")) {
                this.extractInputFormats(node);
                continue;
            }
            if (node.getNodeName().equals("outputformats")) {
                this.extractOutputFormats(node);
                continue;
            }
            if (!node.getNodeName().equals("files")) continue;
            this.extractFiles(node);
        }
    }

    private void extractFiles(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals("file")) continue;
            this.addFile(n.getTextContent());
        }
    }

    public void extractParamters(Node parameterNode) {
        Parameter param = null;
        NodeList nl = parameterNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("param")) continue;
            param = new Parameter(nl.item(i));
            this.addParameter(param);
            if (!param.isSelected()) continue;
            this.selectParameter(param.getName());
        }
    }

    public void extractInputFormats(Node inputNode) {
        NodeList nl = inputNode.getChildNodes();
        Object node = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("fileextension")) continue;
            NodeList list = nl.item(i).getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                this.addInputFormat(list.item(j).getNodeValue());
            }
        }
    }

    public void extractOutputFormats(Node outputNode) {
        NodeList nl = outputNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("fileext")) continue;
            NodeList list = nl.item(i).getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                this.addOutputFormat(list.item(j).getNodeValue());
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPackage(String pack) {
        this.pack = pack;
    }

    public String getType() {
        return this.type;
    }

    public String getPackage() {
        return this.pack;
    }

    public void setSequenceType(String sequenceType) {
        this.sequenceType = sequenceType;
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    public Vector getSelectedParameters() {
        Collections.sort(this.selectedParams);
        return this.selectedParams;
    }

    public void selectParameter(String param) {
        if (this.getParameter(param) != null) {
            this.getParameter(param).setSelected(true);
            this.selectedParams.add(this.getParameter(param));
        }
    }

    public Parameter getParameter(String key) {
        return (Parameter)this.parameters.get(key);
    }

    public void unselectParameter(String param) {
        if (this.getParameter(param) != null) {
            this.getParameter(param).setSelected(false);
            this.selectedParams.remove(this.getParameter(param));
        }
    }

    public boolean isParameterSelected(String paramName) {
        return this.getParameter(paramName).isSelected();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public String getSequenceType() {
        return this.sequenceType;
    }

    public Vector getInputTypes() {
        return this.inputTypes;
    }

    public Vector getOutputTypes() {
        return this.outputTypes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addInputFormat(String ext) {
        this.inputTypes.add(ext);
    }

    public void addOutputFormat(String ext) {
        this.outputTypes.add(ext);
    }

    public void addParameter(Parameter param) {
        this.parameters.put(param.getName(), param);
    }

    public String toString() {
        return this.name;
    }

    public void execute(File dataFile, File resultFile, Log log, String ppFile) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        log.writeLine("---------------" + this.name + " started----------------");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.name);
        log.write(this.name, 0, this.name.length());
        for (int i = 0; i < this.getSelectedParameters().size(); ++i) {
            String s = ((Parameter)this.getSelectedParameters().get(i)).toString();
            cmds.add(s);
            if (s.equals("--ppfile")) {
                new File(ppFile);
                cmds.add(ppFile);
                log.write(" " + s);
                log.write(" " + ppFile);
                continue;
            }
            log.write(" " + s);
        }
        if (this.name.equals("drawdot")) {
            cmds.add(ppFile);
        } else {
            cmds.add(dataFile.getAbsolutePath());
        }
        log.writeLine(" " + dataFile.getAbsolutePath());
        Process p = runtime.exec(cmds.toArray(new String[cmds.size()]), null, new File(dataFile.getParent()));
        BufferedReader resultReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedWriter resultWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(resultFile)));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        StreamReaderThread srt = new StreamReaderThread(resultReader, resultWriter);
        ErrorReaderThread ert = new ErrorReaderThread(errorReader, log, this);
        srt.start();
        ert.start();
        p.waitFor();
        srt.join();
        ert.join();
        log.writeLine("---------" + this.name + " finished---------------");
        log.flush();
        resultWriter.flush();
        resultReader.close();
        resultWriter.close();
        errorReader.close();
        if (this.error) {
            this.errorMessage = true;
        }
    }

    public void execute(File dataFile, Log log) {
        File newFile = null;
        try {
            String oldName = dataFile.getAbsolutePath();
            String newName = oldName.substring(0, oldName.length() - 4);
            newFile = new File(newName + ".fasta");
            newFile.createNewFile();
            String[] cmds = new String[]{"col2fasta", oldName};
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(cmds, new String[0], new File(dataFile.getParent()));
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedWriter resultWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(newFile)));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            StreamReaderThread srt = new StreamReaderThread(resultReader, resultWriter);
            ErrorReaderThread ert = new ErrorReaderThread(errorReader, log, this);
            srt.start();
            ert.start();
            p.waitFor();
            srt.join();
            ert.join();
            resultWriter.flush();
            resultReader.close();
            resultWriter.close();
            errorReader.close();
            if (this.error) {
                this.errorMessage = true;
            }
            ArrayList allCommands = new ArrayList();
            ArrayList<String> cmd = new ArrayList<String>();
            String range = null;
            String group = null;
            cmd.add("cluster.tcsh");
            cmd.add(newFile.getAbsolutePath());
            for (int i = 0; i < this.getSelectedParameters().size(); ++i) {
                String[] split;
                String s = ((Parameter)this.getSelectedParameters().get(i)).toString();
                if (s.indexOf("Group file") != -1) {
                    split = s.split(" ");
                    group = split[split.length - 1];
                    continue;
                }
                if (s.indexOf("Range") == -1 || (range = (split = s.split(" "))[split.length - 1]) == null) continue;
                cmd.add(range);
            }
            allCommands.add(cmd);
            ArrayList<String> cmd2 = new ArrayList<String>();
            cmd2.add("makeplots.tcsh");
            cmd2.add(newFile.getAbsolutePath());
            cmd2.add(newName + "_groups_" + group + ".txt");
            if (range != null) {
                cmd2.add(range);
            }
            allCommands.add(cmd2);
            ArrayList<String> cmd3 = new ArrayList<String>();
            cmd3.add("makestruc.tcsh");
            cmd3.add(newFile.getAbsolutePath());
            cmd3.add(newName + "_groups_" + group + ".txt");
            allCommands.add(cmd3);
            runtime = Runtime.getRuntime();
            for (int i = 0; i < allCommands.size(); ++i) {
                if (i > 0) {
                    File groupFile = new File(newName + "_groups_" + group + ".txt");
                    while (!groupFile.exists()) {
                    }
                }
                ArrayList list = (ArrayList)allCommands.get(i);
                String proName = (String)list.get(0);
                log.writeLine("---------" + proName + " started---------------");
                p = runtime.exec(list.toArray(new String[cmd.size()]), new String[0], new File(dataFile.getParent()));
                File tmpOut = File.createTempFile("tmpOut", "txt");
                resultReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                resultWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpOut.getAbsolutePath())));
                errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                srt = new StreamReaderThread(resultReader, resultWriter);
                ert = new ErrorReaderThread(errorReader, log, this);
                srt.start();
                ert.start();
                p.waitFor();
                srt.join();
                ert.join();
                log.writeLine("---------" + proName + " finished---------------");
                log.flush();
                resultWriter.flush();
                resultReader.close();
                resultWriter.close();
                errorReader.close();
                tmpOut.delete();
                if (!this.error) continue;
                this.errorMessage = true;
            }
        }
        catch (Exception e) {
            System.out.println("Error Program.execute: " + e);
        }
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int prior) {
        this.priority = prior;
    }

    public int compareTo(Object programObject) {
        int before = -1;
        boolean after = true;
        boolean equal = false;
        Program p = (Program)programObject;
        if (this.getPriority() < p.getPriority()) {
            return -1;
        }
        if (this.getPriority() > p.getPriority()) {
            return 1;
        }
        return 0;
    }

    public void addFile(String file) {
        this.outputFiles.add(file);
    }

    public Vector getFiles() {
        return this.outputFiles;
    }

    public String getFile(int index) {
        if (index >= 0 && index < this.outputFiles.size()) {
            return (String)this.outputFiles.get(index);
        }
        return null;
    }

    public String getDepends() {
        return this.depends;
    }

    public void reset() {
        this.selectedParams = new Vector();
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)this.parameters.get((String)e.nextElement());
            p.reset();
            if (!p.isSelected()) continue;
            this.selectedParams.add(p);
        }
    }
}

