/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.impl.ViewSequence;

public abstract class ViewSequenceFactory {
    protected SequenceDBInstallation subjectDBs;
    protected SequenceDB querySeqHolder;
    protected String databaseID;
    protected Map queryViewCache;
    protected Map subjectViewCache;

    public SequenceDB getQuerySeqHolder() {
        return this.querySeqHolder;
    }

    public void setQuerySeqHolder(SequenceDB querySeqHolder) {
        this.querySeqHolder = querySeqHolder;
    }

    public SequenceDBInstallation getSubjectDBInstallation() {
        return this.subjectDBs;
    }

    public void setSubjectDBInstallation(SequenceDBInstallation subjectDBs) {
        this.subjectDBs = subjectDBs;
    }

    public void setDatabaseID(String databaseID) {
        this.databaseID = databaseID;
    }

    protected Sequence makeQueryViewSequence(String queryID) throws BioException {
        if (this.querySeqHolder == null) {
            throw new BioException("Running with null query SequenceDB");
        }
        if (this.queryViewCache.containsKey(queryID)) {
            return (Sequence)this.queryViewCache.get(queryID);
        }
        Sequence query = this.querySeqHolder.getSequence(queryID);
        if (query == null) {
            throw new BioException("Failed to retrieve query sequence from holder using ID '" + queryID + "' (sequence was null)");
        }
        query = new ViewSequence(query);
        this.queryViewCache.put(queryID, query);
        return query;
    }

    protected Sequence makeSubjectViewSequence(String subjectID) throws BioException {
        if (this.subjectDBs == null) {
            throw new BioException("Running with null subject SequenceDB installation");
        }
        SequenceDBLite subjectDB = this.subjectDBs.getSequenceDB(this.databaseID);
        if (subjectDB == null) {
            throw new BioException("Failed to retrieve database from installation using ID '" + this.databaseID + "' (database was null)");
        }
        if (this.subjectViewCache.containsKey(subjectID)) {
            return (Sequence)this.subjectViewCache.get(subjectID);
        }
        Sequence subject = subjectDB.getSequence(subjectID);
        if (subject == null) {
            throw new BioException("Failed to retrieve subject sequence from subjectDB using ID '" + subjectID + "' (sequence was null)");
        }
        subject = new ViewSequence(subject);
        this.subjectViewCache.put(subjectID, subject);
        return subject;
    }
}

