import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import src.GlobalParameters;
import src.Pairwise;

public class AlignToStructure {
	/**
	 * @param args
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception {
		
		if(args.length < 3){
			System.err.println("To run this program you need to provide it with a fasta file, a output name and a file with consensus sequence and structure!");
			System.err.println("Usage: java AlignToStructure <fasta file> <output> <consensus file>");
			System.exit(0);
		}
		
		//final Parameters para = new Parameters();
		final boolean nolog = GlobalParameters.nolog;
		String line,out;
		int lengthA,lengthB;//merges,tmp,k;
		double score,tmp;
		//double[][] SM;
		String name="", seq, temp,seqA,seqB,nameA,nameB;
		Pattern p,p2;
		final HashMap<String,String> fasta = new HashMap<String,String>();
		//Read a file with all the pairwise scores
		final String fastaFile = args[0];
		final String outName = args[1];
		final String givenStructure = args[2];
		
		Set<String> set;
		Iterator<String> iter;
		String[] names;
		String[] seqs;
		InputStream input = new FileInputStream(fastaFile);
		BufferedReader fil = new BufferedReader(new InputStreamReader(input));
		Matcher match,match2;
		p = Pattern.compile("^>(.*?)$");
		p2 = Pattern.compile("^(.*)$");
		
//		Make the relevant directories if they do not exist
		String mkdir = "";
		Process mv;
		if(!exists(".fold_matrix")){
			mkdir = "mkdir .fold_matrix";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(!exists(".fold_cons")){
			mkdir = "mkdir .fold_cons";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(!exists(".fold_rnafold")){
			mkdir = "mkdir .fold_rnafold";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(!exists(".fold_out")){
			mkdir = "mkdir .fold_out";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(!exists(".fold_matrix/"+outName)){
			mkdir = "mkdir .fold_matrix/"+outName;
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		/*
		 * Process the fasta file into the ID,Sequence @fasta HashMap
		 */
		while((line = fil.readLine()) != null){
			match = p.matcher(line);
			match2 = p2.matcher(line);
			if(match.find()){
				name = match.group(1);
			}else if(match2.find()){
				temp = match2.group(1);
				if(fasta.containsKey(name)){
					seq = fasta.get(name);
					seq += temp;
				}else{
					seq = temp;
				}
				fasta.put(name,seq);
			}
		}
		
		input = new FileInputStream(givenStructure);
		fil = new BufferedReader(new InputStreamReader(input));
		String consensusSequence = fil.readLine();
		char[] consensusStructure = fil.readLine().toCharArray();
		FileWriter outf = new FileWriter(".fold_out/"+outName+".prob");
		PrintWriter write = new PrintWriter( outf );
		final int consensusLength = consensusStructure.length;
		final int consensusSeqLength = consensusSequence.length();
		
		if(consensusSeqLength != consensusLength){
			System.err.println("The lengths of the sequence and structure are not equal in the consensus structure!");
			System.exit(0);
		}
		
		write.print("Sequence:");
		write.print(consensusSequence);
		write.println();		
		Stack<Integer> left = new Stack<Integer>();
		//final int[][] consensus = new int[consensusLength][consensusLength];
		int jStart= consensusLength-1;
		int leftCounter = 0;
		int rightCounter = 0;
		for(int i=0; i<jStart; i++){
			//for(int j=jStart; j>i; j--){
			if(consensusStructure[i] == '('){
				left.push(i);
				leftCounter++;
			}
			if(consensusStructure[i] == ')'){
				rightCounter++;
				write.println(((left.pop())+1)+" "+(i+1)+" "+1.000+" ubox");		
			}
		}
		outf.close();
		if(leftCounter != rightCounter){
			System.err.println("The number of left '(' and right ')' base pairs is not equal in the consensus structure!");
			System.exit(0);
		}
		/*
		 * Run RNAfold
		 */
		int z = 0;
		set = fasta.keySet();
		iter = set.iterator();
		int NN = set.size();
		names = new String[NN];
		seqs = new String[NN];
		while(iter.hasNext()){
			name = iter.next();
			seq = fasta.get(name);
			names[z] = name;
			seqs[z] = seq;
			z++;
			String s = null;
			//system command to run
			final String[] cmd = new String[]{"/bin/sh","-c","echo \"" +seq+"\" | RNAfold -p -noLP"};
			name = name.replace('/','_');
			final String move = "mv dot.ps .fold_rnafold/"+name;
			final String remove = "rm rna.ps";
			//				set the working directory for the OS command processor
			try {
				final Process pr = Runtime.getRuntime().exec(cmd);
				final int o = pr.waitFor();
				if (o == 0){
					//BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
					//						read the output from the command
					//while ((s = stdInput.readLine()) != null) {
					//	System.out.println(s);
					//}
				}
				else {
					final BufferedReader stdErr = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
					//						read the output from the command
					while ((s = stdErr.readLine()) != null) {
						System.out.println(s);
					}
					
				}
				mv = Runtime.getRuntime().exec(move);
				mv.waitFor();
				mv = Runtime.getRuntime().exec(remove);
				mv.waitFor();
			}
			catch (Exception e) {
				System.out.println(e);
			}
		}
		
		p = Pattern.compile("^(\\d+)\\s+(\\d+)\\s+(\\d\\.\\d+)\\s+ubox$");
		final double minread = Math.sqrt(0.0001);
		
		for(int f=0; f<NN; f++){
			nameA = names[f];
			seqA = fasta.get(nameA);
			nameA = nameA.replace('/','_');
			final InputStream inputA = new FileInputStream(".fold_rnafold/"+nameA);
			final BufferedReader filA = new BufferedReader(new InputStreamReader(inputA));
			lengthA = seqA.length();
			out = "Sequence:" + seqA +"\n";
			final double[][] pm1 = new double[lengthA+1][lengthA+1];
			while((line = filA.readLine()) != null){
				match = p.matcher(line);
				if(match.find()){
					out += line +'\n';
					tmp = Double.parseDouble(match.group(3));
					if(tmp<minread){continue;}
					if (!nolog) {
						score = Math.log(tmp*lengthA*2)/(Math.log(lengthA<<1));
						if(score < 0){continue;}
					} else {
						score = tmp*tmp;
					}
					pm1[Integer.parseInt(match.group(1))][Integer.parseInt(match.group(2))] = score;
				}
			}
			writeToFile(out, ".fold_matrix/"+outName+"/"+(f+1)+".out");
			if(f==NN-1){break;}
			for(int f2=f+1; f2<NN; f2++){
				nameB = names[f2];
				seqB = fasta.get(nameB);
				nameB = nameB.replace('/','_');
				final InputStream inputB = new FileInputStream(".fold_rnafold/"+nameB);
				final BufferedReader filB = new BufferedReader(new InputStreamReader(inputB));
				lengthB = seqB.length();
				final double[][] pm2 = new double[lengthB+1][lengthB+1];
				while((line = filB.readLine()) != null){
					match = p.matcher(line);
					if(match.find()){
						tmp = Double.parseDouble(match.group(3));
						if(tmp<minread){continue;}
						if (!nolog) {
							score = Math.log(tmp*lengthB*2)/(Math.log(lengthB*2));
							if(score < 0){continue;}
						} else {
							score = tmp*tmp;
						}
						pm2[Integer.parseInt(match.group(1))][Integer.parseInt(match.group(2))] = score;
					}
				}						
				//final ProfComp fast = new ProfComp(pm1,seqA,pm2,seqB,para);	
				//SM[f+1][f2+1] = fast.getScore();
				//SM[f2+1][f+1] = fast.getScore();
			}
		}			
		final String[] allNames = new String[NN+(NN-1)];
		for(int i=0;i<allNames.length;i++){
			if(i < NN){
				allNames[i] = names[i];
			}else{
				allNames[i] = "Merge" + (i-NN+1);
			}	
		}
		
		//Make a WPGMA guide tree to guide the multiple alignment
		//final Wpgma guide = new Wpgma(NN, SM, "tmp/");
		//final ArrayList<PairAlignment> pas = guide.getPairAlignments();
		//String[] align;
		//The last pairwise alignment is the multiple alignment
		//final PairAlignment last = pas.get(pas.size()-1);
		final String FORMAT = "%-30s %s%n";
		FileWriter consaln = new FileWriter(".fold_out/"+outName+".out",false);
		PrintWriter file = new PrintWriter( consaln );
		Pairwise pairw;
		for(int i=1; i<=NN;i++){
			//System.out.println(names[i-1]);
			pairw = new Pairwise(".fold_matrix/"+outName+"/"+i+".out", ".fold_out/"+outName+".prob", ".fold_cons/"+i + ".out");
			//pairw = new Pairwise("tmpMatrix/"+i+".out", "out/cons.out", "tmp2/"+i + ".out");
			file.printf(FORMAT,names[i-1],pairw.getSeqA());
			file.printf(FORMAT,names[i-1],pairw.getStrA());
		}
		file.close();
	}
	
	public static void writeToFile(final String data,String name) throws IOException{
		final File cOutFile = new File(name);
		if (cOutFile.exists())
			cOutFile.delete();
		if (cOutFile.createNewFile())
			;
		final FileWriter cOutFileWriter = new FileWriter(cOutFile);
		cOutFileWriter.write(data);
		cOutFileWriter.flush();
		cOutFileWriter.close();
	}
	private static boolean exists (String filename) {
        return exists (filename, new File ("."));
    }
 
    private static boolean exists (String filename, File dir) {
        boolean exists = false;
 
        if (new File (dir, filename).exists ()) {
            exists = true;
        } else {
            File[] subdirs = dir.listFiles ();
 
            int i = 0;
            int n = (subdirs == null) ? 0 : subdirs.length;
 
            while ((i < n) && ! exists) {
                File subdir = subdirs[i];
 
                if (subdir.isDirectory ()) {
                    exists = exists (filename, subdir);
                }
 
                i ++;
            }
        }
 
        return exists;
    }
}