package src;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public final class MakeMultiple {

	private int merges = 0;
	private int i = 0;
	private int j = 0;
	private int score = 0;
	private int count = 0;
	private int length = 0;
	private String lastSeqA = null;
	private String lastStrA = null;
	private String lastSeqB = null;
	private String lastStrB = null;
	private String[] align;

	public MakeMultiple(final PairAlignment last, final String[] allNames, final String[] names, final ArrayList<PairAlignment> pas, final int NN, final String path,final String outName) throws IOException, InterruptedException{
		final HashMap<String,MultipleAlignment> multipleAlignment = new HashMap<String,MultipleAlignment>();
		final char[] chars = {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'};
		final String[] seqs = last.getAli();
		int id = last.getIm();
		lastSeqA = seqs[0];
		lastStrA = seqs[1];
		lastSeqB = seqs[2];
		lastStrB = seqs[3];
		MultipleAlignment ma = new MultipleAlignment(lastSeqA,lastStrA);
		multipleAlignment.put(allNames[id-1],ma);
		id = last.getJm();
		score = last.getScore();
		count++;
		length = lastSeqA.length();
		ma = new MultipleAlignment(lastSeqB,lastStrB);
		multipleAlignment.put(allNames[id-1],ma);
		//System.out.println("Merges: "+merges);
		merges = pas.size(); //The number of merges
		for (int m=merges-2; m>=0; m--) {
			final PairAlignment pa = pas.get(m);
			final int which = pa.getK();
			if (multipleAlignment.containsKey(allNames[which-1])) {
				String ali = "";
				ali  = multipleAlignment.get(allNames[which-1]).getSeq();
				final int id1 = pa.getIm();
				final int id2 = pa.getJm();
				score += pa.getScore();
				count++;
				align = pa.getAli();
				final String seq1 = align[0];
				final String str1 = align[1];
				final String seq2 = align[2];
				final String str2 = align[3];

				String seq1a ="";
				String seq2a="";
				String str1a="";
				String str2a="";
				int j1 = 0;

				for (j=0; j< ali.length(); j++) {
					if (ali.charAt(j) == '-') {
						seq1a += '-' ;
						seq2a += '-' ;
						str1a += '-' ;
						str2a += '-' ;
					}else if(ali.charAt(j) == '~'){
						seq1a += '~' ;
						seq2a += '~' ;
						str1a += '~' ;
						str2a += '~' ;
					}
					else {
						seq1a += seq1.charAt(j1);
						seq2a += seq2.charAt(j1);
						str1a += str1.charAt(j1);
						str2a += str2.charAt(j1);
						j1++;
					}
				}
				multipleAlignment.remove(allNames[which-1]);
				ma = new MultipleAlignment(seq1a,str1a);
				multipleAlignment.put(allNames[id1-1],ma);
				ma = new MultipleAlignment(seq2a,str2a);
				multipleAlignment.put(allNames[id2-1],ma);
			}
		}
		Set<String> set= multipleAlignment.keySet();
		Iterator<String> iter = set.iterator();
		length = 0;

		//Make a array to keep track of the number of each base at each pos
		//int[] A =new int[length],U=new int[length],C=new int[length],G=new int[length],Gap = new int[length];

		//FileWriter outFile = new FileWriter("out/"+outName+".aln.out",true);
		//PrintWriter writer = new PrintWriter( outFile );
		final FileWriter outFil = new FileWriter(".fold_out/"+outName+".original.out",true);
		final PrintWriter original = new PrintWriter( outFil );	
		Stack<Integer> temp = new Stack<Integer>();
		int popped = 0;
		//final int[] bp = null;
		int[][] consensus = new int[lastSeqA.length()][lastSeqA.length()];
		final String FORMAT = "%-30s %s%n";
		String name="";
		String seq="";
		String str="";
		String seqB="";
		String strB="";
		while(iter.hasNext()){
			//bp = new int[length];
			name = iter.next();
			ma = multipleAlignment.get(name);
			seq = ma.getSeq();
			str = ma.getStr();
			length = seq.length();
			for(i=0; i<length;i++){
				/*switch (seq.charAt(i)){
				 case 'A': A[i]++; break;
				 case 'a': A[i]++; break;
				 case 'C': C[i]++; break;
				 case 'c': C[i]++; break;
				 case 'G': G[i]++; break;
				 case 'g': G[i]++; break;
				 case 'U': U[i]++; break;
				 case 'u': U[i]++; break;
				 case '-': Gap[i]++; break;
				 default: break;
				 }*/
				if(str.charAt(i) == '('){
					temp.push(i);
				}else if(str.charAt(i) == ')'){
					//bp[temp.pop()] = i;
					popped = temp.pop();
					consensus[popped][i]++;
					consensus[i][popped]++;
				}
			}
			//System.out.println("Stack Size: "+ temp.size());
			//bps.put(name,bp);
			original.printf(FORMAT,name,seq);
			original.printf(FORMAT,name,str);
		} 
		original.println("#Total Score: "+score+"\tAverage Score: "+(score/count)+"\tNormalized Score: "+(score/(count*Math.log(length))));
		original.close();

		if(GlobalParameters.allSeqs>2){
			length = lastSeqA.length();
			set= multipleAlignment.keySet();
			iter = set.iterator();
			final int antalSeq = multipleAlignment.size();
			int limit = ((antalSeq/GlobalParameters.consensus));

			//Write a new probabilty matrix with the most frequently occurring base pairs
			FileWriter outf = new FileWriter(".fold_out/"+outName+".prob");
			PrintWriter write = new PrintWriter( outf );

			write.print("Sequence:");
			for(i=0; i<length;i++){
				write.print("N");
			}
			write.println();
			for(i=0; i<length;i++){
				for(j=i; j<length;j++){
					if(consensus[i][j] > limit){
						//prob = 0.5 + ((double)consensus[i][j]/(double)antalSeq);
						write.println((i+1)+" "+(j+1)+" "+1.000+" ubox");
					}
				}
			}
			outf.close();

			FileWriter consaln = new FileWriter(".fold_out/"+outName+".refined.out",true);
			PrintWriter file = new PrintWriter( consaln );
			Pairwise pairw;
			score = 0;
			consensus = new int[length+5][length+5];
			temp = new Stack<Integer>();
			String txt = "";
			char[] seqArray;
			int[] tmp;
			ArrayList<int[]> gapList = new ArrayList<int[]>();
			//Check if gaps were inserted in the consensus sequence
			String[] redefseqs = new String[NN+1];
			String[] redefstrs = new String[NN+1];
			for(i=1; i<=NN;i++){
				pairw = new Pairwise(path+i+".out", ".fold_out/"+outName+".prob", ".fold_cons/"+i + ".out");
				seq = pairw.getSeqA();
				str = pairw.getStrA();
				seqB = pairw.getSeqB();
				redefseqs[i] = seq;
				redefstrs[i] = str;
				score += pairw.getScore();
				seqArray = seqB.toCharArray();
				for(j=0; j<seqArray.length; j++){
					if(seqArray[j]=='-'){
						int[] gaps = new int[2];
						gaps[0] = i;
						gaps[1] = j;
						gapList.add(gaps);
					}
				}
			}
			int seqWgap;
			int gap;

			for(i=1; i<=NN;i++){
				name = names[i-1];
				for(j=0;j<gapList.size();j++){
					tmp = gapList.get(j);
					seqWgap = tmp[0];
					gap = tmp[1];
					if(seqWgap != i){
						StringBuffer seqBuffer= new StringBuffer(redefseqs[i]);
						StringBuffer strBuffer= new StringBuffer(redefstrs[i]);
						seqBuffer.insert(gap, '-');
						strBuffer.insert(gap, '-');
						redefseqs[i] = seqBuffer.toString();
						redefstrs[i] = strBuffer.toString();
						
					}
				}
				seq = redefseqs[i];
				str = redefstrs[i];
				file.printf(FORMAT,name,seq);
				file.printf(FORMAT,name,str);
				
				seq = seq.toLowerCase();
				seqArray = seq.toCharArray();
					
				length = str.length();
				for(j=0; j<length;j++){
					if(str.charAt(j) == '('){
						temp.push(j);
						seqArray[j] = Character.toUpperCase(seq.charAt(j));
					}else if(str.charAt(j) == ')'){
						seqArray[j] = Character.toUpperCase(seq.charAt(j));
						//bp[temp.pop()] = i;
						popped = temp.pop();
						consensus[popped][j]++;
						consensus[j][popped]++;
					}
				}
				seq = "";
				for(int l=0;l<seqArray.length;l++){
					seq += seqArray[l];
				}
				txt += name +" "+seq+"\n";
			}
			file.print("#Total Score: "+score+"\tAverage Score: "+(score/NN)+"\tNormalized Score: "+(score/(NN*Math.log(length))));
			file.close();

			//To be able to output the col format

			if(GlobalParameters.col){
				limit = antalSeq/2;
				String pairingmask = "pairing_mask ";
				str = "";
				for(i=0; i<length;i++){
					str += '-';
				}
				seqArray = str.toCharArray();
				for(i=0; i<length;i++){
					for(j=i; j<length;j++){
						if(consensus[i][j] > limit){
							seqArray[i] = '(';
							seqArray[j] = ')';
						}
					}
				}
				str = "";
				temp = new Stack<Integer>();
				int pos = 1;
				int base = 0;
				boolean newStem = false;
				for(j=0; j<seqArray.length;j++){
					if(seqArray[j] == '('){
						if(newStem){
							base = temp.size();
							pos++;
							newStem = false;
						}
						temp.push(j);
					}else if(seqArray[j] == ')'){
						if(temp.size() == base){pos=0;}
						popped = temp.pop();
						seqArray[j] = chars[pos];
						seqArray[popped] = chars[pos];
						newStem = true;
					}
				}
				for(int l=0;l<seqArray.length;l++){
					pairingmask += seqArray[l];
				}
				FileWriter txtFile = new FileWriter(".fold_out/"+outName+".txt",false);
				file = new PrintWriter(txtFile);
				file.print(pairingmask+"\n"+txt);
				file.close();
				//String[] cmd;
				//cmd = new String[]{"/bin/sh","-c","./src/txt2col -m .fold_out/"+outName+".txt > .fold_out/"+outName+".col"};
				//String mkcol = "./src/txt2col -m .fold_out/"+outName+".txt > .fold_out/"+outName+".col";
				//Process mv = Runtime.getRuntime().exec(cmd);
				//mv.waitFor();
			}
		}
	}


	public static boolean match(char a, char b){
		boolean match =false;
		//System.err.println("Called with "+ a+" and "+b);
		switch (a) {
		case 'A': if(b=='U' || b=='u'){match = true;}break;
		case 'a': if(b=='U' || b=='u'){match = true;}break;
		case 'U': if(b=='A' || b=='a'){match = true;}break;
		case 'u': if(b=='A' || b=='a'){match = true;}break;
		case 'C': if(b=='G' || b=='g'){match = true;}break;
		case 'c': if(b=='G' || b=='g'){match = true;}break;
		case 'G': if(b=='C' || b=='c' || b=='U' || b=='u'){match = true;}break;
		case 'g': if(b=='C' || b=='c' || b=='U' || b=='u'){match = true;}break;
		default: match = false; break;
		}
		//System.err.println("Returning false");
		return match;
	}
}
