package src;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;

public final class Output {
	//This outputs the consensus sequence and the probabilty matrix to a given file
	//private double[][] ubox;
	public Output(double[][] pm, String aseq, String bseq, String outFile) throws IOException{
		//String FORMAT = "%d %d %-4d ubox";
		final Locale loc = new Locale("en","US");
		final NumberFormat nf = NumberFormat.getNumberInstance(loc);
		final DecimalFormat myFormatter = (DecimalFormat) nf;
		myFormatter.applyPattern("#.######");
		String seq = "";
		String out="";
		final HashMap<String,String> ry = new HashMap<String,String>();
		ry.put("A","R"); ry.put("G","R"); ry.put("R","R");
		ry.put("U","Y"); ry.put("C","Y");
		ry.put("Y","Y"); ry.put("T","Y");
		for(int p=0; p<aseq.length(); p++){
			final String a = aseq.substring(p,p+1);
			final String b = bseq.substring(p,p+1);
			if ((a.equals(b)) || ("-".equals(b))) {
				seq += a;
			} else if ("-".equals(a)) {
				seq += b;
			} else if (ry.containsKey(a) && ry.containsKey(b) && ry.get(a).equals(ry.get(b))) { 
				seq += ry.get(a);
			} else {
				seq += 'N';
			}
		}
		out += "Sequence:" + seq + "\n";
		//sequence = seq;
		//ubox = new double[aseq.length()][aseq.length()];
		for(int i=0; i<pm.length;i++){
			final double[] temp = pm[i];
			for(int j=0; j<temp.length;j++){
				if(pm[i][j] != 0.0){
					if(pm[i][j] == 1.0){
						out += i +" " + j + " 1.0000 ubox\n";
					}else{
					//ubox[i][j] = pm[i][j];
					//out += i + " " + j + " " + pm[i][j] + " ubox\n"; 
						out += i +" " + j + " " + myFormatter.format(pm[i][j]) + " ubox\n";
					}
				}
			}
		}
		writeToFile(out, outFile);
	}
	
	public static void writeToFile(String data,String name) throws IOException{
		final File cOutFile = new File(name);
		if (cOutFile.exists()) {
			cOutFile.delete();
		}
		if (cOutFile.createNewFile()) {
		}
		final FileWriter cOutFileWriter = new FileWriter(cOutFile);
		cOutFileWriter.write(data);
		cOutFileWriter.flush();
		cOutFileWriter.close();
	}
}
