package src;
public final class PairAlignment {
	/*This contains 
	 * @param im = ID for sequence I
	 * @param jm = ID for sequence J
	 * @param k = ID for the pairwise alignment of I and J
	 * @param ali = An array with the sequences and structures for I and J
	 * @param score = score for the alignment
	 */
	private int k = 0;
	private int im = 0;
	private int jm = 0;
	private String[] ali;
	private int score = 0;

	public PairAlignment(final int k, final int im, final int jm, final String[] ali, int score){
		this.k = k;
		this.im = im;
		this.jm = jm;
		this.ali = ali;
		this.score = score;
	}
	
	/**
	 * @return Returns the ali.
	 */
	final public String[] getAli() {
		return ali;
	}
	/**
	 * @param ali The ali to set.
	 */
	public void setAli(final String[] ali) {
		this.ali = ali;
	}
	/**
	 * @return Returns the im.
	 */
	final public int getIm() {
		return im;
	}
	/**
	 * @param im The im to set.
	 */
	public void setIm(final int im) {
		this.im = im;
	}
	/**
	 * @return Returns the jm.
	 */
	final public int getJm() {
		return jm;
	}
	/**
	 * @param jm The jm to set.
	 */
	public void setJm(final int jm) {
		this.jm = jm;
	}
	/**
	 * @return Returns the k.
	 */
	final public int getK() {
		return k;
	}
	/**
	 * @param k The k to set.
	 */
	public void setK(final int k) {
		this.k = k;
	}

	/**
	 * @return Returns the score.
	 */
	public final int getScore() {
		return score;
	}

	/**
	 * @param score The score to set.
	 */
	public final void setScore(int score) {
		this.score = score;
	}	
}
