package src;
import java.util.ArrayList;


public final class PmCompLocal{
	private int prune = -300;
	private short lengthA = 0;
	private short lengthB = 0;
	private short delta = 0;
	private short gap = 0;
	private String seqA = null;
	private String seqB = null;
	//private ArrayList[] sc1trim,sc2trim;
	private boolean nolog = false;
	//private double ss,d=0.0;
	private short[][] substitution;
	private LongTermMemory LTM = null;
	private ShortTermMemory STM = null;
	private double[][] sc1;
	private double[][] sc2;
	BacktrackNew bt = null;
	//The relX parameters are relative sequence positions
	//The realX parameters are the real sequence positions
	
	public PmCompLocal(final Parameters p){
		lengthA = p.getLengthA();
		lengthB = p.getLengthB();
		delta = GlobalParameters.delta;
		this.prune *= 15;
		gap = GlobalParameters.gap;
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		//sc1trim = p.getSc1trim();
		//sc2trim = p.getSc2trim();
		nolog = GlobalParameters.nolog;
		//S = new double[2][][][];
		substitution = GlobalParameters.getMatrix();
		//ArrayList<Segments> seg = new ArrayList<Segments>();
		sc1 = p.getSc1();
		sc2 = p.getSc2();
	}
	
	public int[] initialize(){
		int counter=0;
		int maxScore = -100000;
		int[] maxCoord = new int[4];
		final short delta = this.delta;
		final int lengthA = this.lengthA;
		final int lengthB = this.lengthB;
		final char[] seqAA = seqA.toCharArray();
		final char[] seqBA = seqB.toCharArray();
		final int prune = this.prune;
		STM = new ShortTermMemory(delta,0);
		STM.setSTM(2,lengthA+1,lengthB+1,(2*delta)+3);
		LTM = new LongTermMemory(lengthA+1,lengthB+1,delta,0);
		//final HashMap<String,Integer> MBL = new HashMap<String,Integer>();
		for(int i=lengthA; i>0; i--){
			STM.set_I_Position(i);
			for(int k=lengthB; k>0; k--){
				//if ((i-k) > delta){break;}
				//if ((k-i) > delta){continue;}
				for(int j=i; j<=lengthA; j++){		
					for(int l=k; l<=lengthB; l++){	
						//if((lengthA-j)-(lengthB-l)>delta+1){break;}
						//if((lengthB-l)-(lengthA-j)>delta+1){continue;}
						if (((l-k)-(j-i)) > delta){break;}
						if (((j-i)-(l-k))> delta){continue;}
						//if ((i-k) > delta){break;}
						//if ((k-i) > delta){continue;}
						if(i==j && k==l){
							STM.putLocal(i,j,k,l,0,'V');
						}
						int ik = 0;
						int jl = 0;
						int J = 0;
						int L = 0;
						final ShortCell scell = STM.getCellLocal(i,j,k,l);
						if(scell==null){counter++;continue; }
						//final int currPos = STM.getScoreLocal(i,j,k,l);
						final int currPos = scell.getScore();
						final char state = scell.getState();
						char overState = '\0';
						if(state == 'V'){overState='V';}else{overState='H';}
						//System.out.println("Score: "+i+" "+j+" "+k+" "+l+" "+currPos);
						if(currPos > maxScore){
							maxScore = currPos; 
							maxCoord[0] = i;
							maxCoord[1] = j;
							maxCoord[2] = k;
							maxCoord[3] = l;
							//maxCoord = ""+i+","+j+","+k+","+l;
							//System.out.println(maxScore +"  "+maxCoord);
						}
						
						if(state == 'P'){
							LTM.putLocal(i,j,k,l,currPos,state);
						}	
						
						if(i>1 && k>1){
							ik = seq_score(seqAA[i-2],seqBA[k-2]) + currPos;
							//System.out.println("Score: "+i+" "+j+" "+k+" "+l+" "+ik+" "+seqAA[i-2]+" "+seqBA[k-2]);
							if(ik>STM.getScoreLocal(i-1,j,k-1,l) && ik>prune){
								STM.putLocal(i-1,j,k-1,l,ik,'V');
							}
						}	
						if(i>1){
							ik = currPos+gap;
							if(ik>STM.getScoreLocal(i-1,j,k,l) && ik>prune){STM.putLocal(i-1,j,k,l,ik,'V');}
						}
						if(k>1){
							ik = currPos+gap;
							if(ik>STM.getScoreLocal(i,j,k-1,l)&& ik>prune){STM.putLocal(i,j,k-1,l,ik,'V');}
						}
						
						if(j<lengthA && l<lengthB){
							jl = seq_score(seqAA[j],seqBA[l]) + currPos;
							if(jl>STM.getScoreLocal(i,j+1,k,l+1) && jl>prune){
								if(state == 'M' || state == 'W' || state == 'P'){
									STM.putLocal(i,j+1,k,l+1,jl,'W');
								}else{
									STM.putLocal(i,j+1,k,l+1,jl,'V');
								}
							}						
						}
						if(j<lengthA){
							jl = currPos+gap;
							if(jl>STM.getScoreLocal(i,j+1,k,l) && jl>prune){
								if(state == 'M' || state == 'W' || state == 'P'){
									STM.putLocal(i,j+1,k,l,jl,'W');
								}else{
									STM.putLocal(i,j+1,k,l,jl,'V');
								}
							}
						}
						if(l<lengthB){
							jl = currPos+gap;
							if(jl>STM.getScoreLocal(i,j,k,l+1) && jl>prune){
								if(state == 'M' || state == 'W' || state == 'P'){
									STM.putLocal(i,j,k,l+1,jl,'W');
								}else{
									STM.putLocal(i,j,k,l+1,jl,'V');
								}
							}
						}						
						
						if(overState == 'H'){
							//if(j<lengthA && l<lengthB && Math.abs(j-l) < delta+2){
							if(j<lengthA && l<lengthB){
							final ArrayList<LongCell> cells = LTM.getListLocal(j+1,l+1);
								if(cells != null){
									for(int x=0; x<cells.size(); x++){
										J = cells.get(x).getJ();
										L = cells.get(x).getL();
										final int LTMScore = cells.get(x).getScore();
										if(Math.abs((L-k)-(J-i))<delta+1 && cells.get(x).getState()=='P'){
											if(LTMScore+currPos > STM.getScoreLocal(i,J,k,L) && (LTMScore+currPos)>prune){
												STM.putLocal(i,J,k,L,(LTMScore+currPos),'M');
											}
										}
									}
								}
							}
						}
						if(j<lengthA && l<lengthB && i>1 && k>1 && j-i>1 && l-k>1){
							//if ((((l+1)-(k-1))-((j+1)-(i-1)))>delta){break;}
							//if (((j-h)-(l-q))>delta){break;}
							if(sc1[i-1][j+1] == 0.0){
								continue;
							}
							//for(int q=k+4; q<=l; q++){
							if(sc2[k-1][l+1] == 0.0){
								continue;
							}		
							Double sm = (nolog ? (2*(sc1[i-1][j+1]*sc2[k-1][l+1])) : sc1[i-1][j+1]+sc2[k-1][l+1]);
							sm *= 100;
							int sc = sm.intValue();
							sc += currPos; //!!! + (k-k)*gap;
							
							if(sc>STM.getScoreLocal(i-1,j+1,k-1,l+1) && sc>prune){
								//System.out.println("BP: "+(i-1)+" "+(j+1)+" "+(k-1)+" "+(l+1)+"  "+sm);		
								STM.putLocal(i-1,j+1,k-1,l+1,sc,'P');
							}
						}
					}
				}
			}
			if(i!=1){
				STM.transfer();
			}
		}
		System.out.println("Locally pruned cells = "+counter);
		System.out.println("Local coordinates: "+maxCoord[0] +" "+maxCoord[1]+" "+maxCoord[2]+" "+maxCoord[3] + " : "+ maxScore);
		return maxCoord;
	}
	
	public short seq_score(final char a, final char b){
		//if(a == b){return seqw;}else{return 0;}
		int x = GlobalParameters.charToInt(a);
		int y = GlobalParameters.charToInt(b);
		return substitution[x][y];
	}
}