#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# STDPAIR3
#
# Ebbe Sloth Andersen, 2007.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &stdpair ( $entries );
$header .= "; stdpair3 was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub stdpair
{
    # Ebbe Sloth Andersen, July 2005.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my (  $entry, 
          @align_bp, 
          @residue, 
          $i, 
          $residue,
          @alignpos, 
          $length, 
          $n, 
          $gap, 
          @labpos, 
          $here, 
          $there,
          @align_bp1, 
          $align_bp, 
          $count, 
          $lab, 
        );
    

    foreach $entry ( @{ $entries } ) {
        if ( $entry->{'TYPE'} eq "pairingmask" ) {
            @align_bp = ( );
            @residue = ( );
            @residue = split(/,/, $entry->{'residue'});
            @alignpos = ( );
            @alignpos = split ( /,/, $entry->{'alignpos'} );
            $length = scalar @residue;
            $n = 0;
            $a = 0;
            $gap = 0;
            foreach $residue ( @residue ) {
                if ( $residue eq "-" or $residue eq "." ) {
                    push @align_bp, ".";
                    $gap++;
                } else {
                    # push positions of current label
                    @labpos = ( );
                    for ( $i = 0; $i < $length; $i++ ) {  
                        if ( $residue[$i] eq $residue ) {
                            push ( @labpos, $alignpos[$i] );
                        }
                    }
                    # where are we in the array?
                    $here = $alignpos[$a];
                    $count = 0;
                    foreach $lab ( @labpos ) {
                        if ( $lab == $here ) {
                            last;
                        }
                        $count++;
                    }
                    # now get the symmetrical position
                    $there = scalar @labpos - $count;
                    push @align_bp, "$labpos[$there-1]";
                }
                $a++;
            }
        }
        if ( $entry->{'TYPE'} eq "RNA" ) {
            @residue = ( );
            @residue = split(/,/, $entry->{'residue'});
            @align_bp1 = ( );
            @align_bp1 = @align_bp;
            $i = 0;
            foreach $residue ( @residue ) {
                $residue = uc($residue);
            }
            foreach $residue ( @residue ) {
                if ( $align_bp[$i] eq "." ) {
                    $residue = lc( $residue );
                } else {
                    if ( $residue eq "A" && $residue[$align_bp[$i]-1] eq "U" ) {
                    } elsif ( $residue eq "U" && $residue[$align_bp[$i]-1] eq "A" ) {
                    } elsif ( $residue eq "G" && $residue[$align_bp[$i]-1] eq "C" ) {
                    } elsif ( $residue eq "C" && $residue[$align_bp[$i]-1] eq "G" ) {
                    } elsif ( $residue eq "G" && $residue[$align_bp[$i]-1] eq "U" ) {
                    } elsif ( $residue eq "U" && $residue[$align_bp[$i]-1] eq "G" ) {
                    } else {
                        $residue = lc( $residue );
                        $align_bp1[$align_bp[$i]-1] = ".";
                        $align_bp1[$i] = ".";
                    }
                }
                $i++;
            }
            $entry->{'residue'} = join(",", @residue);
            $entry->{'align_bp'} = join(",", @align_bp1);
            $entry->{'alignpos'} = join(",", @alignpos);
        }
    }
    return $entries;
}
