#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# Ebbe Sloth Andersen, July 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;

( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &group_colors ( $entries );
$header .= "; reliability_colors.pl was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub group_colors
{
    # Ebbe Sloth Andersen, July 2005.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my ( @rna,
	 $rna,
	 @rnas,
	 $pm,
         @pm,
	 @pms,
	 @bps,
	 $bp,
         $i,
         $n,
         %colors,
         @color,
         $color,
         $prev,
         $prev2,
         $length,
         @labels,
         $label,
         @colo,
         $find,
         @colormask,
         $entry,
         @overlap, 
         $overlap,
         @stem,
         $stem,
         $align_bp,
         $reliability,
         @reliability,
         $m,
         @group,
         $group,
         @residue,
         $residue,
         @alignpos,
         @align_bp,
         $x,
         $lab,
         @lab,
         @paren,
         $z,
         @pairingmask,
         );
 
    # Define colors
    %colors = (
	       "red1"        => [1.00, 0.50, 0.50],
	       "red2"        => [1.00, 0.70, 0.70],
	       "red3"        => [1.00, 0.90, 0.90],

	       "orange1"     => [1.00, 0.70, 0.50],
	       "orange2"     => [1.00, 0.80, 0.70],
	       "orange3"     => [1.00, 0.90, 0.80],

	       "yellow1"     => [1.00, 1.00, 0.50],
	       "yellow2"     => [1.00, 1.00, 0.70],
	       "yellow3"     => [1.00, 1.00, 0.90],

	       "green1"      => [0.50, 1.00, 0.50],
	       "green2"      => [0.70, 1.00, 0.70],
	       "green3"      => [0.90, 1.00, 0.90],

	       "cyan1"       => [0.50, 1.00, 1.00],
	       "cyan2"       => [0.70, 1.00, 1.00],
	       "cyan3"       => [0.90, 1.00, 1.00],

	       "blue1"       => [0.50, 0.50, 1.00],
	       "blue2"       => [0.70, 0.70, 1.00],
	       "blue3"       => [0.90, 0.90, 1.00],

	       "grey1"       => [0.70, 0.70, 0.70],
	       "grey2"       => [0.80, 0.80, 0.80],
	       "grey3"       => [0.90, 0.90, 0.90],
	       );

    # array of colors
    @color = ( 
               "green1","green2","green3",
               "cyan1","cyan2","cyan3", 
               "blue1","blue2","blue3", 
			   "red1","red2","red3", 
               "orange1","orange2","orange3",
               "yellow1","yellow2","yellow3",
#               "grey1","grey2","grey3", 
               );
    
# make paint

    $i = -3;
    $m = 1;
    $z = 1;
    foreach $entry ( @{ $entries } ) {
        @bps = ( );
        @bps = split(/,/, $entry->{'residue'});
        @reliability = ( );

        
        if ( $i >= 15 ) { $i = -3; }
        if ( $entry->{'ENTRY'} =~ /^SS_\d/ or $entry->{'TYPE'} =~ /^pairingmask/  ) {
            $i++; $i++; $i++;
            @pairingmask = ( );
            @pairingmask = @bps;
        }
        if ( $entry->{'TYPE'} eq "RNA" ) {

            $entry->{'color_r'} = "";
            $entry->{'color_g'} = "";
            $entry->{'color_b'} = "";
            
            $n = 0; 
            @reliability = split(/,/, $entry->{'certainty'});
            foreach $bp ( @bps ) {
                if ( $bp eq "-" ) {
                    $entry->{'color_r'} .= "1.00,";
                    $entry->{'color_g'} .= "1.00,";
                    $entry->{'color_b'} .= "1.00,";
                } else {
                    if ( $pairingmask[$n] eq "-" ) {
                        if ( $bp =~ /^(t|a|u|g|c)/ ) {
                            $color = "grey1";
                            if ( $reliability[$n] < 0.9 ) { $color = "grey2"; }
                            if ( $reliability[$n] < 0.7 ) { $color = "grey3"; }
                            $entry->{'color_r'} .= "$colors{$color}[0],";
                            $entry->{'color_g'} .= "$colors{$color}[1],";
                            $entry->{'color_b'} .= "$colors{$color}[2],";	       
                    } else {
                        if ( $reliability[$n] > 0.9 ) { $i++; }
                        if ( $reliability[$n] > 0.7 ) { $i++; }
                        $color = $color[$i];
                        $entry->{'color_r'} .= "$colors{$color}[0],";
                        $entry->{'color_g'} .= "$colors{$color}[1],";
                        $entry->{'color_b'} .= "$colors{$color}[2],";      
                        if ( $reliability[$n] > 0.9 ) { $i--; }
                        if ( $reliability[$n] > 0.7 ) { $i--; }
                    } 
                    } else {
                        if ( $bp =~ /^(t|a|u|g|c)/ ) {
                            $color = "grey3";
                            if ( $reliability[$n] < 0.9 ) { $color = "grey2"; }
                            if ( $reliability[$n] < 0.7 ) { $color = "grey1"; }
                            $entry->{'color_r'} .= "$colors{$color}[0],";
                            $entry->{'color_g'} .= "$colors{$color}[1],";
                            $entry->{'color_b'} .= "$colors{$color}[2],";	       
                        } else {
                            if ( $reliability[$n] < 0.9 ) { $i++; }
                            if ( $reliability[$n] < 0.7 ) { $i++; }
                            $color = $color[$i];
                            $entry->{'color_r'} .= "$colors{$color}[0],";
                            $entry->{'color_g'} .= "$colors{$color}[1],";
                            $entry->{'color_b'} .= "$colors{$color}[2],";      
                            if ( $reliability[$n] < 0.9 ) { $i--; }
                            if ( $reliability[$n] < 0.7 ) { $i--; }
                        }                     
                    }
                }
                $n++;
            }
        }
        $z++;
    }
    return $entries;
}
