#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings;
use Data::Dumper;

# ALN2COL converts the aln widetxt format into widetxt format. 
# Ebbe Sloth Andersen, August 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<

my ( @entries, $entry, $count, $length, $i, $aln_file );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_aln ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &ali_shade ( $entries );
@entries = &add_pm ( @entries );
@entries = &t2u ( @entries );
$header .= "; ali_shade.pl was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub t2u
{
    # Ebbe Sloth Andersen, September 2005.

    my ( @entries ) = @_;

    my ( $entry, @residue, $residue, $seq, @rnas );

    @rnas = ( );
    @rnas = grep { $_->{'TYPE'} eq "RNA" } @entries;

    foreach $entry ( @rnas ) {
        @residue = split(//, $entry->{'residue'});
        $seq = "";
        foreach $residue ( @residue ) {
            if ( $residue eq "T" ) {
                $seq .= "u";
            } else {
                $seq .= lc($residue);                
            }
        }
        $entry->{'residue'} = $seq;
    }
    return @entries;
}

sub add_pm
{
    # Ebbe Sloth Andersen, September 2005.

    my ( @entries ) = @_;

    my ( $entry, @residue, $residue, $pm );

    $pm = "";

    $entry = $entries[0];
    
    @residue = split(//, $entry->{'residue'});

    foreach $residue ( @residue ) {
        $pm .= "-";
    }

    unshift @entries,
    {
        "ENTRY" => "pairingmask",
        "TYPE" => "pairingmask",
        "residue" => "$pm",
    };

    return @entries;
}

