package Formats;

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;

# read_col
# write_col
# write_ali
# write_ct
# write_cts
# write_list
# read_txt
# write_txt
# read_aln

sub read_col
{
    # Ebbe Sloth Andersen, December 2004.

    # READ_COL v1.1: Reads column format into data structure with an array of hashes.
    # Reads any number of columns with any kind of data.
   
    my ( $fname ) = @_;

    # Returns an array of hashes. The key corresponds to the header.
    # The value contains body data points seperated by comma.

    my ( $line,        # input lines
	 @entries,     # the output array of hashes
	 @cols, 
	 $TYPE,        
	 @COL,         # any number of columns
	 $ENTRY, 
	 @data, 
	 $i,           # counting numbers
	 $length,
	 $counter,
        $header,
         $get,
		@RNA,
		@SS,
		$prog_name,
        );

    # initialize
    $get = "";	    
    $counter = 0;	    
    @data = ( );
    @entries = ( );
    @COL = ( );

    if ( not open FILE, "< $fname" ) {
		die "file not found!";
    }

    while ( $line = <FILE> )
    {
	if ( $line =~ /^; \=+/ )            # finds header
	{
            $header = $get;
	}
	elsif ( $line =~ /^; \*+/ )            # finds footer
	{
	    push @entries, 
	    {
		"TYPE" => $TYPE,
		"ENTRY" => $ENTRY,
	    };
		
	    if ( $TYPE eq "TREE" ) {         # this must be done
		shift ( @data );             # because of wierd
		$length = 6;                 # spacing in TREE file
	    }

	    for ( $i=0; $i<$length; $i++ ) {
		map { $entries[$counter]->{$COL[$i]} = $data[$i] } @entries;
	    }
	    $counter = $counter + 1;
	    @data = ( );
	    @COL = ( );
	}
	elsif ( $line =~ /^;/ )            # reads col names
	{
	    if ( $line =~ /^; TYPE\s+(\S+)/ ) {
		$TYPE = $1;
	    } elsif ( $line =~ /^; COL\s+\S+\s+(\S+)/ ) {
		push ( @COL, $1 );
	    } elsif ( $line =~ /^; ENTRY\s+(\S+)/ ) { 
		$ENTRY = $1;
            } else {
                $get .= "$line";
            }            
        }
	else                               # reads body
	{
	    @cols = split(/\s+/, $line);
	    $length = scalar @cols;

	    # add sequences on an array

	    for ( $i=0; $i<$length; $i++ ) {
		$data[$i] .= "$cols[$i],";
	    }
	}   
    } 
    close FILE;

    return ( $header,  \@entries );
}

sub write_col
{
    # Ebbe Sloth Andersen, December 2004. Modified April 2005.

    # WRITE_COL_v2: outputs column file.

    my ( $header, 
         $entries ) = @_;

    # Returns nothing.

    my ( $entry,
	 $n,
	 $label,
	 @label,       # general variables 
	 @residue,
	 $residue,
	 @seqpos,
	 @alignpos,
	 @align_bp,
	 @certainty,
	 @color_r, 
	 @color_g, 
	 @color_b, 
	 @number,      # special TREE variables 
	 @name,
	 @uplen,
	 @child,
	 @brother,
 	 );

    # print header
    print "; $header \n";
    print "; ========== \n";
    
    # write sequences and masks
    foreach $entry ( @{ $entries } )
    { 
	# print header
	print "; TYPE\t$entry->{'TYPE'}\n";
	$n = 1;
	if ( defined $entry->{'label'} )     { print "; COL $n\tlabel\n"; $n++; }
	if ( defined $entry->{'residue'} )   { print "; COL $n\tresidue\n"; $n++; }
	if ( defined $entry->{'seqpos'} )    { print "; COL $n\tseqpos\n"; $n++; }
	if ( defined $entry->{'alignpos'} )  { print "; COL $n\talignpos\n"; $n++; }
	if ( defined $entry->{'align_bp'} )  { print "; COL $n\talign_bp\n"; $n++; }
	if ( defined $entry->{'certainty'} ) { print "; COL $n\tcertainty\n"; $n++; }
	if ( defined $entry->{'color_r'} )   { print "; COL $n\tcolor_r\n"; $n++; }
	if ( defined $entry->{'color_g'} )   { print "; COL $n\tcolor_g\n"; $n++; }
	if ( defined $entry->{'color_b'} )   { print "; COL $n\tcolor_b\n"; $n++; }
	if ( defined $entry->{'number'} )    { print "; COL $n\tnumber\n"; $n++; }
	if ( defined $entry->{'name'} )      { print "; COL $n\tname\n"; $n++; }
	if ( defined $entry->{'uplen'} )     { print "; COL $n\tuplen\n"; $n++; }
	if ( defined $entry->{'child'} )     { print "; COL $n\tchild\n"; $n++; }
    	if ( defined $entry->{'brother'} )   { print "; COL $n\tbrother\n"; $n++; }
	print "; ENTRY\t" . substr $entry->{'ENTRY'}, 0, 30; print "\n";
	if ( $entry->{'TYPE'} eq "TREE" ) { print "; root\t1\n"; }
	print "; ----------\n";
	
	# empty arrays
	@label = ( );
	@residue = ( );
	@seqpos = ( );
	@alignpos = ( );
	@align_bp = ( );
	@certainty = ( );
	@color_r = ( );
	@color_g = ( );
	@color_b = ( );
	@number = ( );
	@name = ( );
	@uplen = ( );
	@child = ( );
	@brother = ( );

        # split hashes
	if ( defined $entry->{'label'} )     { @label = split(/,/, $entry->{'label'}); }
	if ( defined $entry->{'residue'} )   { @residue = split(/,/, $entry->{'residue'}); }
	if ( defined $entry->{'seqpos'} )    { @seqpos = split(/,/, $entry->{'seqpos'}); }
	if ( defined $entry->{'alignpos'} )  { @alignpos = split(/,/, $entry->{'alignpos'}); }
	if ( defined $entry->{'align_bp'} )  { @align_bp = split(/,/, $entry->{'align_bp'}); }
	if ( defined $entry->{'certainty'} ) { @certainty = split(/,/, $entry->{'certainty'}); }	 
	if ( defined $entry->{'color_r'} )   { @color_r = split(/,/, $entry->{'color_r'}); }
	if ( defined $entry->{'color_g'} )   { @color_g = split(/,/, $entry->{'color_g'}); }
	if ( defined $entry->{'color_b'} )   { @color_b = split(/,/, $entry->{'color_b'}); }
	if ( defined $entry->{'number'} )    { @number = split(/,/, $entry->{'number'}); }
	if ( defined $entry->{'name'} )      { @name = split(/,/, $entry->{'name'}); }
	if ( defined $entry->{'uplen'} )     { @uplen = split(/,/, $entry->{'uplen'}); }
	if ( defined $entry->{'child'} )     { @child = split(/,/, $entry->{'child'}); }
	if ( defined $entry->{'brother'} )   { @brother = split(/,/, $entry->{'brother'}); }
	
        # print sequence
	$n = 0;    
	
	foreach $residue ( @residue ) 
	{
	    if ( defined $entry->{'label'} )     { print "$label[$n]\t"; }
	    if ( defined $entry->{'residue'} )   { print "$residue[$n]\t"; }
	    if ( defined $entry->{'seqpos'} )    { print "$seqpos[$n]\t"; }
	    if ( defined $entry->{'alignpos'} )  { print "$alignpos[$n]\t"; }
	    if ( defined $entry->{'align_bp'} )  { print "$align_bp[$n]\t"; }
	    if ( defined $entry->{'certainty'} ) { print "$certainty[$n]\t"; }
	    if ( defined $entry->{'color_r'} )   { print "$color_r[$n]\t"; }
	    if ( defined $entry->{'color_g'} )   { print "$color_g[$n]\t"; }
	    if ( defined $entry->{'color_b'} )   { print "$color_b[$n]\t"; }
	    if ( defined $entry->{'number'} )    { print "$number[$n]\t"; }
	    if ( defined $entry->{'name'} )      { print "$name[$n]\t"; }
	    if ( defined $entry->{'uplen'} )     { print "$uplen[$n]\t"; }
	    if ( defined $entry->{'child'} )     { print "$child[$n]\t"; }
	    if ( defined $entry->{'brother'} )   { print "$brother[$n]\t"; }
	    print "\n";
	    $n++;
	}
	
        # print footer
	print "; **********\n";
    }
}

sub write_ali
{
    # WRITE_ALI v.1 

    my ( @entries ) = @_;

    # Returns nothing.

    my ( $entry,
	 @rnas,
	 $rna,
	 $n,
	 $i,
	 $residue,
	 @residue,
         @pm,
         $pm,
         @pmres,
         $length,
         $prev,     # for individual structures 
         $m, 
         @m, 
         $pmres, 
         $bulge, 
         $stem, 
         $bpn, 
         $labels, 
         $loop,
         @r, 
         @g, 
         @b, 
         $color,
	 );

    # get pairingmask
    @pm = grep { $_->{'TYPE'} eq "pairingmask" } @entries;
    $pm = $pm[0]; 
    @pmres = split(/,/, $pm->{'residue'});
    # get RNAs
    @rnas = grep { $_->{'TYPE'} eq "RNA" } @entries;
    $entry = $rnas[0]; 
    @residue = split(/,/, $entry->{'residue'});
    $length = scalar @residue;
    # write header
    print "           1         $length\n\n";
    # write numbers
    $n = 0;
    for ( $i=0; $i<=$length; $i++ ) {
	if ( $i >= 10000 ) {
	    if ( $n == 10 ) {
		print "               $i";
		$n=0;
	    }
	    $n++;
	} elsif ( $i >=1000 ) {
	    if ( $n == 10 ) {
		print "                $i";
		$n=0;
	    }
	    $n = $n + 1;
	} elsif ( $i >=100 ) {
	    if ( $n == 10 ) {
		print "                 $i";
		$n=0;
	    }
	    $n = $n + 1;
	} else {
	    if ( $n == 10 ) {
		print "                  $i";
		$n=0;
	    }
	    $n = $n + 1;
	}
    }
    print "\n";
    # write ruler
    $n = 0;
    for ( $i=0; $i<$length; $i++ ) {
	if ( $n < 4 ) { print " ."; }
	if ( $n == 4 ) { print " |"; }
        if ( $n == 4 ) { $n = -1; }
        $n++;
    }
    print "\n";

    # write rna structures
    foreach $entry ( @rnas )
    { 

	# empty arrays
	@residue = ( );

        # split hashes
	if ( defined $entry->{'residue'} )   { @residue = split(/,/, $entry->{'residue'}); }

        # print aligned rna structures
        $prev = "-";
        $stem = "false";
        $loop = 0;
        $bulge = "false";
        $n = 0;
        $m = 0;
        $bpn = 0;
        $labels = 0;
        $length = 0;
        
	foreach $residue ( @residue ) {

            if ( $pmres[$n] eq $prev && $labels == $loop/2 ) {
                $prev = "";;
            }

            # if new label or label shift
            if ( $pmres[$n] ne $prev && $pmres[$n] ne "-" ) {

                $bpn = 0; # restart base count
                $m = 0;   # restart base count
                $labels = 0;

               # get amount of labels in current stem
                @m = ( );
                @m = grep { $_ eq $pmres[$n] } @pmres;
                $length = scalar @m;
                $loop = $length;
         
                # count paired bases in this stemside
                for ($i=$n;$i<$length/2+$n;$i++) {
                    if ( $pmres[$i] =~ /^[-]/ ) {
                        $length = $length + 2;
                    } else {
                        if ( $residue[$i] =~ /^[AUCGT]/ ) {
                            $bpn++;
                        }
                    }
                }        
            }

            # make history and count labels
            if ( $pmres[$n] ne "-") {
                $prev = $pmres[$n];
                $labels++;
            }

            # insert symbols inbetween
            if ( $residue[$n] =~ /^[AUCGT]/ ) {
                if ( $m == 0 ) { # and new stemside
                    if ( $residue[$n-1] =~ /^[AUCGT]/ && $n != 0 ) {
                        print "\^"; $stem = "true";
                    } else {
                        print "\["; $stem = "true";
                    }   
                } elsif ( $residue[$n-1] =~ /^[aucgt]/ ) {
                   print "\}"; $bulge = "false";                 
                } else {
                    print " ";
                }
                $m++;
            } else { # if gap or unpaired
                if ( $m == 0 ) { # and new stem
                    if ( $residue[$n-1] =~ /^[AUCGT]/ && $n != 0 ) { # and previous was stem
                        print "\]";  $stem = "false";
                   } else {
                       print " ";
                   }
                } elsif ( $m == $bpn && $m != 0 && $stem eq "true" ) { # or end of stem
                    print "\]"; $stem = "false"; $bulge = "false";
                } elsif ( $stem eq "true" && $bulge eq "false" && $residue[$n] =~ /^[aucgt]/ ) {
                    print "\{"; $bulge = "true";
                } elsif ( $residue[$n] eq "-" && $bulge eq "true" ) { # end stem
                    print "\}"; $bulge = "false";
                } elsif ( $residue[$n] eq "-" && $residue[$n+1] eq "-" && $bulge eq "true" ) { # end stem
                    print "\}"; $bulge = "false";
                } else {
                    print " "; 
                }
            }
            
            # print sequence
	    # if ( defined $entry->{'residue'} ) { print "$residue[$n]"; }
            if ( defined $entry->{'residue'} ) { print uc("$residue[$n]"); }
            $n++;
	}
        if ( $m == $bpn && $m != 0 && $stem eq "true" ) { # end stem
            print "\]"; $stem = "false"; $bulge = "false";
        } else {
            print " ";
        }
        print "      $entry->{'ENTRY'}\n";        
    }

    # write helix numbers
    # get pairingmask and write each time you reach a helix
    my ( $l, $one, $stemstart, $symbol, $o );
    $prev = "-";
    $one = "false";
    $stem = "false";
    $l = scalar @residue;
    for ($n=0;$n<$l;$n++) {
        # analyse
        if ( $pmres[$n] ne $prev && $pmres[$n] ne "-" ) {
            # get amount of labels in current stem
            $one = "false";
            $stem = "true";
            @m = ( );
            @m = grep { $_ eq $pmres[$n] } @pmres;
            $length = scalar @m;
            $stemstart = $n;
            $symbol = $pmres[$n];
            # estimate length of stemside
            for ($i=$n;$i<$length/2+$n;$i++) {
                if ( $pmres[$i] eq "-" ) {
                    $length = $length + 2;
                }
            }
            for ($m=0;$m<$l;$m++) {
                if ( $pmres[$m] eq $symbol ) {
                    $o = $m;
                }
            }
            # $o er sidste symbol, $n fra og $i til
        }

        # make history
        if ( $pmres[$n] ne "-") {
            $prev = $pmres[$n];
        }        

        # print something
        if ( $n > $length/4 + $stemstart - 1 && $one eq "false" && $stem eq "true" ) {
            if ( $i >= $o ) {
                print "$symbol'";
            } else {
                print " $symbol";
            }                
            $one = "true";
        } elsif ( $n == $length/2 + $stemstart ) {
            $prev = "-";
            print " -";
            $one = "false";
            $stem = "false";
            $stemstart = 0;
        } else {
            print " -";
        }
    }
    print "  H    Helix numbering\n";

    # get colors from last sequence and write color mask
    $color = "";
    $i = 0;
    @r = ( );
    @g = ( );
    @b = ( );
    if ( defined $pm->{'color_r'} )   { @r = split(/,/, $pm->{'color_r'}); }
    if ( defined $pm->{'color_g'} )   { @g = split(/,/, $pm->{'color_g'}); }
    if ( defined $pm->{'color_b'} )   { @b = split(/,/, $pm->{'color_b'}); }
    foreach $residue ( @residue ) {
        if ( $r[$i] == 1.00 && $g[$i] == 0.00 && $b[$i] == 0.00 ) { $color .= " r"; }
        if ( $r[$i] == 1.00 && $g[$i] == 0.50 && $b[$i] == 0.00 ) { $color .= " o"; }
        if ( $r[$i] == 1.00 && $g[$i] == 1.00 && $b[$i] == 0.00 ) { $color .= " y"; }
        if ( $r[$i] == 0.00 && $g[$i] == 1.00 && $b[$i] == 0.00 ) { $color .= " g"; }
        if ( $r[$i] == 0.93 && $g[$i] == 0.51 && $b[$i] == 0.93 ) { $color .= " p"; }
        if ( $r[$i] == 0.00 && $g[$i] == 0.00 && $b[$i] == 1.00 ) { $color .= " b"; }
        if ( $r[$i] == 0.70 && $g[$i] == 0.70 && $b[$i] == 0.70 ) { $color .= " s"; }
        if ( $r[$i] == 0.50 && $g[$i] == 0.50 && $b[$i] == 0.50 ) { $color .= " n"; }
        if ( $r[$i] == 1.00 && $g[$i] == 1.00 && $b[$i] == 1.00 ) { $color .= " w"; }
        $i++;
    }    
    print "$color       mask\n";
}

sub write_ct
{
    # Ebbe Sloth Andersen, April 2005.

    # WRITE_CT: outputs column file.

    my ( @entries ) = @_;

    # Returns nothing.

    my ( $entry,
	 @rnas,
	 $rna,
	 $n,
	 $i,
	 $residue,
	 @residue,
	 $seqpos,
	 @seqpos,
	 @seqpos2,
	 @alignpos,
	 @align_bp,
	 $align_bp,
	 @seq_bp,
	 );

    @rnas = grep { $_->{'TYPE'} eq "RNA" } @entries;

    # write sequences and masks
    foreach $entry ( @rnas )
    { 
	# empty arrays
	@residue = ( );
	@seqpos = ( );
	@seqpos2 = ( );
	@alignpos = ( );
	@align_bp = ( );
	@seq_bp = ( );

        # split hashes
	if ( defined $entry->{'residue'} )   { @residue = split(/,/, $entry->{'residue'}); }
	if ( defined $entry->{'seqpos'} )    { @seqpos = split(/,/, $entry->{'seqpos'}); }
	if ( defined $entry->{'alignpos'} )  { @alignpos = split(/,/, $entry->{'alignpos'}); }
	if ( defined $entry->{'align_bp'} )  { @align_bp = split(/,/, $entry->{'align_bp'}); }

	@seqpos2 = @seqpos;

	# make seq_bp and change . to 0
	foreach $align_bp ( @align_bp ) {
	    if ( $align_bp eq "." ) { 
		push( @seq_bp, "0" );
	    } else {
		push( @seq_bp, $seqpos[$align_bp-1] );
	    }
	}

	# remove seq gaps
	$i = 0;
	foreach $seqpos ( @seqpos2 ) {
	    if ( $seqpos eq "." ) { 
		# remove from all
		splice ( @residue, $i, 1 );
		splice ( @seqpos, $i, 1 );
		splice ( @alignpos, $i, 1 );
		splice ( @align_bp, $i, 1 );
		splice ( @seq_bp, $i, 1 );
		$i--;
	    }
	    $i++;
	}

	my $length = scalar ( @seqpos );

	# print header
	printf "%5s", $length;
	print " $entry->{'ENTRY'}\n";

        # print sequence
	$n = 0;    
	$i = 0;    
	foreach $residue ( @residue ) 
	{
	    $i++;
	    if ( defined $entry->{'seqpos'} )    { printf "%5s ", $seqpos[$n]; }
	    if ( defined $entry->{'residue'} )   { print uc($residue[$n]); }
	    printf "%8s", $i-1;
	    printf "%5s", $i+1;
	    printf "%5s", $seq_bp[$n];
	    if ( defined $entry->{'seqpos'} )    { printf "%5s", $seqpos[$n]; }
	    print "\n";
	    $n++;
	}
    }
}

sub write_cts
{
    # Ebbe Sloth Andersen, April 2005.

    # WRITE_CT: outputs column file.

    my ( $entries ) = @_;

    # Returns nothing.

    my ( $entry,
	 @rnas,
	 $rna,
	 $n,
	 $i,
	 $residue,
	 @residue,
	 $seqpos,
	 @seqpos,
	 @seqpos2,
	 @alignpos,
	 @align_bp,
	 @align_bp2,
	 $align_bp,
	 @seq_bp,
	$file,
	 );

    @rnas = grep { $_->{'TYPE'} eq "RNA" } @{ $entries };
		
    # write sequences and masks
    foreach $entry ( @rnas )
    { 
		$file = $entry->{'ENTRY'};
		
		$file =~ s/\//_/g;
		
		open ( OUT, ">$file.ct" ) or die "could not open file $file";

	# empty arrays
	@residue = ( );
	@seqpos = ( );
	@seqpos2 = ( );
	@alignpos = ( );
	@align_bp = ( );
	@align_bp2 = ( );
	@seq_bp = ( );

        # split hashes
	if ( defined $entry->{'residue'} )   { @residue = split(/,/, $entry->{'residue'}); }
	if ( defined $entry->{'seqpos'} )    { @seqpos = split(/,/, $entry->{'seqpos'}); }
	if ( defined $entry->{'alignpos'} )  { @alignpos = split(/,/, $entry->{'alignpos'}); }
	if ( defined $entry->{'align_bp'} )  { @align_bp = split(/,/, $entry->{'align_bp'}); }

	@seqpos2 = @seqpos;

	# make seq_bp and change . to 0
	foreach $align_bp ( @align_bp ) {
	    if ( $align_bp eq "." ) { 
		push( @align_bp2, "0" );
	    } else {
		push( @align_bp2, $align_bp );
	    }
	}

	@align_bp = @align_bp2;

	#print Dumper ( @align_bp );
	#exit;

	my $length = scalar ( @seqpos );

	# print header
	printf OUT "%5s", $length;
	print OUT " ENERGY = 0    $entry->{'ENTRY'}\n";

        # print sequence
	$n = 0;    
	$i = 0;    
	foreach $residue ( @residue ) 
	{
	    $i++;
	    if ( defined $entry->{'alignpos'} )    { printf OUT "%5s ", $alignpos[$n]; }
	    if ( defined $entry->{'residue'} )   { print OUT uc($residue[$n]); }
	    printf OUT "%8s", $i-1;
	    printf OUT "%5s", $i+1;
	    printf OUT "%5s", $align_bp[$n];
	    if ( defined $entry->{'alignpos'} )    { printf OUT "%5s", $alignpos[$n]; }
	    print OUT "\n";
	    $n++;
	}
        close ( OUT );   
    }
}

sub write_list
{
    # WRITE_LIST
    # Ebbe Sloth Andersen, October 2005.

    my ( $entries ) = @_;

    # Returns nothing.

    my ( $entry,       # running through entries array
	 $TYPE,        # for translation
	 $ENTRY,
	 $residue,     # for split and join
	 @residue,
         $length,      # longest name
         @length,
         $former,
         $i,
         @group,
	 );

    $i = 0;
    @group = ( );
    # numbers of sequences in groups
    foreach $entry ( @{ $entries } ) {
		$TYPE = $entry->{'TYPE'};
        $ENTRY = $entry->{'ENTRY'};
		if ( $ENTRY =~ /^SS/ ) {
			$TYPE = "arbitrary";
		}
		if ( $TYPE eq "RNA" ) {
            $i++;
            push @group, $i;
		}
		if ( $TYPE eq "arbitrary" ) {
			if ( $i == 0 ) {               
			} else {
				$length = scalar @group;
				for ( $a=0;$a<$length;$a++ ) {
					print "$group[$a]";
					if ( $a < $length-1 ) {
						print ",";
					}
				}
				print "\n";
				@group = ( );
			}
		}
    }

    $length = scalar @group;
    for ( $a=0;$a<$length;$a++ ) {
        print "$group[$a]";
        if ( $a < $length-1 ) {
            print ",";
        }
    }
    print "\n";
}

sub read_txt
{
    my ( $fname ) = @_;

    my ( $line, $id, $type, $seq, @entries, @seq, $TYPE );

    if ( not open FILE, "< $fname" ) {
	die "file not found!";
    }
    
    while ( $line = <FILE> )
    {
        chomp $line;
	( $id, $seq ) = split ( /\s+/, $line );
	@seq = ( );
	@seq = split ( //, $seq );
	$seq = join ( ",", @seq );
	
	$TYPE = "RNA";
	if ( $id eq "pairingmask" ) { 
		$TYPE = "pairingmask"; 
	}

	push @entries,
	{
	    "ENTRY" => $id,
	    "TYPE" => $TYPE,
	    "residue" => $seq,
	};
    }
    close FILE;
	
    return \@entries;
}

sub write_txt
{
    # Ebbe Sloth Andersen, December 2004.

    # WRITE_MASK v1.2: outputs mask file.

    my ( $entries ) = @_;

    # Returns nothing.

    my ( $entry,       # running through entries array
	 $TYPE,        # for translation
	 $ENTRY,
	 $residue,     # for split and join
	 @residue,
         $length,      # longest name
         @length,
         $former,
	 );

    # find length of longest name
    $former = 0;
    $length = 10;
    foreach $entry ( @{ $entries } ) {
        $length = length $entry->{'ENTRY'};
        if ( $length > $former ) {
            $former = $length;
        }
    }
    $length = $former + 2;

    # print it
    foreach $entry ( @{ $entries } ) {
	@residue = ( );
	$ENTRY = $entry->{'ENTRY'};
	if ( defined $entry->{residue} ) {
	    @residue = split ( /,/, $entry->{residue} );
	    $residue = join ( "", @residue );
	    printf "%-" . "$length" . "s ", $ENTRY;
	    print "$residue\n";
	}
    }
}

sub read_aln
{
    my ( $fname ) = @_;

    my ( $line, $id, $type, $seq, @entries, $test, @ENTRY, $ENTRY, @residue, $residue, $i, @residue2 );

    if ( not open FILE, "< $fname" ) {
		die "file not found!";
    }
		$i = 0;
		while ( $line = <FILE> )
		{
			chomp $line;	
			if ( $line =~ /^\S+/ ) {                      # finds line with info
				( $id, $seq ) = split ( /\s+/, $line );   # and get name and seq
				$i++; # should only count inside blocks
			} else {
				$i = 0;
			}
        
			# make array of names
			if ( $id eq "CLUSTAL" ) {
			} else {
				push ( @ENTRY, $id );
				$residue[$i] .= "$seq";
				$seq = "";
				$id = "";
			}
		}
		shift ( @residue );
    
		
	
		$i = 0;
		foreach $residue ( @residue ) {
			@residue2 = ( );
			@residue2 = split (//,$residue); 
			$residue = join (",",@residue2);
			push @entries,
			{
				"ENTRY" => $ENTRY[$i],
				"TYPE" => "RNA",
				"residue" => $residue,
			};
			$i++;
		}
		close FILE;
	
    return \@entries;
}

1;
