#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# STRIP: Removes "pairingmask" and "arbitrary"

# Ebbe Sloth Andersen, March 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $line, $header, $entry );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
foreach $entry ( @{ $entries } ) {
    if ( $entry->{'ENTRY'} =~ /^SS/ ) {
        $entry->{'TYPE'} = "arbitrary";
    }
    $entry->{'residue'} = lc($entry->{'residue'});
}
@{ $entries } = grep { $_->{'TYPE'} eq "RNA" } @{ $entries };
$header .= "This col file was generated by the program strip.";
&Formats::write_col ( $header, $entries );
