/*********************************************************************

  protein.c

  Contains general functions for handling proteins.

  001016 Bjarne Knudsen (bk@daimi.au.dk)

  Copyright (C) 2000 Bjarne Knudsen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

*********************************************************************/

#include "protein.h"

/*
   Returns true if amino is a knwon amino acid or '-'. Otherwise, false.
*/
int IsAmino(char amino)
{
  amino = toupper(amino);
  if (amino == 'A' || amino == 'C' || amino == 'D' || amino == 'E' ||
      amino == 'F' || amino == 'G' || amino == 'H' || amino == 'I' ||
      amino == 'K' || amino == 'L' || amino == 'M' || amino == 'N' ||
      amino == 'P' || amino == 'Q' || amino == 'R' || amino == 'S' ||
      amino == 'T' || amino == 'V' || amino == 'W' || amino == 'Y' ||
      amino == '-')
    return 1;
  return 0;
}

/*
   Returns true if amino is a knwon amino acid, from the extended set,
   or '-'. Otherwise, false.

   The extended amino acid set also includes:

    B, Z, X
*/
int IsAminoExt(char amino)
{
  amino = toupper(amino);
  if (amino == 'A' || amino == 'C' || amino == 'D' || amino == 'E' ||
      amino == 'F' || amino == 'G' || amino == 'H' || amino == 'I' ||
      amino == 'K' || amino == 'L' || amino == 'M' || amino == 'N' ||
      amino == 'P' || amino == 'Q' || amino == 'R' || amino == 'S' ||
      amino == 'T' || amino == 'V' || amino == 'W' || amino == 'Y' ||
      amino == 'B' || amino == 'Z' || amino == 'X' ||
      amino == '-')
    return 1;
  return 0;
}

char Nuc2Amino(char nuc1, char nuc2, char nuc3)
{
  nuc1 = toupper(nuc1);
  if (nuc1 == 'T') nuc1 = 'U';

  nuc2 = toupper(nuc2);
  if (nuc2 == 'T') nuc2 = 'U';

  nuc3 = toupper(nuc3);
  if (nuc3 == 'T') nuc3 = 'U';

  if (nuc1 == 'A') {
    if (nuc2 == 'A') {
      if (nuc3 == 'A')      return 'K';
      else if (nuc3 == 'C') return 'N';
      else if (nuc3 == 'G') return 'K';
      else if (nuc3 == 'U') return 'N';
    }
    else if (nuc2 == 'C') {
      if (nuc3 == 'A')      return 'T';
      else if (nuc3 == 'C') return 'T';
      else if (nuc3 == 'G') return 'T';
      else if (nuc3 == 'U') return 'T';
    }
    else if (nuc2 == 'G') {
      if (nuc3 == 'A')      return 'R';
      else if (nuc3 == 'C') return 'S';
      else if (nuc3 == 'G') return 'R';
      else if (nuc3 == 'U') return 'S';
    }
    else if (nuc2 == 'U') {
      if (nuc3 == 'A')      return 'I';
      else if (nuc3 == 'C') return 'I';
      else if (nuc3 == 'G') return 'M';
      else if (nuc3 == 'U') return 'I';
    }
  }
  else if (nuc1 == 'C') {
    if (nuc2 == 'A') {
      if (nuc3 == 'A')      return 'Q';
      else if (nuc3 == 'C') return 'H';
      else if (nuc3 == 'G') return 'Q';
      else if (nuc3 == 'U') return 'H';
    }
    else if (nuc2 == 'C') {
      if (nuc3 == 'A')      return 'P';
      else if (nuc3 == 'C') return 'P';
      else if (nuc3 == 'G') return 'P';
      else if (nuc3 == 'U') return 'P';
    }
    else if (nuc2 == 'G') {
      if (nuc3 == 'A')      return 'R';
      else if (nuc3 == 'C') return 'R';
      else if (nuc3 == 'G') return 'R';
      else if (nuc3 == 'U') return 'R';
    }
    else if (nuc2 == 'U') {
      if (nuc3 == 'A')      return 'L';
      else if (nuc3 == 'C') return 'L';
      else if (nuc3 == 'G') return 'L';
      else if (nuc3 == 'U') return 'L';
    }
  }
  else if (nuc1 == 'G') {
    if (nuc2 == 'A') {
      if (nuc3 == 'A')      return 'E';
      else if (nuc3 == 'C') return 'D';
      else if (nuc3 == 'G') return 'E';
      else if (nuc3 == 'U') return 'D';
    }
    else if (nuc2 == 'C') {
      if (nuc3 == 'A')      return 'A';
      else if (nuc3 == 'C') return 'A';
      else if (nuc3 == 'G') return 'A';
      else if (nuc3 == 'U') return 'A';
    }
    else if (nuc2 == 'G') {
      if (nuc3 == 'A')      return 'G';
      else if (nuc3 == 'C') return 'G';
      else if (nuc3 == 'G') return 'G';
      else if (nuc3 == 'U') return 'G';
    }
    else if (nuc2 == 'U') {
      if (nuc3 == 'A')      return 'V';
      else if (nuc3 == 'C') return 'V';
      else if (nuc3 == 'G') return 'V';
      else if (nuc3 == 'U') return 'V';
    }
  }
  else if (nuc1 == 'U') {
    if (nuc2 == 'A') {
      if (nuc3 == 'A')      return '-';
      else if (nuc3 == 'C') return 'Y';
      else if (nuc3 == 'G') return '-';
      else if (nuc3 == 'U') return 'Y';
    }
    else if (nuc2 == 'C') {
      if (nuc3 == 'A')      return 'S';
      else if (nuc3 == 'C') return 'S';
      else if (nuc3 == 'G') return 'S';
      else if (nuc3 == 'U') return 'S';
    }
    else if (nuc2 == 'G') {
      if (nuc3 == 'A')      return '-';
      else if (nuc3 == 'C') return 'C';
      else if (nuc3 == 'G') return 'W';
      else if (nuc3 == 'U') return 'C';
    }
    else if (nuc2 == 'U') {
      if (nuc3 == 'A')      return 'L';
      else if (nuc3 == 'C') return 'F';
      else if (nuc3 == 'G') return 'L';
      else if (nuc3 == 'U') return 'F';
    }
  }

  return '.';
}
