package src;
import java.util.ArrayList;


public final class BacktrackNew implements Backtrack {
	
	private Double sm = null;
	private int sc = 0;
	private double seqw = 0.0d;
	private ShortTermMemory STM = null;
	private double[][] sc1;
	private double[][] sc2;
	private int gap = 0;
	private int delta;
	private String seqA = null;
	private String seqB = null;
	private ArrayList<int[]> match = null;
	private boolean nolog = false;
	private Parameters p = null;
	
	public BacktrackNew(Parameters p){
		this.p = p;
		//substitution = p.getMatrix();
		seqw = GlobalParameters.seqw;
		delta = GlobalParameters.delta;
		sc1 = p.getSc1();
		sc2 = p.getSc2();
		gap = GlobalParameters.gap;
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		nolog = GlobalParameters.nolog;
		match = new ArrayList<int[]>();
	}
	
	public void track(int i,int j,int k,int l, final int i_end, final int j_begin, final int k_end, final int l_begin){
		//System.out.println("Backtracking: "+i+" "+i_end+" "+j+" "+j_begin+" "+k+" "+k_end+" "+l+" "+l_begin);
		char[] seqAArray = seqA.toCharArray();
		char[] seqBArray = seqB.toCharArray();
		STM = p.getSTM();
		boolean found = false;
		boolean bp = true;
		int lengthDiff;
		while((i <= j) || (k <= l)){
			lengthDiff = (l-k)-(j-i);
			found = false;
			bp = true;
			if(j<=j_begin && l<=l_begin && i>=i_end && k>=k_end){break;}
			final int currScore = STM.getAll(i,j,k,l);
			//System.out.println("Tracking: "+i+" "+j+" "+k+" "+l+"  "+currScore);
			//if(i<i_end && k<k_end && j>j_begin && l>l_begin && Math.abs(((l-k)-(j-i)))<delta+1){
				//System.out.println("i+1:"+STM.getAll(i+1,j,k,l)+" k+1:"+STM.getAll(i,j,k+1,l));
				//System.out.println("j-1:"+ STM.getAll(i,j-1,k,l)+" l-1:"+STM.getAll(i,j,k,l-1));
				//System.out.println("i+1,k+1:"+STM.getAll(i+1,j,k+1,l));
				//System.out.println("j-1,l-1:"+STM.getAll(i,j-1,k,l-1));
				//System.out.println("bp:"+STM.getAll(i+1,j-1,k+1,l-1));
				//System.out.println("I-1: "+seqA.charAt(i-1)+" K-1: "+seqB.charAt(k-1)+" J-1: "+seqA.charAt(j-1)+" L-1: "+seqB.charAt(l-1));
			//}
			if(i<i_end && k<k_end){
				if (STM.getAll(i+1,j,k+1,l) == (currScore - (seqAArray[i-1] == seqBArray[k-1] ? seqw : 0))){	
					final int[] temp = new int[2];
					temp[0] = i; temp[1] = k;
					match.add(temp); 
					k++;
					i++; 
					found = true;
					continue;
				}
			}	
			
			if(i<i_end && lengthDiff<delta+1 && lengthDiff>-delta-3){
				if (STM.getAll(i+1,j,k,l) == currScore - gap) {
					//System.out.println("ONE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);				
					i++;
					found = true;
					continue;
				}			
			}
			
			if(k<k_end && lengthDiff<delta+3 && lengthDiff>-delta-1){
				if (STM.getAll(i,j,k+1,l) == currScore - gap ) {
					//System.out.println("TWO: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
					k++;
					found = true;
					continue;
				}
			}
			if(j>j_begin && l>l_begin){
				if (STM.getAll(i,j-1,k,l-1) == (currScore - (seqA.charAt(j-1) == seqB.charAt(l-1) ? seqw : 0))){	
					//System.out.println("THREE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
					final int[] temp = new int[2];
					temp[0] = j; temp[1] = l;
					match.add(temp); 
					j--;
					l--; 
					found = true;
					continue;
				}
			}
			
			if(j>j_begin && lengthDiff<delta+1 && lengthDiff>-delta-3){
				if (STM.getAll(i,j-1,k,l) == currScore - gap ) {
					//System.out.println("TWO: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
					j--;
					found = true;
					continue;
				}
			}
			if(l>l_begin && lengthDiff<delta+3 && lengthDiff>-delta-1){
				if (STM.getAll(i,j,k,l-1) == currScore - gap ) {
					//System.out.println("TWO: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
					l--;
					found = true;
					continue;
				}
			}
			
			if(i<i_end && k<k_end && j>j_begin && l>l_begin){
				if(sc1[i][j] == 0.0){
					bp = false;
					//continue;
				}
				if(sc2[k][l] == 0.0){
					//continue;
					bp = false;
				}		
				if(bp){
					sm = nolog ? (2*(sc1[i][j]*sc2[k][l])) : sc1[i][j]+sc2[k][l];
					sm *= 100;
					sc = sm.intValue();
					sc += STM.getAll(i+1,j-1,k+1,l-1); //!!! + (k-k)*gap;
					if (currScore == sc){
						final int[] temp = new int[4];
						temp[0] = i; temp[1] = j;
						temp[2] = k; temp[3] = l;
						match.add(temp);
						i++; k++; l--; j--;
						found = true;
						continue;
					}
				}
			}
			
			if(i==j && k==l){
				final int[] temp = new int[2];
				temp[0] = i; temp[1] = k;
				match.add(temp);
				break;
			}
			
			if(!found){
				System.err.println("Found no good global alignment!");
				//System.err.println("Backtrack failed at: i="+i+" j="+j+" k="+k+" l="+l);
				System.exit(1);
			}
		}
	}
	
	final public ArrayList<int[]> getMatch(){
		return match;
	}
	
	/*public double seq_score(final char a, final char b){
		final int x = p.charToInt(a);
		final int y = p.charToInt(b);
		return substitution[x][y];
	}*/
	
	/**
	 * @return Returns the sTM.
	 */
	final public ShortTermMemory getSTM() {
		return STM;
	}
	
	/**
	 * @param stm The sTM to set.
	 */
	public void setSTM(final ShortTermMemory stm) {
		STM = stm;
	}
}