package src;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import options.Options;
import options.Options.Multiplicity;
import options.Options.Separator;

public final class FoldalignM {
	
	/**
	 * @param args
	 * @throws IOException 
	 * @throws InterruptedException 
	 */
	public static void main(String[] args) throws IOException, InterruptedException {
		String line = null;
		int i = 0;//merges,tmp,k;
		int j = 0;
		double score = 0.0;
		double[][] SM = null;
		String path = "";
		Options opt = new Options(args,2);
		opt.getSet().addOption("global",Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("fast",Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("no_pruning",Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("col",Multiplicity.ZERO_OR_ONE);
		//opt.getSet().addOption("local",Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("nolog", Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("delta", Separator.BLANK, Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("gap", Separator.BLANK, Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("seqw", Separator.BLANK, Multiplicity.ZERO_OR_ONE);
		opt.getSet().addOption("consensus", Separator.BLANK, Multiplicity.ZERO_OR_ONE);
		//opt.getSet().addOption("t", Separator.EQUALS, Multiplicity.ZERO_OR_ONE);
		
		if (!opt.check()) {
			// Print usage hints
			System.err.println("\n\nTo run this program you need to provide it with a fasta file and a output name!");
			System.err.println("Usage: java FoldalignM_Foldalign [-fast] [-delta value] [-gap value] [-seqw value] [-nolog] [no_pruning] [col] <input> <output>");
			System.err.println("The default values are:");
			System.err.println("\t-fast: Fast is global alignment that uses more memory but is faster, default is not to use this.");
			System.err.println("\t-delta: The maximum allowed length difference between any given pair, default is max(10,length difference)");
			System.err.println("\t-gap: The gap cost, default is -300");
			System.err.println("\t-seqw: The score for a sequence match, default is 5");
			System.err.println("\t-consensus: The consensus prob. matrix cutoff, default is 4 (i.e. #sequences/4)");
			System.err.println("\t-nolog: Set this if you don't want to use log-odds score, default is to use them");
			System.err.println("\t-no_pruning: Default is to prune away low scoring cells");
			System.err.println("\t-col: Also output the alignment in column format");
			System.err.println();
			System.exit(1);
		}
		
		//final GlobalParameters globalP = new GlobalParameters();
		//final boolean nolog = GlobalParameters.nolog;
		
		if(opt.getSet().isSet("fast")){
			GlobalParameters.mode = 2;
		}
		if(opt.getSet().isSet("no_pruning")){
			GlobalParameters.noprune = true;
		}	
		if(opt.getSet().isSet("col")){
			GlobalParameters.col = true;
		}	
		if (opt.getSet().isSet("delta")) {
			GlobalParameters.delta = Short.parseShort(opt.getSet().getOption("delta").getResultValue(0));			
		}
		if (opt.getSet().isSet("gap")) {
			GlobalParameters.gap = Short.parseShort(opt.getSet().getOption("gap").getResultValue(0));			
		}
		if (opt.getSet().isSet("seqw")) {
			GlobalParameters.seqw = Short.parseShort(opt.getSet().getOption("seqw").getResultValue(0));			
		}
		if (opt.getSet().isSet("consensus")) {
			GlobalParameters.consensus = Short.parseShort(opt.getSet().getOption("consensus").getResultValue(0));			
		}
		if (opt.getSet().isSet("nolog")) {
			GlobalParameters.nolog = true;			
		}
		
		//Read a file with all the pairwise scores
		final String scoreFile = opt.getSet().getData().get(0);
		final String outName = opt.getSet().getData().get(1);
		if(args.length==3){
			GlobalParameters.noprune = true;
		}
		Pattern p = Pattern.compile("(.*\\/)SM.out");
		Matcher match = null;
		match = p.matcher(scoreFile);
		if(match.find()){
			 path = match.group(1);
		} 
		final InputStream input = new FileInputStream(scoreFile);
		final BufferedReader fil = new BufferedReader(new InputStreamReader(input));
		line = fil.readLine();
		final int NN = Integer.parseInt(line);
		GlobalParameters.allSeqs = NN;
		line = fil.readLine();
		final String[] allNames = new String[NN+(NN-1)];
		final String[] names = line.split(" ");
		for(i=0;i<allNames.length;i++){
			if(i < NN){
				allNames[i] = names[i];
			}else{
				allNames[i] = "Merge" + (i-NN+1);
			}
		}
		SM = new double[(NN << 1)+1][(NN << 1)+1];
		//Extract the Sequence IDs and score into a two-dimensional array
		p = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(\\d+)");
		while((line = fil.readLine()) != null){
			match = p.matcher(line);
			if(match.find()){
				i = Integer.parseInt(match.group(1));
				j = Integer.parseInt(match.group(2));
				score = java.lang.Double.parseDouble(match.group(3));
				SM[i][j] = score+10;
				SM[j][i] = score+10;
			}
		}
		
//		Make the relevant directories if they do not exist
		String mkdir = "";
		Process mv;
		if(!exists(".fold_cons")){
			mkdir = "mkdir .fold_cons";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(!exists(".fold_out")){
			mkdir = "mkdir .fold_out";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(exists(".fold_out/"+outName+".original.out")){
			mkdir = "rm .fold_out/"+outName+".original.out";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		if(exists(".fold_out/"+outName+".refined.out")){
			mkdir = "rm .fold_out/"+outName+".refined.out";
			mv = Runtime.getRuntime().exec(mkdir);
			mv.waitFor();
		}
		
		//Make a WPGMA guide tree to guide the miltiple alignment
		final Wpgma guide = new Wpgma(NN, SM, path);
		final ArrayList<PairAlignment> pas = guide.getPairAlignments();
		//final String[] align = null;
		//The last pairwise alignment is the multiple alignment
		final PairAlignment last = pas.get(pas.size()-1);
		new MakeMultiple(last,allNames,names, pas,NN, path,outName);
	}
	private static boolean exists (String filename) {
        return exists (filename, new File ("."));
    }
 
    private static boolean exists (String filename, File dir) {
        boolean exists = false;
 
        if (new File (dir, filename).exists ()) {
            exists = true;
        } else {
            File[] subdirs = dir.listFiles ();
 
            int i = 0;
            int n = (subdirs == null) ? 0 : subdirs.length;
 
            while ((i < n) && ! exists) {
                File subdir = subdirs[i];
 
                if (subdir.isDirectory ()) {
                    exists = exists (filename, subdir);
                }
 
                i ++;
            }
        }
        return exists;
    }
}
