package src;
public final class ProfComp {
	private double seqw = 0.0d;
	private int endgaps = 0;
	private int gap = 0;
	private double score = 0.0d;
	public ProfComp(final double[][] pm1, String seq1, final double[][] pm2, final String seq2){
		//seqw = para.getSeqw();
		//endgaps = para.endgaps;
		//gap = para.getGap();
		seqw = 0.05;
		gap=-3;
		endgaps = 1;
		//my (@p1, @p2, @S);
		final double[][] p1 = new double[seq1.length()+1][3];
		final double[][] p2 = new double[seq2.length()+1][3];
		final char[] pc1 = new char[seq1.length()+1];
		final char[] pc2 = new char[seq2.length()+1];
		final double[][] S = new double[seq1.length()+1][seq2.length()+1];
		int i = 0;
		int j = 0;
		final int length1 = seq1.length();
		final int length2 = seq2.length();
		for (i=1; i<length1+1;i++) {
			p1[i][1] = 0.0;
			p1[i][2] = 0.0;
			pc1[i] = 0;
			//@{$p1[$i]}[1..3] = (0,0,0);
		}
		for (i=1; i<length1+1;i++) {
			for (j=i+1; j<seq1.length()+1; j++) {
				if(pm1[i][j] == 0.0){continue;}
				//next unless exists $$pm1{$i,$j};
				p1[i][1] += pm1[i][j];
				p1[j][2] += pm1[i][j];
			}
		}
		for (i=1; i<length1+1;i++) {
			p1[i][0] = 1 - p1[i][1] - p1[i][2];
			if(p1[i][0]<0.0){p1[i][0]=0.0;}
			pc1[i] = seq1.charAt(i-1);
		}
		for (i=1; i<length2+1;i++) {
			p2[i][1] = 0.0;
			p2[i][2] = 0.0;
			pc2[i] = 0;
			//@{$p2[$i]}[1..3] = (0,0,0);
		}
		for (i=1; i<length2+1;i++) {
			for (j=i+1; j<seq2.length()+1; j++) {
				if(pm2[i][j] == 0.0){continue;}
				//next unless exists $$pm2{$i,$j};
				p2[i][1] += pm2[i][j];
				p2[j][2] += pm2[i][j];
			}
		}
		for (i=1; i<length2+1;i++) {
			p2[i][0] = 1 - p2[i][1] - p2[i][2];
			if(p2[i][0]<0.0){p2[i][0]=0.0;}
			pc2[i] = seq2.charAt(i-1);
		}
		
		//Initialize
		for (i=0; i<length1+1;i++) {
			S[i][0] = (endgaps==1) ? (i * gap) : 0;
		}
		for (j=0; j<length2+1;j++) {
			S[0][j] = (endgaps==1) ? (j * gap) : 0;
		}
		for (i=1; i<length1+1;i++) {
			for (j=1; j<seq2.length()+1;j++) {
				double ss = S[i-1][j-1] + pscore(p1[i], p2[j],pc1[i],pc2[j]);
				if (S[i][j-1] +gap > ss){ss = S[i][j-1] +gap;}
				if (S[i-1][j] +gap > ss){ss = S[i-1][j] +gap;}
				S[i][j] = ss;
			}
		}
		score = S[length1][length2];
	}
	
	private double pscore(final double[] p1, final double[] p2,final char A, final char B) {
		double s = Math.sqrt(p1[0]*p2[0])+Math.sqrt(p1[1]*p2[1])+Math.sqrt(p1[2]*p2[2]);
		//System.out.println("PSCORE: "+p1[0]+" "+p2[0]+" "+p1[1]+" "+p2[1]+" "+p1[2]+" "+p2[2]+" "+" ::: "+s);
		//s += seq_score(p1[3], p2[3]);
		s += (A == B) ? seqw : 0.0;
		return s;
	 }
	public double getScore(){
		return score;
	}
	/*private double seqScore(char A, char B) {
		 if(A == B){return seqw;}
		 return 0;
	 }*/
}