package src;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RNAfold {
	private int NN;
	private double[][] SM;
	private String[] allNames;
	private String[] names;
//	system command to run RNAfold
	public RNAfold(HashMap<String,String> fasta, boolean nolog,final String path) throws IOException{
		String line;
		int z = 0;
		Set<String> set = fasta.keySet();
		Iterator<String> iter = set.iterator();
		NN = set.size();
		if(NN>1){
			names = new String[NN];
			String[] seqs = new String[NN];		
			while(iter.hasNext()){
				String name = iter.next();
				String seq = fasta.get(name);
				names[z] = name;
				seqs[z] = seq;
				z++;
				String s = null;
				name = name.replace('/','_');
				String[] cmd;
				if(GlobalParameters.plfold){
					cmd = new String[]{"/bin/sh","-c","echo \">"+name+"\n"+seq+"\" | RNAplfold -noLP"};
				}else{
					cmd = new String[]{"/bin/sh","-c","echo \">"+name+"\n"+seq+"\" | RNAfold -p -noLP"};
				}
				String shortName = "";
				if(name.length()>12){
					shortName = name.substring(0,12);
				}else{
					shortName = name;
				}
				final String move = "mv "+shortName+"_dp.ps .fold_rnafold/"+name;
				//final String move = "mv "+shortName+"_dp.ps rnafold/"+name;
				final String remove = "rm "+shortName+"_ss.ps";
				//set the working directory for the OS command processor
				try {
					final Process pr = Runtime.getRuntime().exec(cmd);
					final int o = pr.waitFor();
					if (o == 0){
						//BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
						//						read the output from the command
						//while ((s = stdInput.readLine()) != null) {
						//	System.out.println(s);
						//}
					}
					else {
						final BufferedReader stdErr = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
						//						read the output from the command
						while ((s = stdErr.readLine()) != null) {
							System.out.println(s);
						}
						
					}
					Process mv = Runtime.getRuntime().exec(move);
					mv.waitFor();
					mv = Runtime.getRuntime().exec(remove);
					mv.waitFor();
				}
				catch (Exception e) {
					System.out.println(e);
				}
			}
			
			SM = new double[(NN<<1)+1][(NN<<1)+1];
			Pattern p = Pattern.compile("^(\\d+)\\s+(\\d+)\\s+(\\d\\.\\d+)\\s+ubox$");
			Matcher match;
			double score;
			final double minread = Math.sqrt(0.0001);
			
			for(int f=0; f<NN; f++){
				String nameA = names[f];
				String seqA = fasta.get(nameA);
				nameA = nameA.replace('/','_');
				final InputStream inputA = new FileInputStream(".fold_rnafold/"+nameA);
				final BufferedReader filA = new BufferedReader(new InputStreamReader(inputA));
				int lengthA = seqA.length();
				String out = "Sequence:" + seqA +"\n";
				final double[][] pm1 = new double[lengthA+1][lengthA+1];
				while((line = filA.readLine()) != null){
					match = p.matcher(line);
					if(match.find()){
						out += line +'\n';
						double tmp = Double.parseDouble(match.group(3));
						if(tmp<minread){continue;}
						if (!nolog) {
							score = Math.log(tmp*lengthA*2)/(Math.log(lengthA<<1));
							if(score < 0){continue;}
						} else {
							score = tmp*tmp;
						}
						pm1[Integer.parseInt(match.group(1))][Integer.parseInt(match.group(2))] = score;
					}
				}
				writeToFile(out, path+""+(f+1)+".out");
				if(f==NN-1){break;}
				for(int f2=f+1; f2<NN; f2++){
					String nameB = names[f2];
					String seqB = fasta.get(nameB);
					nameB = nameB.replace('/','_');
					final InputStream inputB = new FileInputStream(".fold_rnafold/"+nameB);
					final BufferedReader filB = new BufferedReader(new InputStreamReader(inputB));
					int lengthB = seqB.length();
					final double[][] pm2 = new double[lengthB+1][lengthB+1];
					while((line = filB.readLine()) != null){
						match = p.matcher(line);
						if(match.find()){
							double tmp = Double.parseDouble(match.group(3));
							if(tmp<minread){continue;}
							if (!nolog) {
								score = Math.log(tmp*lengthB*2)/(Math.log(lengthB*2));
								if(score < 0){continue;}
							} else {
								score = tmp*tmp;
							}
							pm2[Integer.parseInt(match.group(1))][Integer.parseInt(match.group(2))] = score;
						}
					}						
					final ProfComp fast = new ProfComp(pm1,seqA,pm2,seqB);
					
					SM[f+1][f2+1] = fast.getScore();
					SM[f2+1][f+1] = fast.getScore();
				}
			}			
			allNames = new String[NN+(NN-1)];
			for(int i=0;i<allNames.length;i++){
				if(i < NN){
					allNames[i] = names[i];
				}else{
					allNames[i] = "Merge" + (i-NN+1);
				}	
			}
		}
	}
	public static void writeToFile(final String data,String name) throws IOException{
		final File cOutFile = new File(name);
		if (cOutFile.exists())
			cOutFile.delete();
		if (cOutFile.createNewFile())
			;
		final FileWriter cOutFileWriter = new FileWriter(cOutFile);
		cOutFileWriter.write(data);
		cOutFileWriter.flush();
		cOutFileWriter.close();
	}
	/**
	 * @return Returns the allNames.
	 */
	public final String[] getAllNames() {
		return allNames;
	}
	
	/**
	 * @return Returns the nN.
	 */
	public final int getNN() {
		return NN;
	}
	/**
	 * @return Returns the sM.
	 */
	public final double[][] getSM() {
		return SM;
	}
	/**
	 * @return Returns the names.
	 */
	public final String[] getNames() {
		return names;
	}
}
