#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# ALI_SHADE
# This program will shade an alignment. Bases are grey. Gaps are white.

# Ebbe Sloth Andersen, March 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &ali_shade ( $entries );
$header .= "; ali_shade.pl was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<


sub ali_shade
{
    # ALI_SHADE
    # Colors all positions that contain letters. Gaps are white.
    # Ebbe Sloth Andersen, March 2005.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my ( @rna,
	 $rna,
	 @rnas,
	 @bps,
	 $bp,
         @pm,
         $pm,
         );

    @rnas = grep { $_->{'TYPE'} eq "RNA" } @{ $entries };
    
    foreach $rna ( @rnas ) {
	@bps = ( );
	@bps = split(/,/, $rna->{'residue'});

        $rna->{'color_r'} = "";
        $rna->{'color_g'} = "";
        $rna->{'color_b'} = ""; 
        
	foreach $bp ( @bps ) {
	    if ( $bp =~ /^(a|t|u|g|c|A|T|U|G|C)/ ) {
		$rna->{'color_r'} .= "0.70,";
		$rna->{'color_g'} .= "0.70,";
		$rna->{'color_b'} .= "0.70,";
	    } else {
		$rna->{'color_r'} .= "1.00,";
		$rna->{'color_g'} .= "1.00,";
		$rna->{'color_b'} .= "1.00,";
	    }
	}
    }
    return $entries;
}
