#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# ID_SHADE  
# Ebbe Sloth Andersen, July 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;

( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &id_shade ( $entries );
$header .= "; id_shade.pl was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub id_shade
{
    # Ebbe Sloth Andersen, November 2005.

    my ( $entries ) = @_;

    my ( $entry,
         $entry2,
         $residue,
         @residue,
         @residue1,
         @residue2,
         $length,
         $i,
         $same,
         $list,
         @list,
         $sum,
         $n,
         $former,
         $name,
         %colors,
         @color,
         $color,
         @name1,
         @name2,
         @identical,
         $identical,
         @ids,
         @rnas,
         );
 
    # Define colors
    %colors = (
	       "red"        => [1.00, 0.50, 0.50],
	       "white"      => [1.00, 1.00, 1.00]
	       );

    # get RNAs
    @rnas = grep { $_->{'TYPE'} eq "RNA" } @{ $entries };

    # make matrix
    $sum = 0;
    $length = (length ${ $entries }[0]->{'residue'})/2;
    foreach $entry ( @rnas ) {
        $n = 0;
        @residue1 = ( );
        @residue1 = split ( /,/, $entry->{'residue'} );
        foreach $entry2 ( @{ $entries } ) {
            @residue2 = ( );
            @residue2 = split ( /,/, $entry2->{'residue'} );
            for ( $i = 0; $i < $length; $i++ ) {
                if ( uc($residue1[$i]) eq uc($residue2[$i]) ) {
                    $same++;
                }
            }
            $sum = $same/$length;
            push @list, $sum;
            push @name1, $entry->{'ENTRY'};
            push @name2, $entry2->{'ENTRY'};
            $same = 0;
            $n++;
        }
        $sum = 0;
    }

   # print Dumper ( @list );
   # exit;

    # find identical
    $i = 0;
    foreach $list ( @list ) {
        if ( $name1[$i] ne $name2[$i] && $list == 1 ) {
            push @identical, "$name1[$i] $name2[$i]";
        }
        $i++;
     }

    # color identical
    foreach $entry ( @rnas ) {
        $color = "white";
        foreach $identical ( @identical ) {
            @ids = ( );
            @ids = split( /\s+/, $identical );  
            if ( $entry->{'ENTRY'} eq $ids[0] ) {
                $color = "red";
            }
            if ( $entry->{'ENTRY'} eq $ids[1] ) {
                $color = "red";
            }
        }
        @residue = ( );
        @residue = split ( /,/, $entry->{'residue'} );
        foreach $residue ( @residue ) {
            $entry->{'color_r'} .= "$colors{$color}[0],";
            $entry->{'color_g'} .= "$colors{$color}[1],";
            $entry->{'color_b'} .= "$colors{$color}[2],"; 
        }
    }

    return $entries;
}