#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# COL2CTS
#
# Ebbe Sloth Andersen, February 2005. Email: esa@mb.au.dk

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file );

( $file ) = @ARGV;
$entries = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &nogaps ( $entries );
&Formats::write_cts ( $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub nogaps
{
    # Ebbe Sloth Andersen, September 2005.

    my ( $entries ) = @_;

    my ( $entry, 
         @rnas, 
         @residue, 
         @seqpos,
         @alignpos,
         @align_bp, 
         $residue, 
         $seq,
         $label, 
         $seq_bp, 
         $pos, 
         $align_bp,
         $i,
        );
    
    @rnas = ( );
    @rnas = grep { $_->{'TYPE'} eq "RNA" } @{ $entries };

    foreach $entry ( @rnas ) {
        @residue = ( );
        @seqpos = ( );
        @align_bp = ( );
        @residue = split(/,/, $entry->{'residue'});
        @seqpos = split(/,/, $entry->{'seqpos'});
        @align_bp = split(/,/, $entry->{'align_bp'});
        
        # map align_bp on seqpos to create seq_bp

        $label = "";
        $seq = "";
        $pos = "";
        $seq_bp = "";
        $i = 0;
        foreach $residue ( @residue ) {
            if ( $residue ne "-" ) { 
                if ( $align_bp[$i] ne "." ) {
                    $seq_bp .= "$seqpos[$align_bp[$i]-1],";         
                } else {
                    $seq_bp .= ".,";  
                }                
                $seq .= "$residue,";                
                $label .= "N,";                
                $pos .= "$seqpos[$i],";
            }
            $i++;
        }
        
        $entry->{'label'} = $label;
        $entry->{'residue'} = $seq;
        $entry->{'seqpos'} = $pos;
        $entry->{'alignpos'} = $pos;
        $entry->{'align_bp'} = $seq_bp;
    }
    return $entries;
}
