/*********************************************************************

  dna.c

  Contains general functions for handling DNA.

  001016 Bjarne Knudsen (bk@daimi.au.dk)

  Copyright (C) 2000 Bjarne Knudsen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

*********************************************************************/

#include "dna.h"

/*
   Returns true if nuc is a knwon nucleotide or '-'. Otherwise, false.
*/
int IsDNAnuc(char nuc)
{
  nuc = toupper(nuc);
  if (nuc == 'A' || nuc == 'C' ||
      nuc == 'G' || nuc == 'T' || nuc == '-')
    return 1;
  return 0;
}

/*
   Returns true if nuc is a knwon nucleotide, from the extended set,
   or '-'. Otherwise, false.

   Extended nucleotide set:

   A, C, G, T, Y, R, K, M, B, D, H, V, N, X
*/
int IsDNAnucExt(char nuc)
{
  nuc = toupper(nuc);
  if (nuc == 'A' || nuc == 'C' || nuc == 'G' || nuc == 'T' ||
      nuc == 'Y' || nuc == 'R' || nuc == 'K' || nuc == 'M' ||
      nuc == 'A' || nuc == 'C' ||  /* correct these */
      nuc == 'B' || nuc == 'D' || nuc == 'H' || nuc == 'V' ||
      nuc == 'N' || nuc == 'X' || nuc == '-')
    return 1;
  return 0;
}

char DNAcomplement(char nuc)
{
  if (nuc == 'A')
    return 'T';
  else if (nuc == 'C')
    return 'G';
  else if (nuc == 'G')
    return 'C';
  else if (nuc == 'T' || nuc == 'U')
    return 'A';
  else if (nuc == 'a')
    return 't';
  else if (nuc == 'c')
    return 'g';
  else if (nuc == 'g')
    return 'c';
  else if (nuc == 't' || nuc == 'u')
    return 'a';
  else
    return 'n';
}
