package src;
import java.util.ArrayList;


public final class PmCompFast{
	
	private int lengthA,lengthB,delta,gap;
	private String seqA,seqB;
	private Parameters p;
	private int[][][][] S;
	private int seqw;
	private ArrayList[] sc1trim,sc2trim;
	private boolean nolog;
	private int ss=0;
	private int d=0;
	//private double[][] substitution;
	//The relX parameters are relative sequence positions
	//The realX parameters are the real sequence positions
	private int relJ,relK,relL,offset;
	
	public PmCompFast(Parameters p){
		this.p = p;
		lengthA = p.getLengthA();
		lengthB = p.getLengthB();
		delta = GlobalParameters.delta;
		gap = GlobalParameters.gap;
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		seqw = GlobalParameters.seqw;
		sc1trim = p.getSc1trim();
		sc2trim = p.getSc2trim();
		nolog = GlobalParameters.nolog;
		S = new int[lengthA+2][][][];
		//substitution = p.getMatrix();
	}
	
	public double initialize(){
		for(int i=1; i<lengthA+2; i++){
			S[i] = new int[(4*delta)+3][][];
			for(int k=0; k<4*delta+3; k++){
				S[i][k] = new int[lengthA+2 - i][];
				for(int j=0; j<lengthA+1-i; j++){
					S[i][k][j] = new int[2*delta+3];
					//l0 = j - delta -1;
					for(int l=0; l<2*delta+3; l++){				
						if(l < delta +1){
							d = (delta+1)-l;
						}else{
							d = l - (delta+1);
						}
						S[i][k][j][l] = (Math.abs(d))*gap;
					}
				}
			}
		}
		
		for(int j=5; j<lengthA+1; j++){
			for(int i=j; i>0; i--){
				relJ = j-i;
				for(int l=1; l<lengthB+1; l++){
					if((lengthA-j)-(lengthB-l)>delta+1){break;}
					if((lengthB-l)-(lengthA-j)>delta+1){continue;}
					//ss = 0;
					for(int k=l; k>0; k--){
						offset = (k-i);
						relK = ((2*delta)+1) + offset;
						offset = (l-k) - (j-i);
						relL = (delta+1)+offset;
						//ss = -1000000;
						//comment out the following next/last statements to get the version
						//that restricts only pairs (not all subalignments)
						if ((i-k) > 2*delta){break;}
						if ((k-i) > 2*delta){continue;}
						if (((l-k)-(j-i)) > delta){break;}
						if (((j-i)-(l-k))> delta){continue;}
						int start1,start2,start3;
						if((i+1)>j){
							start1 = (l-k+1)* gap;
							start3 = (l-k)*gap;
						}else{
							start1 = S[i+1][relK-1][relJ-1][relL+1];
							start3 = S[i+1][relK][relJ-1][relL];
						}
						if((k+1)>l){
							start2 = (j-i+1)*gap;
						}else{
							start2 = S[i][relK+1][relJ][relL-1];
						}
						
						S[i][relK][relJ][relL] = start1 + gap;
						//ss = start3 + seq_score(seqA.charAt(i-1),seqB.charAt(k-1));
						//if(i == 149){System.out.println("COMP: i:"+i+" j:"+j+" k:"+k+" l:"+l+" A:"+seqA.charAt(i-1)+" B:"+seqB.charAt(k-1)+" ss:"+ss+" Score:"+S[i][relK][relJ][relL] +" S1:"+start1+" S2:"+start2+" S3:"+start3);}
						//ss = start3 + seq_score(seqA.charAt(i-1),seqB.charAt(k-1));
						ss = start3 + (seqA.charAt(i-1) == seqB.charAt(k-1) ? seqw : 0);
						if (ss>S[i][relK][relJ][relL]){S[i][relK][relJ][relL] = ss;}
						if ((start2+gap)>S[i][relK][relJ][relL]){S[i][relK][relJ][relL] = start2 + gap;}
						if ((i-k) > delta){break;}
						if ((k-i) > delta){continue;}
						int dd = k-i;
						if (l-j > dd){dd = l-j;}
						//System.out.println("Score: "+i + " "+j+" "+k + " "+l+ " "+S[i][relK][relJ][relL]+" DD:"+dd);
						ArrayList temp = sc1trim[i];
						if(temp != null){
							for(int x=0; x<temp.size(); x++){
								double[] temp2 = (double[])temp.get(x);
								int h = (int)temp2[0];
								double ps1 = temp2[1];							
								if(h > j){break;}
								//System.out.println("I:"+i+" H:"+h+" J:"+j+" Sc:"+ps1);
								int q0 = dd + h - delta;
								if(q0 < (k+3)){q0 = k+3;}
								ArrayList temp3 = sc2trim[k];
								if(temp3 != null){
									for(int y=0; y<temp3.size(); y++){
										double[] temp4 = (double[])temp3.get(y);
										int q = (int)temp4[0];
										double ps2 = temp4[1];
										if (q<q0){continue;}
										if (q>l){break;}
										if (((q-k)-(h-i))>delta){break;}
										if (((j-h)-(l-q))>delta){break;}
										Double sm = nolog ? (2*ps1*ps2) : (ps1+ps2);
										sm *= 100;
										int smInt = sm.intValue();
										//System.out.println("K:"+k+" Q:"+q+" Sc:"+ps2 + " Sm:"+sm);
										int relH1 = (h-1)-(i+1);
										int relQ1 = ((q-1)-(k+1))-(relH1) + delta+1;
										int relH2 = h-i+1;
										int relQ2 = (q-(h+1)) + (2*delta+1);
										int relL2 = (l-(q+1)) - (j-(h+1)) + delta+1;
										int relK1 = (k+1)-(i+1) + 2*delta+1;
										//System.out.println("SM1: h:"+h +" q:"+q+" i:"+i+" j:"+j+" k:"+k + " l:"+l + " RelK:"+relK+" RelL:"+relL);
										//System.out.println("SM2: g0:"+q0+" relH:"+relH + " relQ:"+relQ+" l0:"+l0+ " SM:"+ sm);
										smInt += S[i+1][relK1][relH1][relQ1];
										//System.out.println("SM2: i:"+(i+1)+" k:"+(k+1)+ " j:"+(h-1)+ " l:"+(q-1)+" relH1:"+relH1 + " relQ1:"+relQ1+ " relK1:"+relK1+" SM:"+ sm);
										//if(S[h+1][q+1][j][l] != 0){ //TODO probably I don't need this if
										//System.out.println("SM3: i:"+(h+1)+" k:"+(q+1)+ " j:"+(j)+ " l:"+(l)+" relH2:"+relH2 + " relQ2:"+relQ2+ " h:"+h+ " relJ:"+relJ+ " relL2:"+relL2+" SM:"+ sm);
										if((relJ-relH2) == -1){smInt +=(relL2-(delta+1))*gap;}
										else{
											smInt += S[h+1][relQ2+1][relJ-relH2][relL2];
										}
										//System.out.println("HQA:"+(i+1)+" "+relH1+ " "+relK1+ " "+relQ1+" HQB: "+(h+1)+ " "+(relJ-relH2)+ " "+(relQ2+1)+ " "+relL2+ " SM:"+ sm);
										//}else{
										//System.err.print("The perl undefined error, here equals 0");
										//	sm += gap * (Math.abs((j-i)-h-(realL-q)));
										//}
										if(smInt>ss){ss = smInt;}
									}
								}
							}
						}
						if (ss > S[i][relK][relJ][relL]){
							//System.out.println("HitReal: "+i + " "+j+" "+k + " "+l+ " SM:"+ss);
							//System.out.println("HitRel: "+i + " "+relJ+" "+relK + " "+relL+ " SM:"+ss);
							S[i][relK][relJ][relL] = ss;
						}
					}
				}
			}
		}		
		p.setS(S);
		offset = lengthB-lengthA;
		return S[1][2*delta+1][lengthA-1][(delta+1)+offset];
	}
	public double seq_score(char a, char b){
		//int x = p.charToInt(a);
		//int y = p.charToInt(b);
		//return substitution[x][y];
		return seqw;
	}
}
