#! /bin/tcsh -f
#
# Use this script to run Pfold:
#
#  - First argument is the fasta file to analyze
#  - Second argument is the range of sequences (e.g. "1,2,4" or "4-7")
#  - Optinal third argument is an argument for a position range in the
#    Pfold run
#
# Output is one line with with the following two fields:
#
#  1. The range specified in argument two
#  2. The clustering score for this range
#

set PFOLD = "${SARSE_HOME}/programs/pfold/bin"
set RNADBTOOLS = "${SARSE_HOME}/programs/rnadbtools/bin"
set LOGFILE = "/dev/null"

# Print the range
echo -n $2 ""

# Find the tree
( $RNADBTOOLS/fasta2col $1 | $RNADBTOOLS/grepcol -r$2 | $PFOLD/findphyl $PFOLD/scfg.rate | $PFOLD/mltree $PFOLD/scfg.rate > tmp_tree.$$.col ) > & $LOGFILE

# Cut specific positions out
if ($3 != "") then
  # First, copy tree
  cat tmp_tree.$$.col | $RNADBTOOLS/grepcol -r1 > tmp.$$.col
  # Then cut sequence
  cat tmp_tree.$$.col | $RNADBTOOLS/grepcol -r2-10000 | $RNADBTOOLS/greppos --range=$3 >> tmp.$$.col
  mv tmp.$$.col tmp_tree.$$.col
endif

# Run Pfold
( cat tmp_tree.$$.col | $PFOLD/scfg_slow --treefile tmp_tree.$$.col $PFOLD/article.grm > tmp_res.$$.col ) > & $LOGFILE

# Calculate the score
cat tmp_res.$$.col | $RNADBTOOLS/grepcol -r2 | awk 'BEGIN {s = 0} $1 != ";" && $5 != "." {s += $6} END {print s}'

# Remove temporary files
rm tmp_tree.$$.col tmp_res.$$.col
