#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;

# ADDPMASKPAR
# Ebbe Sloth Andersen, Feb 2006.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, @print, $line, $header );

( $file ) = @ARGV;

( $header, $entries ) = &Formats::read_col ( $file );
$entries = &group_colors ( $entries );
$header .= "; This column file was generated by the program group_colors.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub group_colors
{
    # Ebbe Sloth Andersen, July 2005.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my ( @rna,
		$rna,
		@rnas,
		$pm,
         @pm,
		@pms,
		@bps,
		$bp,
         $i,
         $n,
         %colors,
         @color,
         $color,
         $prev,
         $prev2,
         $length,
         @labels,
         $label,
         @colo,
         $find,
         @colormask,
         $entry,
         @overlap, 
         $overlap,
         @stem,
         $stem,
         $align_bp,
         $reliability,
         @reliability,
         $m,
         @group,
         $group,
         @residue,
         $residue,
         @alignpos,
         @align_bp,
         $x,
         $lab,
         @lab,
         @paren,
         $z,
         $alignpos,
         $palindrome,
		 );

    # add bracket pairingmask
    @group = grep { $_->{'TYPE'} eq "pairingmask" } @{ $entries };
    my $g = 1;
	foreach $group ( @group ) {
        @residue = ( );
		@residue = split(/,/, $group->{'residue'});
        $n = 0;    
        $length = scalar @residue;
        foreach $residue ( @residue ) {
            if ( $residue eq "-" or $residue eq "." ) {
                push @paren, "-";
            } else {
                # get amount of labels
                @lab = ( );
                @lab = grep { $_ eq $residue } @residue;
                $lab = scalar @lab;
                # scan forward 
                $x = 0;
                for ( $i=$n; $i<$length; $i++ ) {
                    if ( $residue[$i] eq $residue ) { $x++; }
                }
                if ( $lab - $x >= $lab / 2 ) { 
                    push @paren, ")";
                } else {
                    push @paren, "(";
                }
            }
            $n++;
        }
		$n = 0;
		@align_bp = ( );
		foreach $residue ( @residue ) {
			push @align_bp, ".";
		}	
		foreach $residue ( @paren ) {
			if ( $residue eq "(" ) {
				# scan forward to find opposite
				$palindrome = 0;
				for ( $i=$n; $i<$length; $i++ ) {
					if ( $paren[$i] eq "(" ) { $palindrome++; }
					if ( $paren[$i] eq ")" ) { $palindrome--; }
					if ( $palindrome == 0 ) { 
						$align_bp[$n] = $i+1;		
						$align_bp[$i] = $n+1;		
						last; 
					}
				}
			}
			$n++;
		}
        $group->{'residue'} = join ( ",", @paren );
        $group->{'align_bp'} = join ( ",", @align_bp );
        if ( scalar @group == 1 ) {
            $group->{'TYPE'} = "arbitrary";
            $group->{'ENTRY'} = "SS_1";
        } else {
			$group->{'TYPE'} = "arbitrary";
			$group->{'ENTRY'} = "SS_$g";
        }
        @paren = ( );
        $g++;
        }
    return $entries;
}
