#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;

# >>>>>>>>>>>>>>>>>> XX <<<<<<<<<<<<<<<<<<<<

my ( @entries, $file, @print, $line,
    @align_bp, @residue, $align_bp, $i, 
    $entry, $residue,
    );

( $file ) = @ARGV;

@entries = &read_col ( $file );

foreach $entry ( @entries ) {
    @align_bp = split ( /,/, $entry->{align_bp} );
    @residue = split ( /,/, $entry->{residue} );
    $i = 0;
    foreach $align_bp ( @align_bp ) {
        if ( $align_bp ne "." ) {
            if ( $align_bp > $align_bp[$align_bp-1] ) {
                $residue[$i] = "(";
            } else {
                $residue[$i] = ")";
            }
        }
        $i++;
    }
}

foreach $residue ( @residue ) {
    if ( $residue eq "-" ) {
        $residue = ".";
    }     
    print "N";
}
print "\n";
$residue = join ( "", @residue );
print "$residue\n";

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub read_col
{
    # Ebbe Sloth Andersen, December 2004.

    # READ_COL: Reads column format into data structure with an array of hashes.
    # Reads any number of columns with any kind of data.
   
    my ( $fname ) = @_;

    # Returns an array of hashes. The key corresponds to the header.
    # The value contains body data points seperated by comma.

    my ( $line,        # input lines
	 @entries,     # the output array of hashes
	 @cols, 
	 $TYPE,        
	 @COL,         # any number of columns
	 $ENTRY, 
	 @data, 
	 $i,           # counting numbers
	 $length,
	 $counter );
    
    $counter = 0;	    
    @data = ( );
    @entries = ( );
    @COL = ( );

    if ( not open FILE, "< $fname" ) {
	die "file not found!";
    }

    while ( $line = <FILE> )
    {
	if ( $line =~ /^; \*+/ )            # finds footer
	{
	    push @entries, 
	    {
		"TYPE" => $TYPE,
		"ENTRY" => $ENTRY,
	    };

	    for ( $i=0; $i<$length; $i++ ) {
		map { $entries[$counter]->{$COL[$i]} = $data[$i] } @entries;
	    }
	    $counter = $counter + 1;
	    @data = ( );
	    @COL = ( );
            last;
	}
	elsif ( $line =~ /^;/ )            # reads header
	{
	    if ( $line =~ /^; TYPE\s+(\S+)/ ) {
		$TYPE = $1;
	    } elsif ( $line =~ /^; COL\s+\S+\s+(\S+)/ ) {
		push ( @COL, $1 );
	    } elsif ( $line =~ /^; ENTRY\s+(\S+)/ ) { 
		$ENTRY = $1;
	    }
	}
	else                               # reads body
	{
	    @cols = split(/\s+/, $line);
	    $length = scalar @cols;

	    # add sequences on an array

	    for ( $i=0; $i<$length; $i++ ) {
		$data[$i] .= "$cols[$i],";
	    }
	}   
    } 
    close FILE;
    return wantarray ? @entries : \@entries;
}
