#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings;
use Data::Dumper;
use GD;

# Ebbe Sloth Andersen, Feb 2006.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<

my ( @entries, $entry, $count, $length, $i, $Pfile, $PKfile, $SS,
     $group, $score, @group1, @score1, @group2, @score2, 
     $im, $line, $x, $y, $w,
     );

( $Pfile, $PKfile ) = @ARGV;

#get data
open FILE, "< $Pfile";
while ( $line = <FILE> ) {
    ( $group, $score ) = split ( /\s+/, $line );
    push @group1, $group;
    push @score1, $score;
}
close FILE;
open FILE, "< $PKfile";
while ( $line = <FILE> ) {
    ( $group, $score ) = split ( /\s+/, $line );
    push @group2, $group;
    push @score2, $score;
}
close FILE;

#get sizes
$y = 0;
$x = scalar @group2;
foreach $score ( @score2 ) {
    if ( $score > $y ) {
        $y = $score;
    }
}
if ( $y == 0 ) { $y = 1 };

#scale to 100 by 100
foreach $group ( @group2 ) {
    $group = $group / $x * 100;
}
foreach $score ( @score2 ) {
    $score = $score / $y * 100;
}
foreach $score ( @score1 ) {
    $score = $score / $y * 100;
}

use integer;
foreach $group ( @group2 ) {
    $group = $group * 1;
}
foreach $score ( @score2 ) {
    $score = $score * 1;
}
foreach $score ( @score1 ) {
    $score = $score * 1;
}
$w = 100/$x;

#print Dumper ( @group2 );
#print Dumper ( @score2 );

#initiate image
$im = new GD::Image(100,100);
my $white = $im->colorAllocate(255,255,255);
my $red = $im->colorAllocate(255,0,0);
my $green = $im->colorAllocate(0,255,0);
my $blue = $im->colorAllocate(0,128,255);

#plot graphs
$i = 0;
foreach $group ( @group2 ) {
    $im->filledRectangle( $group - $w, 100 - $score2[$i], $group, 100, $red );
    $im->filledRectangle( $group - $w, 100 - $score1[$i], $group, 100, $blue );
    $i++;
}

open(PNGFILE, ">", "myimage.png");
print PNGFILE $im->png;
close(PNGFILE);
