/*********************************************************************

  ct2col.c

  usage: ct2col [FILE]

  This program takes input from stdin or FILE. The file should be in
  ct (MFOLD) format.

  Output is in the col format, through stdout.

  000313 Bjarne Knudsen (bk@daimi.au.dk)

  Copyright (C) 2000 Bjarne Knudsen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "clib/file.h"

void usage(void);

int main(int argc, char **argv)
{
  FILE *fp;
  CmdArg *cmdarg;       /* Command line arguments */
  char *s;
  int len;
  int pos;
  char t[20];
  int pair;
  int junk;
  int i;

  cmdarg = InitArgument(argc, argv);

  if ((s = GetArgument(cmdarg)) != NULL) {
      usage();
      return 1; }

  if ((s = GetFilename(cmdarg)) == NULL)
    fp = stdin;
  else if (GetFilename(cmdarg) != NULL) {
    fprintf(stderr, "Usage: ct2col [FILE]\n");
    return 1; }
  else if ((fp = fopen(s, "r")) == NULL) {
    fprintf(stderr, "ct2col: Error in opening file '%s'\n", s);
    return 1; }

  printf("; Generated by ct2col\n");
  printf("; ========================================================================\n");

  while ((s = GetLine(fp)) != NULL) {
    while (s[0] == '\n')
      if ((s = GetLine(fp)) == NULL) {
	break;
      }
    if (s == NULL)
      break;

    /* Remove spaces after name */
    for (i = strlen(s)-2; i > 0; i--)
      if (s[i] != ' ') {
	s[i+1] = '\0';
	break; }

    if (sscanf(s, "%d %s %s %s %s %s %n", &len, t, t, t, t, t, &i) != 6) {
      fprintf(stderr, "ct2col: Error in sequence parameters\n");
      return 1;
    }

    printf("; TYPE              RNA\n");
    printf("; COL 1             label\n");
    printf("; COL 2             residue\n");
    printf("; COL 3             seqpos\n");
    printf("; COL 4             align_bp\n");
    printf("; ENTRY             %s\n", s+i);
    printf("; LENGTH            %d\n", len);
    printf("; ----------\n");
  
    free(s);

    for (pos = 0; pos < len && ((s = GetLine(fp)) != NULL); pos++) {
      if (sscanf(s, "%d %s %d %d %d", &junk, t, &junk, &junk, &pair) != 5) {
	fprintf(stderr, "ct2col: Error in sequence\n");
	return 1;
      }
      if (pair == 0)
	printf("N     %c %5d     .\n", t[0], pos+1);
      else
	printf("N     %c %5d %5d\n", t[0], pos+1, pair);

      free(s);
    }

    if (pos != len) {
      fprintf(stderr, "ct2col: Error in sequence length\n");
      return 1;
    }
    printf("; **********\n");
  }

  if (fp != stdin && fclose(fp) != 0) {
    fprintf(stderr, "ct2col: Error in closing file\n");
    return 1; }

  return 0;
}

void usage(void)
{
  fprintf(stderr, "usage: ct2col [FILE]\n");
}
