/*********************************************************************

  joincol.c

  usage: joincol <files>

  See man page for more info

  000928 Bjarne Knudsen (bk@daimi.au.dk)

  Copyright (C) 2000 Bjarne Knudsen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

*********************************************************************/

#include "clib/col.h"
#include "clib/file.h"

void usage(void);

int main(int argc, char **argv)
{
  FILE *fp;         /* For input */
  Header *header;
  Entry *entry;
  int read_error;   /* For keeping track of errors in reading entries */
  CmdArg *cmdarg;   /* Command line arguments */
  char *s;          /* String for arguments */
  int first;
  int c;

  cmdarg = InitArgument(argc, argv);

  if ((s = GetArgument(cmdarg)) != NULL) {
    usage();
    return 1; }

  header = MakeHeader();
  entry = MakeEntry();

  first = 1;

  fp = stdin;

  if ((c = fgetc(fp)) != EOF) { /* input to stdin */
    putchar(c);
    if (ReadHeader(fp, header) != 0)
      return 1;
    AddHeaderInfo(header, argc, argv);
    PrintHeader(stdout, header);
    first = 0;

    while ((read_error = ReadEntry(fp, entry)) == 0) {
      PrintEntry(stdout, entry);
    }

    if (read_error == 1)
      return 1;
  }

  while ((s = GetFilename(cmdarg)) != NULL) {
    if ((fp = fopen(s, "r")) == NULL) {
      fprintf(stderr, "joincol: Error in opening file '%s'\n", s);
      return 1; }

    if (ReadHeader(fp, header) != 0)
      return 1;

    if (first == 1) {
      AddHeaderInfo(header, argc, argv);
      PrintHeader(stdout, header);
      first = 0;
    }

    while ((read_error = ReadEntry(fp, entry)) == 0) {
      PrintEntry(stdout, entry);
    }

    if (fclose(fp) != 0) {
      fprintf(stderr, "joincol: Error in closing file\n");
      return 1; }

    if (read_error == 1)
      return 1;
  }

  return 0;
}

void usage(void)
{
  fprintf(stderr, "usage: joincol <files>\n");
}
