/**
 *  SARSE, Semi-Automated RNA Sequence Editor. Copyright (C) 2004 Allan
 *  Lind-Thomsen This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version. This program is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 *  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *  Public License for more details. You should have received a copy of the GNU
 *  General Public License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 */
package dk.kvl.alignmenttools.io;

import java.io.*;
import java.util.*;
import javax.swing.*;
import dk.kvl.tools.*;
import dk.kvl.sequencetools.*;
import dk.kvl.alignmenttools.*;

/**
 *  This class reads a file and stores each line seperatle
 *
 * @author     Allan
 * @created    January 8, 2004
 */
public class WideFileReader extends BufferedReader implements AlignmentReader
{
    private int counter = 1;
    private Hashtable sequences = new Hashtable();
    private Hashtable pairingMasks = new Hashtable();
    //private Hashtable undefinedSequences = new Hashtable();
    private int alphabet = SequenceAlphabet.RNAALPHABET;//hack
    private int number = 1;


    /**
     *  Constructor for the WideFileReader object
     *
     * @param  aReader          Description of the Parameter
     * @exception  IOException  Description of the Exception
     */

    public WideFileReader(Reader aReader) throws IOException
    {
        super(aReader);
        //indls og gem linierne
        readLines();
        close();
    }


    /**
     *  Creates a filereader from a filename to be used in the constructor
     *
     * @param  fileName                   Description of the Parameter
     * @return                            A instance of the FileReader class
     * @exception  FileNotFoundException  Thrown if the file dosn't exists
     */
    public static FileReader getFileReader(String fileName) throws FileNotFoundException
    {
        return new FileReader(new File(fileName));
    }


    /**
     *  Gets the fileReader attribute of the WideFileReader class
     *
     * @param  file                       Description of the Parameter
     * @return                            The fileReader value
     * @exception  FileNotFoundException  Description of the Exception
     */
    public static FileReader getFileReader(File file) throws FileNotFoundException
    {
        return new FileReader(file);
    }


    /**
     *  Reads the lines and
     *
     * @exception  IOException  Description of the Exception
     */
    protected void readLines() throws IOException
    {
        String line = null;
        while (ready())
        {//det er vist ikke sikkert den er f�rdig
            line = readLine();
            if (!line.equals(""))
            {
                saveLine(line);
            }
        }
    }


    /**
     *  Description of the Method
     *
     * @param  line  Description of the Parameter
     */
    protected void saveLine(String line)
    {
        //String[] seq = StringTools.split(line, '\t');
    	String[] seq = line.trim().split("\\s+");
        //System.out.println("name="+seq[0]);
        //System.out.println(seq[1]);
        if(seq.length < 2)
        {
        	seq = StringTools.split(line, ' ');
        }
        Sequence aSequence = null;
        //If there is only one string it is asumed it is a sequence
        //and a generic title is made else [0] is key and [1] sequence
        if (seq == null)
        {
            //System.out.println("WideFileReader: saveLine: Empty string");//change
            return;
        }
        else if (seq[1] == null)
        {
            seq[1] = seq[0];
            seq[0] = "seq" + counter;

        }
        if (seq[0].startsWith("pair") || seq[0].startsWith("Pair"))
        {
            try
            {
                aSequence = new PairingMask(seq[0], seq[1], SequenceAlphabet.PAIRINGMASK, true);
                pairingMasks.put(seq[0], aSequence);
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
        else
        {
            try
            {
                if (sequences.get(seq[0]) == null)
                {
                    aSequence = new Sequence(seq[0], seq[1], alphabet, true);
                    aSequence.setNumber(number);
                    number++;
                    sequences.put(seq[0], aSequence);
                }
                else
                {
                    JOptionPane.showMessageDialog(null, "Adding sequence: "+seq[0]+" is cancelled.\n because a sequence with that name allready exsists.");
                }
            }
            catch (Exception e)
            {
                //aSequence = new Sequence(seq[0], seq[1], SequenceAlphabet.UNDEFINED, true);
                //sequences.put(seq[0], aSequence);
            }
        }
        /*
         *  }
         *  catch (Exception e)
         *  {
         *  e.printStackTrace();
         *  }
         */
    }


    /**
     *  Gets the keys for the sequences
     *
     * @return    The keys value
     */
    public Enumeration getKeys()
    {
        return sequences.keys();
    }


    /**
     *  Gets the sequence attribute of the WideFileReader object
     *
     * @param  key  Description of the Parameter
     * @return      The sequence value
     */
    public String getSequence(String key)
    {
        return (String)sequences.get(key);
    }


    /**
     *  Gets the sequences attribute of the WideFileReader object
     *
     * @return    The sequences value
     */
    public Hashtable getSequences()
    {
        return sequences;
    }


    /**
     *  Gets the pairingMasks attribute of the WideFileReader object
     *
     * @return    The pairingMasks value
     */
    public Hashtable getPairingMasks()
    {
        return pairingMasks;
    }


    /**
     *  Gets the alignment attribute of the WideFileReader object
     *
     * @return    The alignment value
     */
    public Alignment getAlignment()
    {
        Alignment alignment = new Alignment(sequences, pairingMasks);
        if (alignment.getPairingMask() != null)
        {
            alignment.updatePairings();
        }
        else
        {
            alignment.toLowerCase();
        }
        alignment.emptyInfo();
        return alignment;
    }
}

