/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.controller;

import dk.kvl.alignmenttools.*;
import dk.kvl.alignmenttools.io.*;
import dk.kvl.tools.io.*;
import dk.kvl.tools.*;
import java.io.*;
import java.io.IOException;
import javax.swing.*;
import javax.swing.filechooser.*;
import dk.kvl.gui.properties.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    March 12, 2004
 */
public class AlignmentIOController
{
	private static boolean error;
	/**
	 *  Description of the Method
	 *
	 * @param  alignment        Description of the Parameter
	 * @param  outFile          Description of the Parameter
	 * @param  outFormat        Description of the Parameter
	 * @exception  IOException  Description of the Exception
	 */
	public static void saveAlignment(Alignment alignment, File outFile, int outFormat) throws IOException
	{
		if (outFormat == AlignmentWriter.COL)
		{
			new ColWriter(outFile, alignment);
		}
		else if (outFormat == AlignmentWriter.TXT)
		{
			new WideFileWriter(alignment, outFile);
		}
		else if (outFormat == AlignmentWriter.FASTA)
		{
			new FastaWriter(alignment, outFile);
		}
		else
		{
			throw new IOException("Unknown file format!");
		}
	}
	
	
	/**
	 *  Description of the Method
	 *
	 * @param  inFile           Description of the Parameter
	 * @param  inFormat         Description of the Parameter
	 * @return                  Description of the Return Value
	 * @exception  IOException  Description of the Exception
	 */
	public static Alignment loadAlignment(File inFile, int inFormat) throws IOException
	{
		AlignmentReader ar = null;
		if (inFormat == AlignmentWriter.COL)
		{
			ar = new ColReader(inFile);
		}
		else if (inFormat == AlignmentWriter.TXT)
		{
			ar = new WideFileReader(WideFileReader.getFileReader(inFile));
		}
		else if (inFormat == AlignmentWriter.FASTA)
		{
			ar = new FastaReader(inFile);
		}
		else
		{
			throw new IOException("Unknown file format!");
		}
		if (ar != null)
		{
			return ar.getAlignment();
		}
		else
		{
			return null;
		}
	}
	
	public static void export(Alignment alignment, ProjectProperties prop)
	{
		JFileChooser chooser = new JFileChooser();
		//chooser.addChoosableFileFilter(new LineFilter());
		chooser.addChoosableFileFilter(new TxtFilter());
		chooser.addChoosableFileFilter(new ColFilter());
		chooser.addChoosableFileFilter(new FastaFilter());
		chooser.setAcceptAllFileFilterUsed(false);
		int choice = chooser.showSaveDialog(null);
		if (choice == chooser.APPROVE_OPTION)
		{
			javax.swing.filechooser.FileFilter ff = chooser.getFileFilter();
			File f = chooser.getSelectedFile();
			if(ff instanceof TxtFilter)
			{
				if (f.getName().indexOf('.') == -1){
					f = new File(f.getAbsolutePath() + ".txt");
				}
				saveTxt(alignment, f);
			}
			else if(ff instanceof ColFilter)
			{
				if (f.getName().indexOf('.') == -1){
					f = new File(f.getAbsolutePath() + ".col");
				}
				saveCol(alignment, f);
			}
			else if (ff instanceof FastaFilter){
				if (f.getName().indexOf('.') == -1){
					f = new File(f.getAbsolutePath() + ".fasta");
				}
				saveFasta(alignment, f);
				
			}
			
		}
	}
		
		protected static void saveFasta(Alignment alignment, File f)
		{
			try
			{
				if(f.exists())
				{
					f.delete();
				}
				new FastaWriter( alignment,f);
			}
			catch(IOException ioe)
			{
				ioe.printStackTrace();
			}
		}
		
		public static void setError(boolean hasError){
			error = hasError;
		}
		
		public static void saveTxt(Alignment alignment, File file)
		{
			try
			{
				new WideFileWriter(alignment, file);
			}
			catch(IOException ioe)
			{
				ioe.printStackTrace();
			}
		}
		
		public static void saveCol(Alignment alignment, File file)
		{
			try
			{
				new ColWriter(file, alignment);
			}
			catch(IOException ioe)
			{
				ioe.printStackTrace();
			}
		}
		
		public static void saveHistory(FileHistory history, String projectDir) throws IOException
		{
			File hDir = new File(projectDir+"/history");
			if(!hDir.exists())
			{
				hDir.mkdirs();
				
			}
			File historyFile = new File(hDir+"/filehistory");
			if(!historyFile.exists())
			{
				historyFile.createNewFile();
			}
			ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(historyFile));
			oos.writeObject(history);
			oos.close();
		}
		
		public static FileHistory loadHistory(String projectDir)throws IOException, ClassNotFoundException
		{
			File historyFile = new File(projectDir+"/history/filehistory");
			if(historyFile.exists())
			{
				ObjectInputStream oos = new ObjectInputStream(new FileInputStream(historyFile));
				FileHistory hist = (FileHistory)oos.readObject();
				oos.close();
				return hist;
			}
			else
			{
				return null;
			}
		}
		
		/*public static History loadSubHistory(String projectDir, String fileName)throws IOException, ClassNotFoundException
		 {
		 File historyFile = new File(projectDir + "/history/filename/history");
		 if(historyFile.exists())
		 {
		 ObjectInputStream oos = new ObjectInputStream(new FileInputStream(historyFile));
		 History hist = (History)oos.readObject();
		 oos.close();
		 return hist;
		 }
		 else
		 {
		 return null;
		 }
		 }*/
		
		/*public static void saveSubHistory(History history, String projectDir, String fileName) throws IOException
		 {
		 File hDir = new File(projectDir+"/history/fileName");
		 if(!hDir.exists())
		 {
		 hDir.mkdirs();
		 
		 }
		 File historyFile = new File(hDir+"/history");
		 if(!historyFile.exists())
		 {
		 historyFile.createNewFile();
		 }
		 ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(historyFile));
		 oos.writeObject(history);
		 oos.close();
		 }*/
	}
	
