/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.controller;

import dk.kvl.gui.properties.*;
import java.util.*;
import java.io.*;
import javax.swing.*;

public class ProjectController
{
    private Hashtable projects;
    public ProjectController()
    {
        loadProjects();
    }
    
    protected void loadProjects()
    {
        projects = new Hashtable();
        File pDir = new File(AlignmentProperties.getProjectDir());
        String[] fileList = pDir.list();
	if(fileList != null)
	    {
        for (int i = 0; i < fileList.length; i++)
        {
            if (fileList[i].endsWith(".prj"))
            {
                try
                {
                ProjectProperties p = new ProjectProperties(fileList[i]);
                projects.put(p.getName(),p);
                }
                catch(IOException ie)
                {
                    ie.printStackTrace();
                }
            }
		    
        }
	    }
    }
    
    public String[] getProjectNames()
    {
	loadProjects();
    String[] names = new String[projects.size()];
    Enumeration e = projects.keys();
    int counter = 0;
    while(e.hasMoreElements())
    {
    names[counter] = (String)e.nextElement();
    counter++;
    }
    return names;
    }
    
    public void addProject(String name, String file, String path)
    {
        ProjectProperties p = new ProjectProperties(name, file, path);
        try
        {
        p.store();
        projects.put(name, p);
        }
        catch(IOException ie)
        {
            ie.printStackTrace();
            JOptionPane.showMessageDialog(null,"The projectfile could not be created!");
        }
    }
    
    public void removeProject()
    {
    }
    
    public ProjectProperties getProjectProperties(String name)
    {
        return (ProjectProperties)projects.get(name);
    }
}
